/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.common.rest.sam;

import com.appdynamics.sim.common.rest.sam.HttpHeaderDto;
import com.appdynamics.sim.common.rest.sam.SamTargetHttpMethodDto;
import com.appdynamics.sim.common.rest.sam.SamValidationRuleDto;
import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.appdynamics.voltron.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@UiCodeGen
@TSCodeGen(exclude=true)
public class SamTargetHttpConfigDto {
    @NotNull(message="Sam Target must NOT be null")
    private String target;
    @Min(value=1L, message="Ping interval in seconds must be greater than or equal to 1")
    private long pingIntervalSeconds;
    @Min(value=1L, message="Failure threshold must be greater than or equal to 0")
    private int failureThreshold;
    @Min(value=1L, message="Success threshold must be greater than or equal to 1")
    private int successThreshold;
    @Min(value=1L, message="Threshold window must be greater than or equal to 1")
    private int thresholdWindow;
    @Min(value=1L, message="Connect timeout in ms must be greater than or equal to 1")
    private int connectTimeoutMillis;
    @Min(value=1L, message="Socket timeout in ms must be greater than or equal to 1")
    private int socketTimeoutMillis;
    @NotNull(message="HTTP method must be specified ")
    private SamTargetHttpMethodDto method;
    @Min(value=1L, message="Download size must be greater than or equal to 1")
    private int downloadSize;
    private boolean followRedirects;
    private List<HttpHeaderDto> headers;
    private String body;
    @NotNull(message="Validation rules must be specified")
    private List<SamValidationRuleDto> validationRules;

    @JsonIgnore
    public String getRequestString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.name()).append(" ").append(this.target);
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("\n");
            for (HttpHeaderDto header : this.headers) {
                sb.append("\n");
                sb.append(header.toHeaderString());
            }
        }
        if (!StringUtil.isBlank((String)this.body)) {
            sb.append("\n\n");
            sb.append(this.body);
        }
        return sb.toString();
    }

    public static SamTargetHttpConfigDtoBuilder builder() {
        return new SamTargetHttpConfigDtoBuilder();
    }

    public String getTarget() {
        return this.target;
    }

    public long getPingIntervalSeconds() {
        return this.pingIntervalSeconds;
    }

    public int getFailureThreshold() {
        return this.failureThreshold;
    }

    public int getSuccessThreshold() {
        return this.successThreshold;
    }

    public int getThresholdWindow() {
        return this.thresholdWindow;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    public SamTargetHttpMethodDto getMethod() {
        return this.method;
    }

    public int getDownloadSize() {
        return this.downloadSize;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public List<HttpHeaderDto> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public List<SamValidationRuleDto> getValidationRules() {
        return this.validationRules;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setPingIntervalSeconds(long pingIntervalSeconds) {
        this.pingIntervalSeconds = pingIntervalSeconds;
    }

    public void setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public void setSuccessThreshold(int successThreshold) {
        this.successThreshold = successThreshold;
    }

    public void setThresholdWindow(int thresholdWindow) {
        this.thresholdWindow = thresholdWindow;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public void setSocketTimeoutMillis(int socketTimeoutMillis) {
        this.socketTimeoutMillis = socketTimeoutMillis;
    }

    public void setMethod(SamTargetHttpMethodDto method) {
        this.method = method;
    }

    public void setDownloadSize(int downloadSize) {
        this.downloadSize = downloadSize;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setHeaders(List<HttpHeaderDto> headers) {
        this.headers = headers;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setValidationRules(List<SamValidationRuleDto> validationRules) {
        this.validationRules = validationRules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SamTargetHttpConfigDto)) {
            return false;
        }
        SamTargetHttpConfigDto other = (SamTargetHttpConfigDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        if (this.getPingIntervalSeconds() != other.getPingIntervalSeconds()) {
            return false;
        }
        if (this.getFailureThreshold() != other.getFailureThreshold()) {
            return false;
        }
        if (this.getSuccessThreshold() != other.getSuccessThreshold()) {
            return false;
        }
        if (this.getThresholdWindow() != other.getThresholdWindow()) {
            return false;
        }
        if (this.getConnectTimeoutMillis() != other.getConnectTimeoutMillis()) {
            return false;
        }
        if (this.getSocketTimeoutMillis() != other.getSocketTimeoutMillis()) {
            return false;
        }
        SamTargetHttpMethodDto this$method = this.getMethod();
        SamTargetHttpMethodDto other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        if (this.getDownloadSize() != other.getDownloadSize()) {
            return false;
        }
        if (this.isFollowRedirects() != other.isFollowRedirects()) {
            return false;
        }
        List<HttpHeaderDto> this$headers = this.getHeaders();
        List<HttpHeaderDto> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        List<SamValidationRuleDto> this$validationRules = this.getValidationRules();
        List<SamValidationRuleDto> other$validationRules = other.getValidationRules();
        return !(this$validationRules == null ? other$validationRules != null : !((Object)this$validationRules).equals(other$validationRules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SamTargetHttpConfigDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        long $pingIntervalSeconds = this.getPingIntervalSeconds();
        result = result * 59 + (int)($pingIntervalSeconds >>> 32 ^ $pingIntervalSeconds);
        result = result * 59 + this.getFailureThreshold();
        result = result * 59 + this.getSuccessThreshold();
        result = result * 59 + this.getThresholdWindow();
        result = result * 59 + this.getConnectTimeoutMillis();
        result = result * 59 + this.getSocketTimeoutMillis();
        SamTargetHttpMethodDto $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        result = result * 59 + this.getDownloadSize();
        result = result * 59 + (this.isFollowRedirects() ? 79 : 97);
        List<HttpHeaderDto> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        List<SamValidationRuleDto> $validationRules = this.getValidationRules();
        result = result * 59 + ($validationRules == null ? 43 : ((Object)$validationRules).hashCode());
        return result;
    }

    public String toString() {
        return "SamTargetHttpConfigDto(target=" + this.getTarget() + ", pingIntervalSeconds=" + this.getPingIntervalSeconds() + ", failureThreshold=" + this.getFailureThreshold() + ", successThreshold=" + this.getSuccessThreshold() + ", thresholdWindow=" + this.getThresholdWindow() + ", connectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", socketTimeoutMillis=" + this.getSocketTimeoutMillis() + ", method=" + (Object)((Object)this.getMethod()) + ", downloadSize=" + this.getDownloadSize() + ", followRedirects=" + this.isFollowRedirects() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", validationRules=" + this.getValidationRules() + ")";
    }

    @ConstructorProperties(value={"target", "pingIntervalSeconds", "failureThreshold", "successThreshold", "thresholdWindow", "connectTimeoutMillis", "socketTimeoutMillis", "method", "downloadSize", "followRedirects", "headers", "body", "validationRules"})
    public SamTargetHttpConfigDto(String target, long pingIntervalSeconds, int failureThreshold, int successThreshold, int thresholdWindow, int connectTimeoutMillis, int socketTimeoutMillis, SamTargetHttpMethodDto method, int downloadSize, boolean followRedirects, List<HttpHeaderDto> headers, String body, List<SamValidationRuleDto> validationRules) {
        this.target = target;
        this.pingIntervalSeconds = pingIntervalSeconds;
        this.failureThreshold = failureThreshold;
        this.successThreshold = successThreshold;
        this.thresholdWindow = thresholdWindow;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.socketTimeoutMillis = socketTimeoutMillis;
        this.method = method;
        this.downloadSize = downloadSize;
        this.followRedirects = followRedirects;
        this.headers = headers;
        this.body = body;
        this.validationRules = validationRules;
    }

    public SamTargetHttpConfigDto() {
    }

    public static class SamTargetHttpConfigDtoBuilder {
        private String target;
        private long pingIntervalSeconds;
        private int failureThreshold;
        private int successThreshold;
        private int thresholdWindow;
        private int connectTimeoutMillis;
        private int socketTimeoutMillis;
        private SamTargetHttpMethodDto method;
        private int downloadSize;
        private boolean followRedirects;
        private List<HttpHeaderDto> headers;
        private String body;
        private List<SamValidationRuleDto> validationRules;

        SamTargetHttpConfigDtoBuilder() {
        }

        public SamTargetHttpConfigDtoBuilder target(String target) {
            this.target = target;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder pingIntervalSeconds(long pingIntervalSeconds) {
            this.pingIntervalSeconds = pingIntervalSeconds;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder failureThreshold(int failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder successThreshold(int successThreshold) {
            this.successThreshold = successThreshold;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder thresholdWindow(int thresholdWindow) {
            this.thresholdWindow = thresholdWindow;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder connectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder method(SamTargetHttpMethodDto method) {
            this.method = method;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder downloadSize(int downloadSize) {
            this.downloadSize = downloadSize;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder followRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder headers(List<HttpHeaderDto> headers) {
            this.headers = headers;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder body(String body) {
            this.body = body;
            return this;
        }

        public SamTargetHttpConfigDtoBuilder validationRules(List<SamValidationRuleDto> validationRules) {
            this.validationRules = validationRules;
            return this;
        }

        public SamTargetHttpConfigDto build() {
            return new SamTargetHttpConfigDto(this.target, this.pingIntervalSeconds, this.failureThreshold, this.successThreshold, this.thresholdWindow, this.connectTimeoutMillis, this.socketTimeoutMillis, this.method, this.downloadSize, this.followRedirects, this.headers, this.body, this.validationRules);
        }

        public String toString() {
            return "SamTargetHttpConfigDto.SamTargetHttpConfigDtoBuilder(target=" + this.target + ", pingIntervalSeconds=" + this.pingIntervalSeconds + ", failureThreshold=" + this.failureThreshold + ", successThreshold=" + this.successThreshold + ", thresholdWindow=" + this.thresholdWindow + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", socketTimeoutMillis=" + this.socketTimeoutMillis + ", method=" + (Object)((Object)this.method) + ", downloadSize=" + this.downloadSize + ", followRedirects=" + this.followRedirects + ", headers=" + this.headers + ", body=" + this.body + ", validationRules=" + this.validationRules + ")";
        }
    }
}

