/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.common.rest.machines;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.appdynamics.voltron.serialization.SimDtoSerializationModule;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UiCodeGen
@TSCodeGen(exclude=true)
public class GenericConfig {
    private static final Logger log = LoggerFactory.getLogger(GenericConfig.class);
    public static final GenericConfig EMPTY = new GenericConfig(Collections.emptyMap(), new ObjectMapper());
    private final Map<String, Object> rawConfig;
    @JacksonInject
    @JsonIgnore
    private volatile transient ObjectMapper objectMapper;
    private volatile transient Map<String, Object> deserialized;

    public GenericConfig(@NonNull Map<String, Object> rawConfig, @NonNull ObjectMapper objectMapper) {
        if (rawConfig == null) {
            throw new NullPointerException("rawConfig");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper");
        }
        this.rawConfig = rawConfig;
        this.objectMapper = objectMapper;
    }

    @JsonCreator
    private GenericConfig(@JsonProperty(value="rawConfig") @NonNull Map<String, Object> rawConfig) {
        if (rawConfig == null) {
            throw new NullPointerException("rawConfig");
        }
        this.rawConfig = rawConfig;
        this.deserialized = rawConfig;
    }

    public <T> Optional<T> of(String configName, TypeReference<T> configType) {
        Object config = this.rawConfig.get(configName);
        if (config == null) {
            return Optional.absent();
        }
        return Optional.of((Object)this.getObjectMapper().convertValue(config, configType));
    }

    public <T> Optional<T> of(String configName, Class<T> configType) {
        Object config = this.rawConfig.get(configName);
        if (config == null) {
            return Optional.absent();
        }
        return Optional.of((Object)this.getObjectMapper().convertValue(config, configType));
    }

    public String serialized() {
        try {
            return this.objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unexpected exception serializing config " + this, e);
        }
    }

    @JsonIgnore
    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = SimDtoSerializationModule.buildObjectMapper();
        }
        this.objectMapper.registerModule((Module)new GuavaModule());
        return this.objectMapper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericConfig that = (GenericConfig)o;
        if (Objects.equal(this.rawConfig, that.rawConfig)) {
            return true;
        }
        boolean equals = this.asDeserialized().equals(that.asDeserialized());
        return equals;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.asDeserialized()});
    }

    public String toString() {
        return this.asDeserialized().toString();
    }

    private Map<String, Object> asDeserialized() {
        if (this.deserialized == null) {
            try {
                this.deserialized = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(this.rawConfig), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                log.warn("Could not convert " + this.rawConfig + " to normalized form.", (Throwable)e);
                this.deserialized = this.rawConfig;
            }
        }
        return this.deserialized;
    }

    public static Builder builder(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper");
        }
        return new Builder(objectMapper);
    }

    public Map<String, Object> getRawConfig() {
        return this.rawConfig;
    }

    public static class Builder {
        private final ObjectMapper objectMapper;
        private final ImmutableMap.Builder<String, Object> configMapBuilder;

        private Builder(@NonNull ObjectMapper objectMapper) {
            if (objectMapper == null) {
                throw new NullPointerException("objectMapper");
            }
            this.objectMapper = objectMapper;
            this.configMapBuilder = ImmutableMap.builder();
        }

        public Builder put(@NonNull String configName, @NonNull Object configObject) {
            if (configName == null) {
                throw new NullPointerException("configName");
            }
            if (configObject == null) {
                throw new NullPointerException("configObject");
            }
            this.configMapBuilder.put((Object)configName, configObject);
            return this;
        }

        public GenericConfig build() {
            ImmutableMap configMap = this.configMapBuilder.build();
            GenericConfig genericConfig = new GenericConfig((Map<String, Object>)configMap, this.objectMapper);
            return genericConfig;
        }
    }
}

