/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.gpu.nvml;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.gpu.GpuMetricDataCollector;
import com.appdynamics.sim.agent.extensions.gpu.GpuRawCollectorUtil;
import com.appdynamics.sim.agent.extensions.gpu.nvml.GpuNvmlMetricData;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvmlMetricDataCollector
implements GpuMetricDataCollector<GpuNvmlMetricData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NvmlMetricDataCollector.class);
    private final GpuRawCollectorUtil gpuRawCollectorUtil;
    private final Optional<GpuRawCollectorUtil.ICollectorProcessBuilder> processBuilder;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final ObjectMapper objectMapper;
    private static final GpuNvmlMetricData EMPTY_RAW_DATA = new GpuNvmlMetricData();

    @Inject
    NvmlMetricDataCollector(GpuRawCollectorUtil gpuRawCollectorUtil, Optional<GpuRawCollectorUtil.ICollectorProcessBuilder> collectorProcessBuilder, SimAgentRepetitiveLogger repetitiveLogger, ObjectMapper objectMapper) {
        this.gpuRawCollectorUtil = gpuRawCollectorUtil;
        this.processBuilder = collectorProcessBuilder;
        this.repetitiveLogger = repetitiveLogger;
        this.objectMapper = objectMapper;
    }

    @Override
    public GpuNvmlMetricData collect() {
        Optional<GpuNvmlMetricData> rawDataOpt = Optional.absent();
        try {
            long samplingIntervalMillis = SystemUtilsTranslateable.getLongProperty((String)"appdynamics.machine.agent.gpu.collection.sampling.interval", (long)30000L);
            long maxCollectionTimeMillis = this.getMaxCollectionTimeFromSamplingInterval(samplingIntervalMillis);
            if (!this.processBuilder.isPresent()) {
                this.repetitiveLogger.error(log, "Process to collect Gpu raw data is not present - skipping collection", new Object[0]);
            } else {
                GpuRawCollectorUtil.ICollectorProcessBuilder collectorProcessBuilder = (GpuRawCollectorUtil.ICollectorProcessBuilder)this.processBuilder.get();
                rawDataOpt = this.gpuRawCollectorUtil.runCollector(GpuNvmlMetricData.class, collectorProcessBuilder, this.objectMapper, this.repetitiveLogger, maxCollectionTimeMillis);
                log.debug("Raw data after running the Gpu script: " + String.valueOf(rawDataOpt));
            }
        }
        catch (Exception e) {
            log.debug("Error collecting Gpu raw data using the Gpu Collector script: {}", (Object)e.getMessage());
        }
        GpuNvmlMetricData rawData = (GpuNvmlMetricData)rawDataOpt.or((Object)EMPTY_RAW_DATA);
        return rawData;
    }

    private long getMaxCollectionTimeFromSamplingInterval(long samplingInterval) {
        return (long)((double)samplingInterval * 0.9);
    }
}

