/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.gpu.dcgm;

import com.appdynamics.agent.sim.gpu.GpuPerformanceMetricsTemplate;
import com.appdynamics.agent.sim.gpu.dcgm.GpuDcgmMetricData;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.gpu.GpuMetricDataReporter;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcgmMetricReporter
implements GpuMetricDataReporter<GpuDcgmMetricData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DcgmMetricReporter.class);
    private final MetricsService metricsService;
    private final MachineProperties machineProperties;

    @Inject
    DcgmMetricReporter(@Sim @NonNull MetricsService metricsService, @NonNull MachineProperties machineProperties) {
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        this.metricsService = metricsService;
        this.machineProperties = machineProperties;
    }

    @Override
    public void report(GpuDcgmMetricData gpuRawData) {
        try {
            Map gpus = gpuRawData.getGpus();
            long gpu_utilization_pct = 0L;
            long gpu_memory_utilization_pct = 0L;
            long totalGpus = gpus.keySet().size();
            if (totalGpus > 0L) {
                for (String gpuId : gpus.keySet()) {
                    this.formatAndReportGpuData(gpuId, (GpuDcgmMetricData.GpuData)gpus.get(gpuId));
                    gpu_utilization_pct += ((GpuDcgmMetricData.GpuData)gpus.get(gpuId)).getGpu().getUtilization();
                    gpu_memory_utilization_pct += ((GpuDcgmMetricData.GpuData)gpus.get(gpuId)).getMemory().getUtilization();
                }
                this.machineProperties.updateProperty("GPU|Total GPU Count", Long.toString(totalGpus));
                Iterator iterator = gpus.keySet().iterator();
                if (iterator.hasNext()) {
                    String gpuId;
                    gpuId = (String)iterator.next();
                    this.populateGpuLabels(((GpuDcgmMetricData.GpuData)gpus.get(gpuId)).getGpuLabels());
                }
                log.debug("Successfully reported each GPU metric data");
                this.reportAggregateData(gpu_utilization_pct / totalGpus, gpu_memory_utilization_pct / totalGpus);
                log.debug("Successfully reported aggregated GPU metric data for all the available {} GPUs", (Object)totalGpus);
            } else {
                log.debug("No GPUs found to report metrics");
                this.machineProperties.updateProperty("GPU|Total GPU Count", "0");
            }
        }
        catch (Exception e) {
            log.error("Error occurred while reporting GPU metrics: ", (Throwable)e);
        }
    }

    private void populateGpuLabels(Map<String, String> gpuLabels) {
        this.machineProperties.updateProperty("GPU|Driver Version", gpuLabels.get("device"));
        this.machineProperties.updateProperty("GPU|Model Name", gpuLabels.get("modelName"));
        this.machineProperties.updateProperty("GPU|Driver Version", gpuLabels.get("DCGM_FI_DRIVER_VERSION"));
    }

    private void formatAndReportGpuData(String gpuId, GpuDcgmMetricData.GpuData gpuData) {
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|GPU|Utilization (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getGpu().getUtilization());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|GPU|Temperature (C)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getGpu().getTemperature());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Power|Power Draw (W)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPower().getDraw());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Power|Power Limit (W)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPower().getLimit());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Power|Power Draw Instant (W)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPower().getUsed_instant());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Power|Power Draw (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPower().getDraw_pct());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Clock|Video Clock (MHz)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getClocks().getVideo());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Clock|Memory Clock (MHz)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getClocks().getMemory());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Clock|SM Clock (MHz)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getClocks().getSm());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Memory|Utilization (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getMemory().getUtilization());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Memory|Temperature (C)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getMemory().getTemperature());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Performance|P-State", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPerformance().getP_state());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Performance|PCIe Rx Throughput (MB/s)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPerformance().getRx_throughput());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Performance|PCIe Tx Throughput (MB/s)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPerformance().getTx_throughput());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Performance|Tensor Pipe Active (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPerformance().getTensor_pipe_active_pct());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Performance|DRAM Active (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPerformance().getDram_active_pct());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Performance|Graphics Engine Active (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPerformance().getGraphics_engine_active_pct());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Framebuffer Memory|Total", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getFramebuffer_memory().getTotal());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Framebuffer Memory|Used", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getFramebuffer_memory().getUsed());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Framebuffer Memory|Free", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getFramebuffer_memory().getFree());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Framebuffer Memory|Reserved", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getFramebuffer_memory().getReserved());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Framebuffer Memory|Used (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getFramebuffer_memory().getUsed_pct());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|BAR1 Memory|Total", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getBar1_memory().getTotal());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|BAR1 Memory|Used", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getBar1_memory().getUsed());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|BAR1 Memory|Free", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getBar1_memory().getFree());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|BAR1 Memory|Used (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getBar1_memory().getUsed_pct());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Compute Pipelines|FP64 Active (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getComputePipelines().getFp64_active());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Compute Pipelines|FP32 Active (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getComputePipelines().getFp32_active());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Compute Pipelines|FP16 Active (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getComputePipelines().getFp16_active());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Compute Pipelines|HMMA Active (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getComputePipelines().getHmma_active());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Compute Pipelines|IMMA Active (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getComputePipelines().getImma_active());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Compute Pipelines|DFMA Active (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getComputePipelines().getDfma_active());
    }

    private void reportAggregateData(long gpu_pct, long gpu_memory_pct) {
        this.metricsService.reportMetric("Hardware Resources|GPU|Utilization (%)", ExtensionMetricAggregatorType.OBSERVATION, gpu_pct);
        this.metricsService.reportMetric("Hardware Resources|GPU|Memory Utilization (%)", ExtensionMetricAggregatorType.OBSERVATION, gpu_memory_pct);
    }
}

