/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.gpu.dcgm;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.gpu.dcgm.GpuDcgmMetricData;
import com.appdynamics.agent.sim.prometheus.PrometheusDataFormat;
import com.appdynamics.agent.sim.prometheus.PrometheusScraper;
import com.appdynamics.agent.sim.prometheus.walkers.DcgmExporterMetricsWalker;
import com.appdynamics.agent.sim.prometheus.walkers.IPrometheusMetricsWalker;
import com.appdynamics.sim.agent.extensions.gpu.GpuMetricDataCollector;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcgmMetricDataCollector
implements GpuMetricDataCollector<GpuDcgmMetricData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DcgmMetricDataCollector.class);
    private final BootstrapConfiguration bootstrapConfiguration;
    private final String dcgmExporterServiceName;
    private final String dcgmExporterServiceNamespace;
    private final Integer dcgmExporterServicePort;
    private final String dcgmExporterServiceHost;
    private final String EMPTY_STRING = "";
    private final String DEFAULT_CLUSTER_DOMAIN = "svc.cluster.local";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_CONTEXT = "/metrics";

    @Inject
    DcgmMetricDataCollector(BootstrapConfiguration bootstrapConfiguration) {
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.dcgmExporterServiceName = this.bootstrapConfiguration.getDcgmExporterServiceName();
        this.dcgmExporterServiceNamespace = this.bootstrapConfiguration.getDcgmExporterServiceNamespace();
        this.dcgmExporterServicePort = this.bootstrapConfiguration.getDcgmExporterServicePort();
        this.dcgmExporterServiceHost = this.bootstrapConfiguration.getDcgmExporterServiceHost();
    }

    @Override
    public GpuDcgmMetricData collect() {
        URL url = null;
        try {
            url = this.getExporterUrl();
        }
        catch (MalformedURLException e) {
            log.error("DCGM Exporter metrics endpoint is malformed: ", (Throwable)e);
            return new GpuDcgmMetricData(new HashMap());
        }
        DcgmExporterMetricsWalker walker = new DcgmExporterMetricsWalker();
        GpuDcgmMetricData metricData = new GpuDcgmMetricData(new HashMap());
        try {
            PrometheusScraper scraper = new PrometheusScraper(url, PrometheusDataFormat.TEXT);
            scraper.scrape((IPrometheusMetricsWalker)walker, (Object)metricData);
            log.debug("GPU Metric Data collected through DCGM Exporter: {}", (Object)metricData);
        }
        catch (IOException e) {
            log.error("Error occurred while scraping metrics from the url: {}; Exception: {}", (Object)url, (Object)e);
        }
        return metricData;
    }

    private URL getExporterUrl() throws MalformedURLException {
        StringBuilder exporterHost = new StringBuilder();
        if (this.dcgmExporterServiceHost.equals("")) {
            exporterHost.append(this.dcgmExporterServiceName);
            exporterHost.append(".");
            exporterHost.append(this.dcgmExporterServiceNamespace);
            exporterHost.append(".");
            exporterHost.append("svc.cluster.local");
        } else {
            exporterHost.append(this.dcgmExporterServiceHost);
        }
        return new URL(DEFAULT_PROTOCOL, exporterHost.toString(), this.dcgmExporterServicePort, DEFAULT_CONTEXT);
    }
}

