/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.gpu;

import com.appdynamics.agent.sim.extensions.scheduling.CollectorProcess;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpuRawCollectorUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GpuRawCollectorUtil.class);
    private static final Map<String, String> EMPTY_ENV_VARS_MAP = Collections.emptyMap();
    private static final String SPACE = " ";
    private final Scheduler scheduler;
    static final String UTF_8_NAME = "UTF8";
    static final String CANONICAL_UTF_8_NAME = "UTF-8";
    public static final String ERROR_RESETTING_STREAM_LOG = "Encountered error resetting the stdout stream: {}";
    public static final String ERROR_CONVERTING_STDOUT_LOG = "Error converting stdout to JSON {}";
    public static final String MARK_UNSUPPORTED_LOG = "The stdout stream cannot be marked and reset to be processed when the collector script times out";
    public static final String DATA_FROM_TIMEOUT_LOG = "Even though the collector script timed out, we were still able to collect this data before the timeout {}";

    @Inject
    public GpuRawCollectorUtil(@CollectorProcess Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public <T> Optional<T> runCollector(Class<T> rawDataClass, ICollectorProcessBuilder processBuilder, ObjectMapper objectMapper, SimAgentRepetitiveLogger repetitiveLogger, long maxCollectionTimeMillis) {
        return this.runCollector(rawDataClass, processBuilder, objectMapper, new ErrorLogger(), (Optional<List<String>>)Optional.absent(), repetitiveLogger, EMPTY_ENV_VARS_MAP, maxCollectionTimeMillis);
    }

    public <T> Optional<T> runCollector(Class<T> rawDataClass, ICollectorProcessBuilder processBuilder, ObjectMapper objectMapper, Optional<List<String>> processParameters, SimAgentRepetitiveLogger repetitiveLogger, long maxCollectionTimeMillis) {
        return this.runCollector(rawDataClass, processBuilder, objectMapper, new ErrorLogger(), processParameters, repetitiveLogger, EMPTY_ENV_VARS_MAP, maxCollectionTimeMillis);
    }

    public <T> Optional<T> runCollector(Class<T> rawDataClass, ICollectorProcessBuilder processBuilder, ObjectMapper objectMapper, Optional<List<String>> processParameters, SimAgentRepetitiveLogger repetitiveLogger, Map<String, String> environmentVars, long maxCollectionTimeMillis) {
        return this.runCollector(rawDataClass, processBuilder, objectMapper, new ErrorLogger(), processParameters, repetitiveLogger, environmentVars, maxCollectionTimeMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Optional<T> runCollector(Class<T> rawDataClass, ICollectorProcessBuilder processBuilder, ObjectMapper objectMapper, ErrorLogger errorLogger, Optional<List<String>> processParameters, SimAgentRepetitiveLogger repetitiveLogger, Map<String, String> environmentVars, long maxCollectionTimeMillis) {
        Process process;
        repetitiveLogger.debug(log, "Starting collector script", new Object[0]);
        try {
            process = processBuilder.start(processParameters, environmentVars);
        }
        catch (IOException e) {
            repetitiveLogger.warn(log, "Could not collect raw data", new Object[]{e});
            return Optional.absent();
        }
        InputStream stdOutStream = process.getInputStream();
        InputStream stdErrStream = process.getErrorStream();
        try {
            ScheduledFuture future = this.scheduler.schedule(this.getProcessReaderCallable(rawDataClass, repetitiveLogger, errorLogger, process, stdOutStream, stdErrStream, objectMapper), 0L, TimeUnit.MILLISECONDS);
            repetitiveLogger.debug(log, "Waiting for collector process to finish", new Object[0]);
            Optional<T> optional = this.waitForProcessToFinishAndReturnRawData(repetitiveLogger, process, future, rawDataClass, objectMapper, stdOutStream, maxCollectionTimeMillis);
            return optional;
        }
        finally {
            try {
                if (stdOutStream != null) {
                    stdOutStream.close();
                }
                if (stdErrStream != null) {
                    stdErrStream.close();
                }
            }
            catch (IOException e) {
                repetitiveLogger.warn(log, "Streams could not be closed but data was collected", new Object[0]);
            }
        }
    }

    @VisibleForTesting
    <T> Callable<Optional<T>> getProcessReaderCallable(final Class<T> rawDataClass, final SimAgentRepetitiveLogger repetitiveLogger, final ErrorLogger errorLogger, final Process process, final InputStream stdOutStream, final InputStream stdErrStream, final ObjectMapper objectMapper) {
        return new Callable<Optional<T>>(){

            @Override
            public Optional<T> call() throws Exception {
                return GpuRawCollectorUtil.this.readProcessOutputAndConvertToRawData(rawDataClass, repetitiveLogger, errorLogger, process, stdOutStream, stdErrStream, objectMapper);
            }
        };
    }

    @VisibleForTesting
    <T> Optional<T> readProcessOutputAndConvertToRawData(Class<T> rawDataClass, SimAgentRepetitiveLogger repetitiveLogger, ErrorLogger errorLogger, Process process, InputStream stdOutStream, InputStream stdErrStream, ObjectMapper objectMapper) throws InterruptedException {
        repetitiveLogger.debug(log, "Reading output from collector script", new Object[0]);
        Object retVal = null;
        stdOutStream.mark(0);
        if (this.isDebugLoggingEnabled()) {
            String stdout = GpuRawCollectorUtil.convertStreamToString(stdOutStream);
            String stderr = GpuRawCollectorUtil.convertStreamToString(stdErrStream);
            try {
                log.trace("The stdout returned from the collector script: {}", (Object)stdout);
                String modifiedStdout = this.modifyStdoutIfJSONIsMalformed(stdout, false);
                retVal = objectMapper.readValue(modifiedStdout, rawDataClass);
                if (!StringUtils.isBlank((CharSequence)stderr)) {
                    repetitiveLogger.debug(log, "The collector script returned with these messages:\n {}", new Object[]{stderr});
                }
            }
            catch (IOException e) {
                errorLogger.logErrors(e, stdout, stderr);
            }
        } else {
            try {
                retVal = this.readValueBasedOnEncoding(rawDataClass, stdOutStream, objectMapper);
            }
            catch (IOException e) {
                repetitiveLogger.warn(log, "An error occurred while running the collector script. Enable debug logging for more information", new Object[]{e});
            }
        }
        int exitVal = process.waitFor();
        log.trace("The exitValue for the collector script process: {}", (Object)exitVal);
        return Optional.fromNullable(retVal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readValueBasedOnEncoding(Class<T> rawDataClass, InputStream stdOutStream, ObjectMapper objectMapper) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(stdOutStream);){
            T retVal = this.tryReadingDirectlyFromStream(rawDataClass, isr, stdOutStream, objectMapper);
            if (retVal != null) {
                T t = retVal;
                return t;
            }
            String stdout = GpuRawCollectorUtil.convertStreamToString(stdOutStream);
            String modifiedStdout = this.modifyStdoutIfJSONIsMalformed(stdout, false);
            Object object = objectMapper.readValue(modifiedStdout, rawDataClass);
            return (T)object;
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Could not handle the stdout stream encoding", (Throwable)e);
            return null;
        }
    }

    private <T> T tryReadingDirectlyFromStream(Class<T> rawDataClass, InputStreamReader isr, InputStream stdOutStream, ObjectMapper objectMapper) throws IOException {
        if (isr.getEncoding().equals(CANONICAL_UTF_8_NAME) || isr.getEncoding().equals(UTF_8_NAME)) {
            try {
                return (T)objectMapper.readValue(stdOutStream, rawDataClass);
            }
            catch (JsonParseException | JsonMappingException e) {
                log.warn("Cannot read directly from the stdout stream due to JSON errors");
            }
        }
        return null;
    }

    private String modifyStdoutIfJSONIsMalformed(String stdout, boolean fromTimeout) {
        String modifiedStdout = GpuRawCollectorUtil.fixJSONIfNecessary(stdout);
        if (!stdout.equals(modifiedStdout)) {
            if (fromTimeout) {
                log.warn("Fixing the incomplete JSON due to the collector script timing out");
            } else {
                log.warn("JSON payload was malformed so the modified stdout is: {}", (Object)modifiedStdout);
            }
        }
        return modifiedStdout;
    }

    @VisibleForTesting
    <T> Optional<T> waitForProcessToFinishAndReturnRawData(SimAgentRepetitiveLogger repetitiveLogger, Process process, ScheduledFuture<Optional<T>> future, Class<T> rawDataClass, ObjectMapper objectMapper, InputStream stdOutStream, long maxCollectionTimeMillis) {
        try {
            Optional retVal = (Optional)future.get(maxCollectionTimeMillis, TimeUnit.MILLISECONDS);
            if (retVal.isPresent()) {
                log.trace("#SIM000128 Obtained raw data from the collector script: {}", (Object)retVal);
            }
            int exitVal = 0;
            try {
                repetitiveLogger.debug(log, "Checking collector process exit status", new Object[0]);
                exitVal = process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                repetitiveLogger.debug(log, "Destroying collector process. An error occurred while getting the exitValue: {}", new Object[]{e});
                process.destroy();
            }
            if (exitVal != 0) {
                String exitError = GpuRawCollectorUtil.convertStreamToString(process.getErrorStream());
                repetitiveLogger.error(log, "Non-zero exit value ({}). Could not execute data collection script: {}", new Object[]{exitVal, exitError});
            }
            return retVal;
        }
        catch (TimeoutException t) {
            Object retVal;
            repetitiveLogger.warn(log, "Collector process did not finish in {} milliseconds", new Object[]{maxCollectionTimeMillis});
            if (stdOutStream.markSupported()) {
                try {
                    stdOutStream.reset();
                }
                catch (IOException ioe) {
                    repetitiveLogger.warn(log, ERROR_RESETTING_STREAM_LOG, new Object[]{ioe.getMessage()});
                    process.destroy();
                    return Optional.absent();
                }
            } else {
                repetitiveLogger.warn(log, MARK_UNSUPPORTED_LOG, new Object[0]);
                process.destroy();
                return Optional.absent();
            }
            String stdout = GpuRawCollectorUtil.convertStreamToString(stdOutStream);
            try {
                String modifiedStdout = this.modifyStdoutIfJSONIsMalformed(stdout, true);
                retVal = objectMapper.readValue(modifiedStdout, rawDataClass);
            }
            catch (IOException ioe) {
                repetitiveLogger.warn(log, ERROR_CONVERTING_STDOUT_LOG, new Object[]{ioe.getMessage()});
                process.destroy();
                return Optional.absent();
            }
            repetitiveLogger.debug(log, DATA_FROM_TIMEOUT_LOG, new Object[]{retVal});
            process.destroy();
            return Optional.fromNullable((Object)retVal);
        }
        catch (InterruptedException i) {
            repetitiveLogger.warn(log, "Interrupted while waiting for data collection to complete", new Object[0]);
            process.destroy();
            return Optional.absent();
        }
        catch (ExecutionException e) {
            repetitiveLogger.warn(log, "An ExecutionException occurred while waiting for data collectionto complete: {}", new Object[]{e});
            process.destroy();
            return Optional.absent();
        }
        catch (CancellationException c) {
            repetitiveLogger.warn(log, "A CancellationException occurred while waiting for data collectionto complete: {}", new Object[]{c});
            process.destroy();
            return Optional.absent();
        }
    }

    @VisibleForTesting
    boolean isDebugLoggingEnabled() {
        return log.isDebugEnabled();
    }

    private static String convertStreamToString(InputStream is) {
        String output;
        try {
            output = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            log.warn("Could not convert stream to string", (Throwable)e);
            output = "";
        }
        return output;
    }

    @VisibleForTesting
    static String fixJSONIfNecessary(String stdout) {
        int openCurlyBraceCounter = 0;
        int closedCurlyBraceCounter = 0;
        for (int i = 0; i < stdout.length(); ++i) {
            char c = stdout.charAt(i);
            if (c == '{') {
                ++openCurlyBraceCounter;
            }
            if (c != '}') continue;
            ++closedCurlyBraceCounter;
        }
        if (closedCurlyBraceCounter == 0) {
            return "{}";
        }
        if (openCurlyBraceCounter == closedCurlyBraceCounter) {
            return stdout;
        }
        Object modifiedJSONString = stdout.substring(0, stdout.lastIndexOf("}") + 1);
        int newOpenCurlyBraceCounter = 0;
        for (int i = 0; i < ((String)modifiedJSONString).length(); ++i) {
            char c = stdout.charAt(i);
            if (c != '{') continue;
            ++newOpenCurlyBraceCounter;
        }
        int additionalClosingCurlyBracesNeeded = newOpenCurlyBraceCounter - closedCurlyBraceCounter;
        for (int i = 0; i < additionalClosingCurlyBracesNeeded; ++i) {
            modifiedJSONString = (String)modifiedJSONString + " }";
        }
        return modifiedJSONString;
    }

    static class ErrorLogger {
        ErrorLogger() {
        }

        void logErrors(Exception e, String stdout, String stderr) {
            log.error("Could not collect raw data", (Throwable)e);
            log.error("The standard out from the collector script was: {}", (Object)stdout);
            log.warn("The error log from the collector script was: {}", (Object)stderr);
        }
    }

    public static interface ICollectorProcessBuilder {
        public Process start(Optional<List<String>> var1, Map<String, String> var2) throws IOException;

        public List<String> getCommand();

        public Optional<String> getCollectorScriptContent();
    }

    public static class LocalCollectorProcessBuilder
    implements ICollectorProcessBuilder {
        private List<String> command;
        private Optional<String> collectorScriptContent;

        @Override
        public Process start(Optional<List<String>> processParameters, Map<String, String> environmentVars) throws IOException {
            Process startProcess;
            List<String> commandToExecute = this.command;
            if (this.collectorScriptContent.isPresent()) {
                startProcess = this.createProcessBuilder(commandToExecute, environmentVars).start();
                try (OutputStream stdin = startProcess.getOutputStream();){
                    String machineAgentScriptString = (String)this.collectorScriptContent.get();
                    stdin.write(machineAgentScriptString.getBytes());
                    if (processParameters.isPresent()) {
                        Joiner joiner = Joiner.on((String)GpuRawCollectorUtil.SPACE);
                        String parametersInString = joiner.join((Iterable)processParameters.get());
                        stdin.write(parametersInString.getBytes());
                    }
                }
                catch (IOException e) {
                    log.warn("Could not pipe into stdin", (Throwable)e);
                }
            } else {
                if (processParameters.isPresent()) {
                    commandToExecute = new LinkedList<String>(this.command);
                    commandToExecute.addAll((Collection)processParameters.get());
                }
                startProcess = this.createProcessBuilder(commandToExecute, environmentVars).start();
            }
            return startProcess;
        }

        ProcessBuilder createProcessBuilder(List<String> command, Map<String, String> environmentVars) {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.environment().putAll(environmentVars);
            return processBuilder;
        }

        @Override
        @Generated
        public List<String> getCommand() {
            return this.command;
        }

        @Override
        @Generated
        public Optional<String> getCollectorScriptContent() {
            return this.collectorScriptContent;
        }

        @Generated
        public void setCommand(List<String> command) {
            this.command = command;
        }

        @Generated
        public void setCollectorScriptContent(Optional<String> collectorScriptContent) {
            this.collectorScriptContent = collectorScriptContent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalCollectorProcessBuilder)) {
                return false;
            }
            LocalCollectorProcessBuilder other = (LocalCollectorProcessBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$command = this.getCommand();
            List<String> other$command = other.getCommand();
            if (this$command == null ? other$command != null : !((Object)this$command).equals(other$command)) {
                return false;
            }
            Optional<String> this$collectorScriptContent = this.getCollectorScriptContent();
            Optional<String> other$collectorScriptContent = other.getCollectorScriptContent();
            return !(this$collectorScriptContent == null ? other$collectorScriptContent != null : !this$collectorScriptContent.equals(other$collectorScriptContent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalCollectorProcessBuilder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
            Optional<String> $collectorScriptContent = this.getCollectorScriptContent();
            result = result * 59 + ($collectorScriptContent == null ? 43 : $collectorScriptContent.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GpuRawCollectorUtil.LocalCollectorProcessBuilder(command=" + String.valueOf(this.getCommand()) + ", collectorScriptContent=" + String.valueOf(this.getCollectorScriptContent()) + ")";
        }

        @Generated
        public LocalCollectorProcessBuilder(List<String> command, Optional<String> collectorScriptContent) {
            this.command = command;
            this.collectorScriptContent = collectorScriptContent;
        }
    }
}

