/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.gpu;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.gpu.GpuMetricsCollectionManager;
import com.appdynamics.voltron.utils.TimeSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpuMonitor
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GpuMonitor.class);
    @Generated
    private final Object $lock = new Object[0];
    private final Scheduler scheduler;
    private volatile ScheduledFuture<?> future;
    private volatile long scheduledInterval;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final TimeSupplier timeSupplier;
    private final GpuMetricsCollectionManager<?> gpuMetricsCollectionManager;

    @Inject
    GpuMonitor(Scheduler scheduler, GpuMetricsCollectionManager<?> gpuMetricsCollectionManager, BootstrapConfiguration bootstrapConfiguration, TimeSupplier timeSupplier) {
        this.scheduler = scheduler;
        this.gpuMetricsCollectionManager = gpuMetricsCollectionManager;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.timeSupplier = timeSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void startMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            this.scheduledInterval = SystemUtilsTranslateable.getLongProperty((String)"appdynamics.machine.agent.gpu.collection.sampling.interval", (long)30000L);
            boolean gpuEnabled = this.bootstrapConfiguration.getGpuEnabled();
            if (this.isGpuMonitoringSupportedOnCurrentOS() && this.future == null) {
                if (!gpuEnabled) {
                    log.info("Not starting gpu monitoring extension, Gpu monitoring is disabled");
                } else {
                    log.debug("Gpu monitoring enabled, scheduling Gpu monitor");
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, this.scheduledInterval, TimeUnit.MILLISECONDS);
                    log.info("Gpu monitoring started successfully");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stopMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                log.debug("Canceling Gpu monitor");
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    @Override
    public void run() {
        try {
            long start = this.timeSupplier.get();
            log.debug("Running Gpu monitoring");
            this.gpuMetricsCollectionManager.collectAndReport();
            long end = this.timeSupplier.get();
            log.debug("#Total time to execute Gpu Monitoring: {} ms", (Object)(end - start));
        }
        catch (Exception e) {
            log.error("Error running Gpu monitoring Extension: " + e.getMessage());
        }
    }

    @VisibleForTesting
    boolean isGpuMonitoringSupportedOnCurrentOS() {
        return SystemUtils.IS_OS_LINUX;
    }
}

