/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.dbmon.api.dtos;

import com.appdynamics.dbmon.api.dtos.DBServerType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public enum QueryStatType {
    EXECUTIONS(1, DBServerType.ORACLE),
    CPU_TIME(2, DBServerType.ORACLE),
    ELAPSED_TIME(3, DBServerType.ORACLE),
    ROWS_PROCESSED(4, DBServerType.ORACLE),
    BUFFER_GETS(5, DBServerType.ORACLE),
    DISK_READS(6, DBServerType.ORACLE),
    PARSE_CALLS(7, DBServerType.ORACLE),
    PLAN_HASH_VALUE(8, DBServerType.ORACLE),
    DIRECT_WRITES(9, DBServerType.ORACLE),
    SERIALIZABLE_ABORTS(10, DBServerType.ORACLE),
    FETCHES(11, DBServerType.ORACLE),
    END_OF_FETCH_COUNT(12, DBServerType.ORACLE),
    LOADS(13, DBServerType.ORACLE),
    VERSION_COUNT(14, DBServerType.ORACLE),
    INVALIDATIONS(15, DBServerType.ORACLE),
    PX_SERVERS_EXECUTIONS(16, DBServerType.ORACLE),
    PLSQL_EXEC_TIME(17, DBServerType.ORACLE),
    APPLICATION_WAIT_TIME(18, DBServerType.ORACLE),
    CONCURRENCY_WAIT_TIME(19, DBServerType.ORACLE),
    CLUSTER_WAIT_TIME(20, DBServerType.ORACLE),
    USER_IO_WAIT_TIME(21, DBServerType.ORACLE),
    JAVA_EXEC_TIME(22, DBServerType.ORACLE),
    SORTS(23, DBServerType.ORACLE),
    SHARABLE_MEM(24, DBServerType.ORACLE),
    TYPECHECK_MEM(25, DBServerType.ORACLE),
    IO_CELL_OFFLOAD_ELIGIBLE_BYTES(26, DBServerType.ORACLE),
    IO_INTERCONNECT_BYTES(27, DBServerType.ORACLE),
    PHYSICAL_READ_REQUESTS(28, DBServerType.ORACLE),
    PHYSICAL_READ_BYTES(29, DBServerType.ORACLE),
    PHYSICAL_WRITE_REQUESTS(30, DBServerType.ORACLE),
    PHYSICAL_WRITE_BYTES(31, DBServerType.ORACLE),
    EXACT_MATCHING_SIGNATURE(32, DBServerType.ORACLE),
    FORCE_MATCHING_SIGNATURE(33, DBServerType.ORACLE),
    IO_CELL_UNCOMPRESSED_BYTES(34, DBServerType.ORACLE),
    IO_CELL_OFFLOAD_RETURNED_BYTES(35, DBServerType.ORACLE),
    EXECUTION_COUNT(101, DBServerType.MSSQL),
    TOTAL_WORKER_TIME(102, DBServerType.MSSQL),
    TOTAL_ELAPSED_TIME(103, DBServerType.MSSQL),
    TOTAL_PHYSICAL_READS(104, DBServerType.MSSQL),
    TOTAL_LOGICAL_READS(105, DBServerType.MSSQL),
    TOTAL_LOGICAL_WRITES(106, DBServerType.MSSQL),
    TOTAL_CLR_TIME(107, DBServerType.MSSQL),
    PLAN_HANDLE(108, DBServerType.MSSQL),
    NUM_EXECUTIONS(201, DBServerType.DB2),
    TOTAL_EXEC_TIME(202, DBServerType.DB2),
    TOTAL_USR_CPU_TIME(203, DBServerType.DB2),
    NUM_COMPILATIONS(204, DBServerType.DB2),
    ROWS_READ(205, DBServerType.DB2),
    ROWS_WRITTEN(206, DBServerType.DB2),
    STMT_SORTS(207, DBServerType.DB2),
    COUCHBASE_EXECUTIONS(301, DBServerType.COUCHBASE),
    COUCHBASE_ELAPSED_TIME(302, DBServerType.COUCHBASE),
    CALLS(401, DBServerType.POSTGRESQL),
    TOTAL_TIME(402, DBServerType.POSTGRESQL),
    ROWS(404, DBServerType.POSTGRESQL),
    SHARED_BLKS_HIT(405, DBServerType.POSTGRESQL),
    SHARED_BLKS_READ(406, DBServerType.POSTGRESQL),
    SHARED_BLKS_WRITTEN(407, DBServerType.POSTGRESQL),
    CASSANDRA_EXECUTIONS(501, DBServerType.CASSANDRA),
    CASSANDRA_ELAPSED_TIME(502, DBServerType.CASSANDRA),
    HANA_EXECUTION_COUNT(601, DBServerType.HANA),
    HANA_TOTAL_EXECUTION_CPU_TIME(602, DBServerType.HANA),
    HANA_ELAPSED_TIME(603, DBServerType.HANA);

    private static Map<DBServerType, Collection<QueryStatType>> serverTypeToStatTypes;
    private static Map<Integer, QueryStatType> idToStatType;
    private int id;
    private DBServerType dbType;

    public static QueryStatType valueOf(int id) {
        return idToStatType.get(id);
    }

    private QueryStatType(int id, DBServerType dbType) {
        this.id = id;
        this.dbType = dbType;
    }

    public DBServerType dbType() {
        return this.dbType;
    }

    public int id() {
        return this.id;
    }

    static {
        serverTypeToStatTypes = new HashMap<DBServerType, Collection<QueryStatType>>();
        idToStatType = new HashMap<Integer, QueryStatType>();
        HashMap typeToStatusTypesMutable = new HashMap();
        for (DBServerType dBServerType : DBServerType.values()) {
            typeToStatusTypesMutable.put(dBServerType, new LinkedList());
        }
        for (Enum enum_ : QueryStatType.values()) {
            DBServerType type = ((QueryStatType)enum_).dbType();
            ((Collection)typeToStatusTypesMutable.get((Object)type)).add(enum_);
            Integer id = ((QueryStatType)enum_).id();
            if (idToStatType.containsKey(id)) {
                throw new IllegalArgumentException("There are multiple QueryStatTypes with the same ID. Both " + (Object)((Object)idToStatType.get(id)) + " and " + enum_ + " have an ID of " + id + ".");
            }
            idToStatType.put(id, (QueryStatType)enum_);
        }
        for (Map.Entry entry : typeToStatusTypesMutable.entrySet()) {
            DBServerType type = (DBServerType)((Object)entry.getKey());
            Collection collection = (Collection)entry.getValue();
            Collection identifiersUnmodifiable = Collections.unmodifiableCollection(collection);
            serverTypeToStatTypes.put(type, identifiersUnmodifiable);
        }
    }
}

