/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.dbmon.api.dtos;

import com.appdynamics.dbmon.api.dtos.BucketStatType;
import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;

public class BucketStatMeasurement {
    private long timestamp;
    private long bucketId;
    private long serverId;
    private Map<Integer, Number> values;

    public BucketStatMeasurement() {
    }

    public BucketStatMeasurement(Long bucketId, Map<BucketStatType, Long> values) {
        this.bucketId = bucketId;
        this.addAllValues(values);
    }

    public Map<Integer, Number> getValues() {
        return this.values;
    }

    public void setValues(Map<Integer, Number> values) {
        this.values = values;
    }

    public void setBucketId(long bucketId) {
        this.bucketId = bucketId;
    }

    public long getBucketId() {
        return this.bucketId;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public BucketStatMeasurement addValue(BucketStatType type, Number value) {
        if (this.values == null) {
            this.values = new HashMap<Integer, Number>();
        }
        this.values.put(type.id(), value);
        return this;
    }

    public void addAllValues(Map<BucketStatType, Long> valuesToAdd) {
        for (Map.Entry<BucketStatType, Long> entry : valuesToAdd.entrySet()) {
            this.addValue(entry.getKey(), entry.getValue());
        }
    }

    public Long statValueAsLong(BucketStatType stat) {
        Long value = 0L;
        Number number = this.values.get(stat.id());
        if (number != null) {
            value = number.longValue();
        }
        return value;
    }

    public String statValueAsString(BucketStatType stat) {
        String value = null;
        Number obj = this.values.get(stat.id());
        if (obj != null) {
            value = String.valueOf(obj);
        }
        return value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("bucketId", this.bucketId).add("serverId", this.serverId).add("values", this.values).toString();
    }
}

