/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.dbmon.api;

import com.appdynamics.dbmon.api.dtos.DBServer;
import com.appdynamics.dbmon.api.dtos.DBServerType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/dbmon/dbserver")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface DBServerStore {
    @POST
    public List<Long> create(List<DBServer> var1);

    @GET
    @Path(value="{id}")
    public DBServer getById(@PathParam(value="id") long var1);

    @GET
    @Path(value="{id}/{checkForPermissionRequired}")
    public DBServer getById(@PathParam(value="id") long var1, @PathParam(value="checkForPermissionRequired") boolean var3);

    @POST
    @Path(value="ids")
    public Collection<DBServer> getByIds(Collection<Long> var1);

    @POST
    @Path(value="ids/{checkForPermissionRequired}")
    public Collection<DBServer> getByIds(Collection<Long> var1, @PathParam(value="checkForPermissionRequired") boolean var2);

    @POST
    @Path(value="ids/fortype/{type}")
    public Collection<DBServer> getByTypeAndIds(@PathParam(value="type") DBServerType var1, Collection<Long> var2);

    @GET
    @Path(value="fortype/{type}")
    public Collection<DBServer> getByType(@PathParam(value="type") DBServerType var1);

    @GET
    @Path(value="allEnabled")
    public Collection<DBServer> getAllEnabled();

    @GET
    @Path(value="all")
    public Collection<DBServer> getAll();

    @GET
    @Path(value="allIncludeDeleted")
    public Collection<DBServer> getAllIncludeDeleted();

    @GET
    @Path(value="getAllWithHardWareMonitoringDisabledWithFilter")
    public Collection<DBServer> getAllWithHardwareMonitoringDisabledWithOptionalFilters(Set<String> var1, @QueryParam(value="id") Long var2);

    @GET
    @Path(value="allForUpdatableConfigs")
    public Collection<DBServer> getAllByUpdatableConfigs();

    @GET
    @Path(value="fornode/{id}")
    public DBServer getByNode(@PathParam(value="id") long var1);

    @POST
    @Path(value="nodeIds")
    public Map<Long, DBServer> getByNodeIds(List<Long> var1);

    @GET
    @Path(value="forconfig/{id}")
    public Collection<DBServer> getByConfig(@PathParam(value="id") long var1);

    @GET
    @Path(value="forconfig/{id}/{checkForPermissionRequired}")
    public Collection<DBServer> getByConfig(@PathParam(value="id") long var1, @PathParam(value="checkForPermissionRequired") boolean var3);

    @POST
    @Path(value="forconfig")
    public Map<Long, Collection<DBServer>> getByConfigs(Collection<Long> var1);

    @POST
    @Path(value="forconfig/{checkForPermissionRequired}")
    public Map<Long, Collection<DBServer>> getByConfigs(Collection<Long> var1, @PathParam(value="checkForPermissionRequired") boolean var2);

    @GET
    @Path(value="fornames/{name}/{configName}")
    public DBServer getByNameAndConfigName(@PathParam(value="name") String var1, @PathParam(value="configName") String var2);

    @POST
    @Path(value="forbackends")
    public Map<Long, DBServer> getByBackendIds(List<Long> var1);

    @POST
    @Path(value="markDeleteByIds")
    public int markDeleteByIds(List<Long> var1);

    @DELETE
    @Path(value="deleteByIds")
    public int deleteByIds(@NotNull @Size(min=1) @QueryParam(value="id") @NotNull @Size(min=1) List<Long> var1);
}

