/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.dbmon.api;

import com.appdynamics.dbmon.api.dtos.DBMonitorConfig;
import com.appdynamics.dbmon.api.dtos.DBMonitorConfigWithListOfServers;
import com.appdynamics.dbmon.api.dtos.DBServerType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/dbmon/dbmonitorconfig")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface DBMonitorConfigStore {
    @POST
    public long create(@Valid @NotNull DBMonitorConfig var1);

    @GET
    @Path(value="{id}")
    public DBMonitorConfig getById(@PathParam(value="id") @Min(value=1L) @Min(value=1L) long var1);

    @POST
    @Path(value="ids")
    public Map<Long, DBMonitorConfig> getByIds(Collection<Long> var1);

    @GET
    @Path(value="all")
    public List<DBMonitorConfig> getAll();

    @GET
    @Path(value="count")
    public int count();

    @GET
    @Path(value="all/name/{ascending}")
    public List<DBMonitorConfig> getAllByName(@PathParam(value="ascending") Boolean var1);

    @GET
    @Path(value="all/type/{ascending}")
    public List<DBMonitorConfig> getAllByType(@PathParam(value="ascending") Boolean var1);

    @POST
    @Path(value="all/filteredbynameandtype/{name}")
    public List<DBMonitorConfig> getAllFilteredByNameAndType(@NotNull @PathParam(value="name") String var1, @NotNull @Size(min=1) @NotNull @Size(min=1) List<DBServerType> var2);

    @GET
    @Path(value="name/{name}")
    public DBMonitorConfig getByName(@PathParam(value="name") @NotNull String var1);

    @POST
    @Path(value="names")
    public Map<String, DBMonitorConfig> getByNames(Collection<String> var1);

    @PUT
    public DBMonitorConfig replace(@Valid DBMonitorConfig var1);

    @PUT
    @Path(value="updateStatusByIds")
    public int updateStatusByIds(@Valid @NotNull List<Long> var1, @QueryParam(value="enabled") boolean var2);

    @DELETE
    @Path(value="{id}")
    public boolean deleteById(@PathParam(value="id") @Min(value=1L) @Min(value=1L) long var1);

    @DELETE
    public int deleteByIds(@NotNull @Size(min=1) @QueryParam(value="id") @NotNull @Size(min=1) List<Long> var1);

    @DELETE
    @Path(value="all")
    public int deleteAll();

    @GET
    @Path(value="find/all")
    public List<Long> findAll();

    @POST
    @Path(value="getAllByTypeWithServers")
    public List<DBMonitorConfigWithListOfServers> getAllByTypeWithServers(List<DBServerType> var1);

    @POST
    @Path(value="find/by-ids")
    public List<Long> findByIds(@NotNull @Size(min=1) @NotNull @Size(min=1) List<Long> var1);

    @GET
    @Path(value="ping")
    public long ping();

    @GET
    @Path(value="time-and-account-ids-modified-after/{timestamp}")
    public List<Long> getCurrentTimeAndAccountIdsModifiedAfter(@PathParam(value="timestamp") long var1);

    @POST
    @Path(value="getByBackendIds")
    public Map<Long, DBMonitorConfig> getByBackendIds(Collection<Long> var1);
}

