/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.security.credentialstore.impl;

import com.singularity.ee.util.security.credentialstore.impl.AEncryptionScheme;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

public class EncryptionSchemeLegacy
extends AEncryptionScheme {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public EncryptionSchemeLegacy(String prefix) {
        super(prefix);
    }

    public String decrypt(String cipherText, SecretKey secretKey) throws GeneralSecurityException {
        if (cipherText == null) {
            return null;
        }
        byte[] cipherTextBytes = null;
        try {
            cipherTextBytes = cipherText.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException("Unsupported encoding.", unsupportedEncodingException);
        }
        byte[] base64Bytes = Base64.decodeBase64((byte[])cipherTextBytes);
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        cipher.init(2, secretKey);
        byte[] plainTextBytes = cipher.doFinal(base64Bytes);
        String plainTextString = null;
        try {
            plainTextString = new String(plainTextBytes, DEFAULT_CHARSET_NAME);
            int separatorIndex = plainTextString.indexOf(126);
            if (separatorIndex == 0) {
                throw new GeneralSecurityException("Unsupported cipher-text - Cannot decrypt.");
            }
            plainTextString = plainTextString.substring(separatorIndex + 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException("Unsupported encoding.", unsupportedEncodingException);
        }
        return plainTextString;
    }

    public String encrypt(String plainText, SecretKey secretKey) throws GeneralSecurityException {
        if (plainText == null) {
            throw new GeneralSecurityException("NULL Plaintext - Nothing to encrypt.");
        }
        byte[] plainTextBytes = null;
        try {
            String saltedPlainText = UUID.randomUUID().toString() + "~" + plainText;
            plainTextBytes = saltedPlainText.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException("Unsupported encoding.", unsupportedEncodingException);
        }
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        cipher.init(1, secretKey);
        byte[] cipherTextBytes = cipher.doFinal(plainTextBytes);
        byte[] base64EncodedBytes = Base64.encodeBase64((byte[])cipherTextBytes);
        String cipherTextString = null;
        try {
            cipherTextString = new String(base64EncodedBytes, DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException("Unsupported encoding.", unsupportedEncodingException);
        }
        return cipherTextString;
    }
}

