/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.log4j;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.voltron.utils.StringUtil;
import com.google.common.annotations.VisibleForTesting;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.ILoggerFactory;
import com.singularity.ee.util.logging.LogLevel;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4JLoggerFactory
implements ILoggerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Log4JLoggerFactory.class);
    public static final String LOG4J_CONFIGURATION_FILE_PROPERTY = "log4j.configurationFile";
    public static final String LOG4J_AGENT_LOGS_DIR_PROPERTY = "${sys:appdynamics.agent.logs.dir}";
    private String agentLogDir;
    Date date = new Date();
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public Log4JLoggerFactory(BootstrapConfiguration bootstrapConfiguration, String agentHomeDir, String agentConfigDir) {
        File logFile;
        String logName;
        Object logDirectory = this.checkLogDirFromSysProp(bootstrapConfiguration);
        if (logDirectory == null) {
            logDirectory = agentHomeDir + File.separator + "logs";
        }
        this.agentLogDir = logDirectory;
        System.setProperty("appdynamics.agent.logs.dir", this.agentLogDir);
        File configFile = new File(this.getConfigurationFile(agentConfigDir));
        URI configFileURI = configFile.toURI();
        org.apache.logging.log4j.core.Logger castedRootLogger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        castedRootLogger.getContext().setConfigLocation(configFileURI);
        Appender appender = (Appender)castedRootLogger.getAppenders().get("FileAppender");
        if (appender instanceof RollingFileAppender && StringUtils.isNotBlank((CharSequence)(logName = ((RollingFileAppender)appender).getFileName())) && (logFile = new File(logName)).exists()) {
            System.out.println(this.format.format(this.date) + " [INFO] Agent logging directory set to: [" + String.valueOf(logFile.getParentFile()) + "]");
        }
    }

    public ILogger getLogger(String name) {
        return new Log4JLogger(LogManager.getLogger((String)name));
    }

    public void init(LogLevel level, boolean logToFile, String logFileName, boolean logToConsole) throws IOException {
        org.apache.logging.log4j.Logger root = LogManager.getRootLogger();
        this.initializeLogger(level, logToFile, logFileName, logToConsole, root);
    }

    private void initializeLogger(LogLevel level, boolean logToFile, String logFileName, boolean logToConsole, org.apache.logging.log4j.Logger root) throws IOException {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d %p [%t] %c (%F:%L) - %m%n").build();
        org.apache.logging.log4j.core.Logger castedRootLogger = (org.apache.logging.log4j.core.Logger)root;
        if (logToFile) {
            FileAppender fileAppender = ((FileAppender.Builder)FileAppender.newBuilder().setLayout((Layout)layout)).withFileName(logFileName).build();
            castedRootLogger.addAppender((Appender)fileAppender);
        }
        if (logToConsole) {
            ConsoleAppender consoleAppender = ((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setLayout((Layout)layout)).build();
            castedRootLogger.addAppender((Appender)consoleAppender);
        }
        castedRootLogger.setLevel(Log4JLoggerFactory.getLog4JLevel(level));
    }

    public ILogger getLogger(LogLevel level, boolean logToFile, String logFileName, boolean logToConsole, String loggerName) throws IOException {
        org.apache.logging.log4j.Logger root = LogManager.getLogger((String)loggerName);
        this.initializeLogger(level, logToFile, logFileName, logToConsole, root);
        return new Log4JLogger(root);
    }

    public void setLevel(LogLevel level) {
        org.apache.logging.log4j.core.Logger castedRootLogger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        castedRootLogger.setLevel(Log4JLoggerFactory.getLog4JLevel(level));
    }

    public static Level getLog4JLevel(LogLevel level) {
        switch (level) {
            case DEBUG: {
                return Level.DEBUG;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case FATAL: {
                return Level.FATAL;
            }
            case INFO: {
                return Level.INFO;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case WARN: {
                return Level.WARN;
            }
        }
        return Level.INFO;
    }

    private String checkLogDirFromSysProp(BootstrapConfiguration bootstrapConfiguration) {
        String logDirectory = System.getProperty("appdynamics.agent.logs.dir");
        if (logDirectory == null) {
            logDirectory = System.getProperty("appdynamics.agent.logging.dir");
        }
        if (!StringUtil.isBlank((String)logDirectory) && this.createDirIfNotExists(logDirectory)) {
            return logDirectory;
        }
        String agentRuntimeDirectory = bootstrapConfiguration.getAgentRuntimeDir();
        if (!StringUtil.isBlank((String)agentRuntimeDirectory) && this.createDirIfNotExists(agentRuntimeDirectory)) {
            return agentRuntimeDirectory;
        }
        return null;
    }

    private boolean createDirIfNotExists(String dir) {
        File dirFile = new File(dir);
        if (!dirFile.exists() && !dirFile.mkdirs()) {
            System.out.println(this.format.format(this.date) + " [WARN] Failed to create directory " + dir);
            return false;
        }
        if (!dirFile.isDirectory()) {
            System.out.println(this.format.format(this.date) + " [WARN] " + dir + " is not a valid directory.");
            return false;
        }
        return true;
    }

    @VisibleForTesting
    String getAgentLogDir() {
        return this.agentLogDir;
    }

    @VisibleForTesting
    String getConfigurationFile(String agentConfigDir) {
        String configurationFile = System.getProperty(LOG4J_CONFIGURATION_FILE_PROPERTY);
        if (StringUtils.isBlank((CharSequence)configurationFile)) {
            configurationFile = Paths.get(agentConfigDir, "logging", "log4j.xml").toString();
        }
        return configurationFile;
    }
}

