/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.task;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.task.ArgumentMetaData;
import com.singularity.ee.task.CustomVerifierData;
import com.singularity.ee.task.ExecTaskMetaData;
import com.singularity.ee.task.ExecTaskType;
import com.singularity.ee.task.InvalidTaskMetaDataException;
import com.singularity.ee.task.JavaTaskMetaData;
import com.singularity.ee.task.LogMessageVerifierData;
import com.singularity.ee.task.LogMessageVerifierSource;
import com.singularity.ee.task.TaskCommandData;
import com.singularity.ee.task.TaskMetaData;
import com.singularity.ee.task.TaskTagNames;
import com.singularity.ee.task.TaskType;
import com.singularity.ee.task.VerifierData;
import com.singularity.ee.util.OSNameUtil;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TaskReader
implements TaskTagNames {
    public TaskMetaData readTaskFromFile(String taskDir, File taskFile) throws InvalidTaskMetaDataException {
        try {
            Document xmlDoc = XMLParseUtility.getXmlDocumentFromFile((File)taskFile);
            return this.readTaskFromDocument(xmlDoc, taskDir);
        }
        catch (IOException e) {
            throw new InvalidTaskMetaDataException(e);
        }
        catch (SAXException e) {
            throw new InvalidTaskMetaDataException(e);
        }
        catch (ParserConfigurationException e) {
            throw new InvalidTaskMetaDataException(e);
        }
    }

    public TaskMetaData readTaskFromDocument(Document xmlDoc, String taskDir) throws InvalidTaskMetaDataException {
        Element rootElement = xmlDoc.getDocumentElement();
        return this.readFromTaskElement(rootElement, taskDir);
    }

    public TaskMetaData readFromTaskElement(Element taskElement, String taskDir) throws InvalidTaskMetaDataException {
        TaskMetaData taskMetaData = this.getTaskMetaData(taskElement);
        taskMetaData.setTaskDir(taskDir);
        taskMetaData.setName(XMLParseUtility.getTextForTagForElement((Node)taskElement, (String)"name"));
        taskMetaData.setDescription(XMLParseUtility.getTextForTagForElement((Node)taskElement, (String)"description"));
        taskMetaData.setDisplayName(XMLParseUtility.getTextForTagForElement((Node)taskElement, (String)"display-name"));
        taskMetaData.setExecutionTimeOutInSeconds(XMLParseUtility.safeParseIntValue((Element)taskElement, (String)"execution-timeout-in-secs"));
        boolean verifierEnabled = Boolean.parseBoolean(XMLParseUtility.getTextForTagForElement((Node)taskElement, (String)"verifier-enabled"));
        taskMetaData.setVerifierEnabled(verifierEnabled);
        String outputCaptureEnabledStr = XMLParseUtility.getTextForTagForElement((Node)taskElement, (String)"output-capture-enabled");
        if (outputCaptureEnabledStr == null || "".equals(outputCaptureEnabledStr)) {
            taskMetaData.setOutputCaptureEnabled(true);
        } else {
            taskMetaData.setOutputCaptureEnabled(Boolean.parseBoolean(outputCaptureEnabledStr));
        }
        taskMetaData.setOutputCaptureTimePeriod(XMLParseUtility.safeParseIntValue((Element)taskElement, (String)"output-capture-timeperiod-in-secs"));
        Element verifierData = XMLParseUtility.getFirstDirectChildUnderWithName((Node)taskElement, (String)"verifier");
        if (verifierEnabled) {
            taskMetaData.setVerifierData(this.getVerifierData(verifierData));
        }
        taskMetaData.setArgsMetaData(this.getArgsMetaData(taskElement));
        taskMetaData.setCustomTaskHandler(XMLParseUtility.getTextForTagForElement((Node)taskElement, (String)"custom-task-handler"));
        return taskMetaData;
    }

    private List<ArgumentMetaData> getArgsMetaData(Element rootElement) throws InvalidTaskMetaDataException {
        ArrayList<ArgumentMetaData> argMetaDataList = new ArrayList<ArgumentMetaData>();
        Element envParamNode = XMLParseUtility.getFirstDirectChildUnderWithName((Node)rootElement, (String)"task-arguments");
        if (envParamNode == null) {
            return argMetaDataList;
        }
        List argElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)envParamNode, (String)"argument");
        for (Element argElement : argElements) {
            String name = argElement.getAttribute("name");
            boolean isRequired = Boolean.parseBoolean(argElement.getAttribute("is-required"));
            String defaultValue = argElement.getAttribute("default-value");
            ArgumentMetaData argMetaData = new ArgumentMetaData(name, isRequired, defaultValue);
            argMetaDataList.add(argMetaData);
        }
        return argMetaDataList;
    }

    private TaskMetaData getTaskMetaData(Element element) throws InvalidTaskMetaDataException {
        TaskMetaData taskMetaData = null;
        String taskTypeStr = XMLParseUtility.getTextForTagForElement((Node)element, (String)"type");
        if (taskTypeStr == null) {
            throw new IllegalArgumentException("Task type is not specified");
        }
        if (taskTypeStr.equalsIgnoreCase(TaskType.EXECUTABLE.toString())) {
            Element execTaskElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)element, (String)"executable-task");
            if (execTaskElement == null) {
                throw new InvalidTaskMetaDataException("Invalid Task XML, task defined as executable, but does not have the 'executable-task' element");
            }
            taskMetaData = this.getExecTaskData(execTaskElement);
        } else if (taskTypeStr.equalsIgnoreCase(TaskType.JAVA.toString())) {
            Element execTaskElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)element, (String)"java-task");
            if (execTaskElement == null) {
                throw new InvalidTaskMetaDataException("Invalid Task XML, task defined as executable, but does not have the 'java-task' element");
            }
            taskMetaData = this.getJavaTaskData(execTaskElement);
        } else {
            throw new InvalidTaskMetaDataException("Unsupported task type : " + taskTypeStr);
        }
        return taskMetaData;
    }

    TaskCommandData getExecutableNameForOS(String execTaskType, Element element) throws InvalidTaskMetaDataException {
        List executableElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)element, (String)execTaskType);
        String executableName = null;
        String defaultOSFileName = null;
        String method = null;
        for (Element fileElement : executableElements) {
            String requiredOS = (String)XMLParseUtility.getAttributeMapForElement((Element)fileElement).get("os-type");
            String requiredOSVersion = (String)XMLParseUtility.getAttributeMapForElement((Element)fileElement).get("os-version-pattern");
            method = (String)XMLParseUtility.getAttributeMapForElement((Element)fileElement).get("method");
            if (requiredOS == null) {
                defaultOSFileName = XMLParseUtility.getElementValue((Element)fileElement);
                continue;
            }
            if (!OSNameUtil.getName().toLowerCase().contains(requiredOS.toLowerCase()) || requiredOSVersion != null && !OSNameUtil.getVersion().matches(requiredOSVersion)) continue;
            executableName = XMLParseUtility.getElementValue((Element)fileElement);
        }
        if (executableName == null) {
            if (defaultOSFileName == null) {
                throw new InvalidTaskMetaDataException("No executable specified for OS " + OSNameUtil.getName() + " or for default OS. Task won't execute.");
            }
            executableName = defaultOSFileName;
        }
        return TaskCommandData.getInstance(executableName, method);
    }

    TaskMetaData getExecTaskData(Element element) throws InvalidTaskMetaDataException {
        ExecTaskMetaData execData = new ExecTaskMetaData();
        String execTaskType = XMLParseUtility.getTextForTagForElement((Node)element, (String)"type");
        if (execTaskType.equalsIgnoreCase(ExecTaskType.FILE.toString())) {
            TaskCommandData taskCommandData = this.getExecutableNameForOS("file", element);
            execData.setExecTaskType(ExecTaskType.FILE);
            execData.setFilePath(taskCommandData.getExecutable());
            execData.setMethodName(taskCommandData.getMethod());
        } else {
            TaskCommandData taskCommandData = this.getExecutableNameForOS("command", element);
            execData.setExecTaskType(ExecTaskType.COMMAND);
            execData.setCommandName(taskCommandData.getExecutable());
        }
        execData.setArgsPattern(XMLParseUtility.getTextForTagForElement((Node)element, (String)"arguments-pattern"));
        execData.setWorkingDir(XMLParseUtility.getTextForTagForElement((Node)element, (String)"working-dir"));
        execData.setWaitForProcessExit(Boolean.parseBoolean(XMLParseUtility.getTextForTagForElement((Node)element, (String)"wait-for-process-exit")));
        return execData;
    }

    private TaskMetaData getJavaTaskData(Element element) {
        JavaTaskMetaData javaTaskData = new JavaTaskMetaData();
        javaTaskData.setImplementationClassName(XMLParseUtility.getTextForTagForElement((Node)element, (String)"impl-class"));
        javaTaskData.setFactoryMethod(XMLParseUtility.getTextForTagForElement((Node)element, (String)"factory-method"));
        javaTaskData.setInvokeMethod(XMLParseUtility.getTextForTagForElement((Node)element, (String)"invoke-method"));
        javaTaskData.setClasspath(XMLParseUtility.getTextForTagForElement((Node)element, (String)"classpath"));
        javaTaskData.setLoadJarsInClassPathDirs(Boolean.parseBoolean(XMLParseUtility.getTextForTagForElement((Node)element, (String)"load-jars-in-classpath-dirs")));
        return javaTaskData;
    }

    private VerifierData getVerifierData(Element verifierElement) throws InvalidTaskMetaDataException {
        if (verifierElement == null) {
            throw new InvalidTaskMetaDataException("Invalid Task XML , task verifier defined, but does not have the 'verifier' element");
        }
        String verifierType = XMLParseUtility.getTextForTagForElement((Node)verifierElement, (String)"type");
        VerifierData verifierData = null;
        if (verifierType.equals("log-message-verifier")) {
            Element logMessageVerifierElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)verifierElement, (String)"log-message-verifier");
            if (logMessageVerifierElement == null) {
                throw new InvalidTaskMetaDataException("Invalid Task XML, task verifier defined , but does not have the 'log-message-verifier' element");
            }
            LogMessageVerifierData logMsgVerifierData = verifierData = new LogMessageVerifierData();
            logMsgVerifierData.setSuccessExpression(XMLParseUtility.getTextForTagForElement((Node)logMessageVerifierElement, (String)"success-expression"));
            logMsgVerifierData.setFailureExpression(XMLParseUtility.getTextForTagForElement((Node)logMessageVerifierElement, (String)"failure-expression"));
            logMsgVerifierData.setSource(this.getSource(XMLParseUtility.getTextForTagForElement((Node)logMessageVerifierElement, (String)"source")));
            logMsgVerifierData.setFilePath(XMLParseUtility.getTextForTagForElement((Node)logMessageVerifierElement, (String)"filepath"));
        } else if (verifierType.equals("custom-verifier")) {
            Element customVerifierElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)verifierElement, (String)"custom-verifier");
            if (customVerifierElement == null) {
                throw new InvalidTaskMetaDataException("Invalid Task XML, task verifier defined , but does not have the 'custom-verifier' element");
            }
            verifierData = new CustomVerifierData();
            CustomVerifierData customVerifierData = (CustomVerifierData)verifierData;
            customVerifierData.setImplementationClassName(XMLParseUtility.getTextForTagForElement((Node)customVerifierElement, (String)"impl-class"));
            customVerifierData.setClasspath(XMLParseUtility.getTextForTagForElement((Node)customVerifierElement, (String)"classpath"));
            customVerifierData.setLoadJarsInClassPathDirs(Boolean.parseBoolean(XMLParseUtility.getTextForTagForElement((Node)customVerifierElement, (String)"load-jars-in-classpath-dirs")));
            customVerifierData.setProperties(XMLParseUtility.getPropertiesForElement((Element)customVerifierElement, (String)"properties"));
        }
        if (verifierData == null) {
            throw new InvalidTaskMetaDataException("Invalid Verifier Type specified [" + verifierType + "]");
        }
        verifierData.setTimeoutInSecs(XMLParseUtility.safeParseIntValue((Element)verifierElement, (String)"timeout-in-secs"));
        return verifierData;
    }

    private LogMessageVerifierSource getSource(String type) throws InvalidTaskMetaDataException {
        try {
            return LogMessageVerifierSource.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidTaskMetaDataException("Invalid Log Message Verifier Type specified [" + type + "]");
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(System.getProperty("file.separator"));
    }
}

