/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.CDATASection;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.controller.request.TaskExecutionRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriter;
import javax.servlet.http.HttpServletRequest;

public class TaskOutputCaptureRequest
extends TaskExecutionRequest {
    public static final String TIMESTAMP = "timestamp";
    public static final String STDOUT = "stdout";
    public static final String STDERR = "stderr";
    public static final String OUTPUT = "output";
    private boolean isErrStream;

    public TaskOutputCaptureRequest(String controllerHost, int port, String machineId, String taskExecutionId, boolean isErrStream, ILogger logger) {
        super(controllerHost, port, machineId, taskExecutionId, logger);
        if (!isErrStream) {
            this.url = this.url + "output/stdout";
        } else {
            this.url = this.url + "output/stderr";
            this.isErrStream = true;
        }
    }

    public TaskOutputCaptureRequest(HttpServletRequest request, ILogger logger) throws RequestReadException {
        super(request, logger);
        if (this.getValueForArgument(STDERR) != null) {
            this.isErrStream = false;
        }
    }

    public long getTimeStamp() {
        return Long.parseLong(this.getValueForArgument(TIMESTAMP));
    }

    public void setTimeStamp(long timeStamp) {
        this.addArgumentWithNoAttributes(TIMESTAMP, String.valueOf(timeStamp));
    }

    public String getOutStream() {
        Element outputElement = this.getXMLValueForArgument(STDOUT);
        if (outputElement != null) {
            System.out.println("Output obtained ->" + XMLParseUtility.getTextForTagForElement((Node)outputElement, (String)OUTPUT));
            return XMLParseUtility.getTextForTagForElement((Node)outputElement, (String)OUTPUT);
        }
        return null;
    }

    public void addOutStream(String streamOutput) {
        try {
            this.addXMLArgument(STDOUT, this.getOutputElement(streamOutput));
        }
        catch (ParserConfigurationException e) {
            this.logger.warn("Error writing output to XML " + streamOutput);
        }
    }

    public String getErrStream() {
        Element outputElement = this.getXMLValueForArgument(STDERR);
        if (outputElement != null) {
            System.out.println("Output obtained ->" + XMLParseUtility.getTextForTagForElement((Node)outputElement, (String)OUTPUT));
            return XMLParseUtility.getTextForTagForElement((Node)outputElement, (String)OUTPUT);
        }
        return null;
    }

    public void addErrStream(String streamOutput) {
        try {
            this.addXMLArgument(STDERR, this.getOutputElement(streamOutput));
        }
        catch (ParserConfigurationException e) {
            this.logger.warn("Error writing output to XML " + streamOutput);
        }
    }

    public boolean isErrStream() {
        return this.isErrStream;
    }

    private Element getOutputElement(String streamOutput) throws ParserConfigurationException {
        XMLWriter writer = new XMLWriter();
        Element output = writer.createElement(OUTPUT);
        CDATASection cdata = writer.getDocument().createCDATASection(streamOutput);
        output.appendChild((Node)cdata);
        return output;
    }
}

