/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.controller.api.constants.TaskExecutionStatus;
import com.singularity.ee.rest.RESTArgumentType;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.controller.request.TaskExecutionRequest;
import com.singularity.ee.util.logging.ILogger;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class TaskExecutionStatusRequest
extends TaskExecutionRequest {
    private static final String OUTPUT_PROPERTY_TAG = "output-property";
    private static final String EXECUTION_STATUS_TAG = "task-execution-status";
    private static final String EXECUTION_OUTPUT = "execution-output";
    private static final String EXISTS = "exists";
    private static final String VERSION = "version";

    public TaskExecutionStatusRequest(String controllerHost, int port, String machineId, String taskExecutionId, ILogger logger) {
        super(controllerHost, port, machineId, taskExecutionId, logger);
        this.url = this.url + "executionstatus";
    }

    public TaskExecutionStatusRequest(HttpServletRequest request, ILogger logger) throws RequestReadException {
        super(request, logger);
    }

    public TaskExecutionStatus getStatus() {
        return TaskExecutionStatus.valueOf(this.getValueForArgument(EXECUTION_STATUS_TAG));
    }

    public void setStatus(TaskExecutionStatus status) {
        this.addArgumentWithNoAttributes(EXECUTION_STATUS_TAG, status.name());
    }

    public void setTaskCouldNotStart() {
        this.addArgumentWithNoAttributes("response-code", String.valueOf(1));
    }

    public void setTaskStarted() {
        this.addArgumentWithNoAttributes("response-code", String.valueOf(0));
    }

    public void setExists(boolean exists) {
        String existsStr = "true";
        if (!exists) {
            existsStr = "false";
        }
        this.addArgumentWithNoAttributes(EXISTS, existsStr);
    }

    public void setVersion(String version) {
        this.addArgumentWithNoAttributes(VERSION, version);
    }

    public void setOutput(String output) {
        this.addArgumentWithNoAttributes(EXECUTION_OUTPUT, output);
    }

    public void setOutputProperties(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.addArgumentWithSingleNameValueAttributeOnly(OUTPUT_PROPERTY_TAG, property.getKey(), property.getValue());
        }
    }

    public Map<String, String> getOutputProperties() {
        Map outputProperties = this.getNameValueAttributeMapForArgument(OUTPUT_PROPERTY_TAG, RESTArgumentType.STRING);
        return outputProperties == null ? new HashMap() : outputProperties;
    }
}

