/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.agent.request;

import com.singularity.ee.rest.DownloadableFile;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.agent.request.AAgentRequest;
import com.singularity.ee.util.httpclient.HttpExecutionRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.ArrayEncoder;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TaskExecuteRequest
extends AAgentRequest {
    private static final String OUTPUT_PROPERTY_NAMES_TAG = "output-property-names";
    private static final String EXECUTE_TASK_URL = "/systemagent/controlchannel/taskexecution";
    private static final String TASK_NAME = "task-name";
    private static final String TASK_EXECUTION_ID = "task-execution-id";
    private static final String ARGUMENT = "argument";
    private Map<String, String> taskArguments = new HashMap<String, String>();

    public TaskExecuteRequest(long machineId, ILogger logger) {
        super(machineId, logger);
        this.url = EXECUTE_TASK_URL;
    }

    public TaskExecuteRequest(HttpExecutionRequest request, ILogger logger, String tasksRootDir, String controllerHost, int controllerPort) throws RequestReadException {
        super(request, logger);
    }

    public void setTaskName(String taskName) {
        this.addArgumentWithNoAttributes(TASK_NAME, taskName);
    }

    public String getTaskName() {
        return this.getValueForArgument(TASK_NAME);
    }

    public void setTaskExecutionId(long taskExecutionId) {
        this.addArgumentWithNoAttributes(TASK_EXECUTION_ID, String.valueOf(taskExecutionId));
    }

    public String getTaskExecutionId() {
        return this.getValueForArgument(TASK_EXECUTION_ID);
    }

    public Map<String, String> getTaskArguments() {
        return this.taskArguments;
    }

    public void addStringTaskArgument(String arg, String value) {
        this.addArgumentWithSingleNameValueAttributeOnly(ARGUMENT, arg, value);
    }

    public void addFileTaskArgument(String arg, DownloadableFile file) {
        this.addArgumentWithFileTypeSingleNameValueAttributeOnly(ARGUMENT, arg, file.getName(), (File)file);
    }

    public void setOutputPropertyNames(Set<String> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String propertyNames = ArrayEncoder.safeStringArrayToString(properties);
        this.addArgumentWithNoAttributes(OUTPUT_PROPERTY_NAMES_TAG, propertyNames);
    }

    public Set<String> getOutputProperties() {
        String propertyNames = this.getValueForArgument(OUTPUT_PROPERTY_NAMES_TAG);
        return new HashSet<String>(Arrays.asList(ArrayEncoder.safeStringToStringArray((String)propertyNames)));
    }
}

