/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.util;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.task.ArgumentMetaData;
import com.singularity.ee.task.ExecTaskMetaData;
import com.singularity.ee.task.ExecTaskType;
import com.singularity.ee.task.JavaTaskMetaData;
import com.singularity.ee.task.LogMessageVerifierData;
import com.singularity.ee.task.TaskMetaData;
import com.singularity.ee.task.TaskTagNames;
import com.singularity.ee.task.VerifierData;
import com.singularity.ee.task.VerifierType;
import com.singularity.ee.util.xml.XMLWriteException;
import com.singularity.ee.util.xml.XMLWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskWriter
implements TaskTagNames {
    private Element rootElement;
    private XMLWriter writer;
    private final Logger logger = LogManager.getLogger(TaskWriter.class);

    public TaskWriter(ExecTaskMetaData execMetaData) throws ParserConfigurationException {
        this.saveBasicTaskData(execMetaData);
        this.saveExecTaskDetails(execMetaData);
    }

    public TaskWriter(JavaTaskMetaData javaTaskMetaData) throws ParserConfigurationException {
        this.saveBasicTaskData(javaTaskMetaData);
        this.saveJavaTaskDetails(javaTaskMetaData);
    }

    private void saveBasicTaskData(TaskMetaData taskMetaData) throws ParserConfigurationException {
        this.writer = new XMLWriter();
        this.rootElement = this.writer.getDocument().createElement("task");
        this.writer.getDocument().appendChild((Node)this.rootElement);
        this.saveBasicTaskDetails(taskMetaData);
        this.saveTaskArguments(taskMetaData.getArgsMetaData());
        this.saveVerifierData(taskMetaData.getVerifierData());
    }

    public void saveTaskDefinitionToFile(String filePath) throws IOException {
        try {
            this.writer.saveToFile(filePath);
        }
        catch (XMLWriteException e) {
            this.logger.error("Error while saving to file: {}", (Object)e.getMessage());
        }
    }

    private void saveBasicTaskDetails(TaskMetaData taskMetaData) {
        this.writer.addTextNode(this.rootElement, "name", taskMetaData.getName());
        this.writer.addTextNode(this.rootElement, "type", taskMetaData.getTaskType().name().toLowerCase());
        if (taskMetaData.getExecutionTimeOutInSeconds() != 0) {
            this.writer.addTextNode(this.rootElement, "execution-timeout-in-secs", String.valueOf(taskMetaData.getExecutionTimeOutInSeconds()));
        }
        this.writer.addTextNode(this.rootElement, "verifier-enabled", String.valueOf(taskMetaData.isVerifierEnabled()));
        this.writer.addTextNode(this.rootElement, "output-capture-enabled", String.valueOf(taskMetaData.isOutputCaptureEnabled()));
        if (taskMetaData.getOutputCaptureTimePeriod() != 0) {
            this.writer.addTextNode(this.rootElement, "output-capture-timeperiod-in-secs", String.valueOf(taskMetaData.getOutputCaptureTimePeriod()));
        }
    }

    private void saveTaskArguments(List<ArgumentMetaData> argMetaDataList) {
        Element taskArgumentsElement = this.writer.createElement("task-arguments");
        this.rootElement.appendChild((Node)taskArgumentsElement);
        for (ArgumentMetaData argument : argMetaDataList) {
            HashMap<String, String> argElementAttribs = new HashMap<String, String>();
            argElementAttribs.put("name", argument.getName());
            argElementAttribs.put("is-required", String.valueOf(argument.isRequired()));
            if (argument.getDefaultValue() != null) {
                argElementAttribs.put("default-value", argument.getDefaultValue());
            }
            this.writer.addTextNode(taskArgumentsElement, "argument", argElementAttribs);
        }
    }

    private void saveExecTaskDetails(ExecTaskMetaData execData) {
        Element execTaskElement = this.writer.createElement("executable-task");
        this.rootElement.appendChild((Node)execTaskElement);
        this.writer.addTextNode(execTaskElement, "type", execData.getExecTaskType().name().toLowerCase());
        if (execData.getScriptMap() != null) {
            for (String osName : execData.getScriptMap().keySet()) {
                HashMap<String, String> osScriptMap = new HashMap<String, String>();
                osScriptMap.put("os-type", osName);
                if (execData.getExecTaskType() == ExecTaskType.FILE) {
                    this.writer.addTextNode(execTaskElement, "file", execData.getScriptMap().get(osName), osScriptMap);
                    continue;
                }
                this.writer.addTextNode(execTaskElement, "command", execData.getScriptMap().get(osName), osScriptMap);
            }
        } else if (execData.getExecTaskType() == ExecTaskType.FILE) {
            this.writer.addTextNode(execTaskElement, "file", execData.getFilePath());
        } else {
            this.writer.addTextNode(execTaskElement, "command", execData.getCommandName());
        }
        if (execData.getArgsPattern() != null) {
            this.writer.addTextNode(execTaskElement, "arguments-pattern", execData.getArgsPattern());
        }
        if (execData.getWorkingDir() != null) {
            this.writer.addTextNode(execTaskElement, "working-dir", execData.getWorkingDir());
        }
        this.writer.addTextNode(execTaskElement, "wait-for-process-exit", String.valueOf(execData.isWaitForProcessExit()));
    }

    private void saveJavaTaskDetails(JavaTaskMetaData javaTaskData) {
        Element javaTaskElement = this.writer.createElement("java-task");
        this.rootElement.appendChild((Node)javaTaskElement);
        this.writer.addTextNode(javaTaskElement, "impl-class", javaTaskData.getImplementationClassName());
        this.writer.addTextNode(javaTaskElement, "classpath", javaTaskData.getClasspath());
        this.writer.addTextNode(javaTaskElement, "load-jars-in-classpath-dirs", String.valueOf(javaTaskData.isLoadJarsInClassPathDirs()));
    }

    private void saveVerifierData(VerifierData verifierData) {
        Element verifierElement = this.writer.createElement("verifier");
        this.rootElement.appendChild((Node)verifierElement);
        this.writer.addTextNode(verifierElement, "type", verifierData.getVerifierType().name().toLowerCase());
        if (verifierData.getTimeoutInSecs() != 0) {
            this.writer.addTextNode(verifierElement, "timeout-in-secs", String.valueOf(verifierData.getTimeoutInSecs()));
        }
        if (verifierData.getVerifierType() == VerifierType.LOG_MESSAGE_VERIFIER) {
            LogMessageVerifierData logVerifierData = (LogMessageVerifierData)verifierData;
            Element logMessageVerifierElement = this.writer.createElement("log-message-verifier");
            verifierElement.appendChild((Node)logMessageVerifierElement);
            this.writer.addTextNode(logMessageVerifierElement, "source", logVerifierData.getSource().name().toLowerCase());
            this.writer.addTextNode(logMessageVerifierElement, "filepath", logVerifierData.getFilePath());
            this.writer.addTextNode(logMessageVerifierElement, "success-expression", logVerifierData.getSuccessExpression());
            this.writer.addTextNode(logMessageVerifierElement, "failure-expression", logVerifierData.getFailureExpression());
        }
    }
}

