/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.util;

import com.singularity.ee.agent.systemagent.task.ControllerUtil;
import com.singularity.ee.agent.systemagent.task.TaskRunner;
import com.singularity.ee.controller.api.constants.TaskExecutionStatus;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.agent.request.TaskExecuteRequest;
import com.singularity.ee.task.InvalidTaskMetaDataException;
import com.singularity.ee.transport.onewayagent.AServerRequestHandler;
import com.singularity.ee.transport.onewayagent.RequestHandlingStrategy;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskExecuteServerRequestHandler
extends AServerRequestHandler {
    private static Logger logger = LogManager.getLogger((String)TaskExecuteServerRequestHandler.class.getName());
    private final IAgentScheduledExecutorService scheduler;
    private final String tasksRootDir;

    public TaskExecuteServerRequestHandler(IAgentScheduledExecutorService scheduler, String tasksRootDir) {
        if (scheduler == null) {
            throw new NullPointerException("scheduler is null");
        }
        if (tasksRootDir == null) {
            throw new NullPointerException("tasksRootDir is null");
        }
        this.scheduler = scheduler;
        this.tasksRootDir = tasksRootDir;
    }

    public boolean isServerResponseAsynchronous() {
        return true;
    }

    public RequestHandlingStrategy getRequestHandlingStrategy() {
        return RequestHandlingStrategy.ASYNCHRONOUS;
    }

    public void run() {
        ControllerUtil controllerUtil = new ControllerUtil(this.getControllerHost(), this.getControllerPort(), this.getMachineId());
        String taskID = null;
        String taskName = null;
        try {
            TaskExecuteRequest executeRequest = new TaskExecuteRequest(this.getServerRequest(), new Log4JLogger(logger), this.tasksRootDir, this.getControllerHost(), this.getControllerPort());
            taskID = executeRequest.getTaskExecutionId();
            taskName = executeRequest.getTaskName();
            logger.info("Task Name Read @@@@@@@@@@ " + taskName);
            Map<String, String> taskArguments = executeRequest.getTaskArguments();
            logger.info("Task Arguments @@@@@@@@@@@ " + String.valueOf(taskArguments));
            TaskRunner taskRunner = new TaskRunner(executeRequest.getTaskExecutionId(), this.tasksRootDir, taskName, taskArguments, this.scheduler, controllerUtil, executeRequest.getOutputProperties());
            taskRunner.runTask();
        }
        catch (RequestReadException e) {
            logger.error("Error parsing request for task [" + taskName + "]", (Throwable)e);
            this.writeFailResponse("Error parsing request for task" + e.getMessage(), taskID, controllerUtil);
        }
        catch (InvalidTaskMetaDataException e) {
            logger.error("Error parsing task.xml for task [" + taskName + "]", (Throwable)e);
            this.writeFailResponse(e.getMessage(), taskID, controllerUtil);
        }
        catch (Exception e) {
            logger.error("Error running task [" + taskName + "]", (Throwable)e);
            this.writeFailResponse(e.getMessage(), taskID, controllerUtil);
        }
    }

    private void writeFailResponse(String outputMessage, String taskID, ControllerUtil controllerUtil) {
        controllerUtil.sendExecutionStatus(taskID, outputMessage, TaskExecutionStatus.FAILED, false, null);
    }
}

