/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.sigar;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.IMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricIdentifier;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.IMetricReporter;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.controller.api.constants.MetricClusterRollupType;
import com.singularity.ee.controller.api.constants.MetricHoleHandlingType;
import com.singularity.ee.controller.api.constants.MetricTimeRollupType;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import lombok.Generated;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandUsageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigarSecondTask
extends SigarCommandBase
implements IAgentRunnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigarSecondTask.class);
    private final IMetricReporter cpuBusy;
    private final IMetricReporter cpuIdle;
    private final IMetricReporter cpuStolen;
    private final IMetricReporter memoryUsedPerc;
    private final IMetricReporter memoryFreePerc;
    private final IMetricReporter memoryUsed;
    private final IMetricReporter memoryFree;
    private final IMetricReporter memoryTotal;
    private static final double MEGA = 1048576.0;
    private static final IMetricReporter NO_OP_REPORTER = new IMetricReporter(){

        public void report(long value) {
        }

        public void report(long value, long count, long min, long max) {
        }

        public MetricAggregatorType getType() {
            return null;
        }
    };

    public SigarSecondTask(IMetricAggregatorFactory metricAggregatorFactory) {
        this.cpuBusy = this.getReporter(metricAggregatorFactory, "CPU", "%Busy");
        this.cpuIdle = this.getReporter(metricAggregatorFactory, "CPU", "%Idle");
        this.cpuStolen = this.getReporter(metricAggregatorFactory, "CPU", "%Stolen");
        this.memoryFreePerc = this.getReporter(metricAggregatorFactory, "Memory", "Free %");
        this.memoryUsedPerc = this.getReporter(metricAggregatorFactory, "Memory", "Used %");
        this.memoryFree = this.getReporter(metricAggregatorFactory, "Memory", "Free (MB)");
        this.memoryUsed = this.getReporter(metricAggregatorFactory, "Memory", "Used (MB)");
        this.memoryTotal = this.getReporter(metricAggregatorFactory, "Memory", "Total (MB)");
    }

    private IMetricReporter getReporter(IMetricAggregatorFactory metricFactory, String group, String counter) {
        String metricName = "Hardware Resources|" + group + "|" + counter;
        try {
            return metricFactory.safeGetAggregator(new AgentRawMetricIdentifier(metricName, MetricAggregatorType.AVERAGE, MetricTimeRollupType.AVERAGE, MetricClusterRollupType.INDIVIDUAL, MetricHoleHandlingType.REGULAR_COUNTER));
        }
        catch (MetricOverflowException | MetricReporterTypeMismatchException e) {
            log.warn("Unable to get metric aggregator " + metricName, e);
            return NO_OP_REPORTER;
        }
    }

    public void output(String[] args) throws SigarException {
        this.reportCpuStats();
        this.reportMemoryStats();
    }

    private void reportCpuStats() throws SigarException {
        CpuPerc cpuPerc = this.sigar.getCpuPerc();
        this.cpuBusy.report(SigarSecondTask.asPercent(cpuPerc.getUser() + cpuPerc.getSys() + cpuPerc.getNice() + cpuPerc.getWait() + cpuPerc.getIrq() + cpuPerc.getSoftIrq()));
        this.cpuIdle.report(SigarSecondTask.asPercent(cpuPerc.getIdle()));
        this.cpuStolen.report(SigarSecondTask.asPercent(cpuPerc.getStolen()));
    }

    private void reportMemoryStats() throws SigarException {
        Mem mem = this.sigar.getMem();
        long memTotal = mem.getTotal();
        long memFree = mem.getActualFree();
        long memUsed = mem.getActualUsed();
        this.memoryUsedPerc.report(SigarSecondTask.asPercent(memUsed, memTotal));
        this.memoryFreePerc.report(SigarSecondTask.asPercent(memFree, memTotal));
        this.memoryUsed.report(SigarSecondTask.asMegabytes(memUsed));
        this.memoryFree.report(SigarSecondTask.asMegabytes(memFree));
        this.memoryTotal.report(SigarSecondTask.asMegabytes(memTotal));
    }

    private static long asPercent(double fraction) {
        return Math.round(fraction * 100.0);
    }

    private static long asPercent(double numerator, double denominator) {
        return SigarSecondTask.asPercent(numerator / denominator);
    }

    private static long asMegabytes(long bytes) {
        return Math.round((double)bytes / 1048576.0);
    }

    public void run() {
        try {
            this.processCommand(new String[0]);
        }
        catch (ShellCommandExecException | ShellCommandUsageException e) {
            log.warn("Exception processing command", e);
        }
    }
}

