/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.sigar;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.IMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricIdentifier;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorDelegate;
import com.singularity.ee.agent.systemagent.task.sigar.DiskAgg;
import com.singularity.ee.agent.systemagent.task.sigar.NetworkAgg;
import com.singularity.ee.agent.systemagent.task.sigar.SigarAppAgentMonitor;
import com.singularity.ee.agent.systemagent.task.sigar.SigarConfig;
import com.singularity.ee.controller.api.constants.MetricClusterRollupType;
import com.singularity.ee.controller.api.constants.MetricHoleHandlingType;
import com.singularity.ee.controller.api.constants.MetricTimeRollupType;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandUsageException;

public class SigarMinuteTask
extends SigarCommandBase
implements IAgentRunnable {
    private final Logger logger = LogManager.getLogger(SigarMinuteTask.class);
    private final Map<String, DiskAgg> diskMap = new ConcurrentHashMap<String, DiskAgg>();
    private final Map<String, NetworkAgg> networkMap = new ConcurrentHashMap<String, NetworkAgg>();
    private final IMetricAggregatorFactory metricFactory;
    private final IMetricAggregator rxRateAgg;
    private final IMetricAggregator rxAgg;
    private final IMetricAggregator txAgg;
    private final IMetricAggregator txRateAgg;
    private final IMetricAggregator rxPacketAgg;
    private final IMetricAggregator rxPacketRateAgg;
    private final IMetricAggregator txPacketAgg;
    private final IMetricAggregator txPacketRateAgg;
    private final IMetricAggregator drxAgg;
    private final IMetricAggregator dtxAgg;
    private final IMetricAggregator drAgg;
    private final IMetricAggregator dwAgg;
    private final Set<String> networkInterfaceBlacklist = new HashSet<String>();
    private SigarConfig config;
    private SigarAppAgentMonitor appAgentMonitor;

    public SigarMinuteTask(IMetricAggregatorFactory metricFactory, ManagedMonitorDelegate managedMonitorDelegate) {
        this.metricFactory = metricFactory;
        this.rxAgg = this.createAgg("Hardware Resources|Network|Incoming KB", MetricAggregatorType.OBSERVATION);
        this.rxRateAgg = this.createAgg("Hardware Resources|Network|Incoming KB/sec", MetricAggregatorType.OBSERVATION);
        this.txAgg = this.createAgg("Hardware Resources|Network|Outgoing KB", MetricAggregatorType.OBSERVATION);
        this.txRateAgg = this.createAgg("Hardware Resources|Network|Outgoing KB/sec", MetricAggregatorType.OBSERVATION);
        this.rxPacketAgg = this.createAgg("Hardware Resources|Network|Incoming packets", MetricAggregatorType.OBSERVATION);
        this.rxPacketRateAgg = this.createAgg("Hardware Resources|Network|Incoming packets/sec", MetricAggregatorType.OBSERVATION);
        this.txPacketAgg = this.createAgg("Hardware Resources|Network|Outgoing packets", MetricAggregatorType.OBSERVATION);
        this.txPacketRateAgg = this.createAgg("Hardware Resources|Network|Outgoing packets/sec", MetricAggregatorType.OBSERVATION);
        this.drxAgg = this.createAgg("Hardware Resources|Disks|KB read/sec", MetricAggregatorType.OBSERVATION);
        this.drAgg = this.createAgg("Hardware Resources|Disks|Reads/sec", MetricAggregatorType.OBSERVATION);
        this.dtxAgg = this.createAgg("Hardware Resources|Disks|KB written/sec", MetricAggregatorType.OBSERVATION);
        this.dwAgg = this.createAgg("Hardware Resources|Disks|Writes/sec", MetricAggregatorType.OBSERVATION);
        try {
            this.appAgentMonitor = SigarAppAgentMonitor.reserveAndCreateInstance(this.sigar, managedMonitorDelegate);
        }
        catch (SigarAppAgentMonitor.DuplicateObjectException e) {
            this.logger.error(String.format("Exception %s caught trying to create SigarAppAgentMonitor", e), (Throwable)e);
        }
    }

    public void release() {
        SigarAppAgentMonitor.releaseReservation();
    }

    private IMetricAggregator createAgg(String metricName, MetricAggregatorType type) {
        try {
            return this.metricFactory.safeGetAggregator(SigarMinuteTask.getMI(metricName, type));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IMetricAggregatorFactory getMetricFactory() {
        return this.metricFactory;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void output(String[] args) throws SigarException {
        try {
            FileSystemMap fileSystemMap = this.proxy.getFileSystemMap();
            int drx = 0;
            int dr = 0;
            int dtx = 0;
            int dw = 0;
            for (Object fileSystem : fileSystemMap.keySet()) {
                boolean enabled;
                FileSystem fs = (FileSystem)fileSystemMap.get(fileSystem);
                boolean bl = enabled = fs.getType() == 2 || fs.getType() == 3;
                if (this.config.containsConfigForDisk(fs.getDevName())) {
                    if (!enabled && this.config.isDiskEnabled(fs.getDevName())) {
                        enabled = true;
                    } else if (enabled && !this.config.isDiskEnabled(fs.getDevName())) {
                        enabled = false;
                    }
                }
                this.config.addToDiskTemplate(fs.getDevName(), enabled, enabled);
                if (enabled) {
                    FileSystemUsage usage;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Collecting information for disk: " + fs.getDevName() + " " + fs.getDirName());
                    }
                    try {
                        usage = this.sigar.getFileSystemUsage(fs.getDirName());
                    }
                    catch (Exception e) {
                        this.logger.error("Error getting file system usage for fs [" + fs.getDirName() + "]. Will try later.");
                        continue;
                    }
                    DiskAgg diskAgg = this.getDiskAgg(fs.getDevName());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(fs.getDevName() + " : " + String.valueOf(usage));
                    }
                    diskAgg.getSpaceUsed().report(usage.getUsed());
                    diskAgg.getSpaceAvailable().report(usage.getFree());
                    boolean aggregate = true;
                    if (this.config.containsConfigForDisk(fs.getDevName()) && this.config.isDiskEnabled(fs.getDevName()) && !this.config.doAggregateDisk(fs.getDevName())) {
                        aggregate = false;
                    }
                    long _drx = diskAgg.getReadBytesReporter().report(usage.getDiskReadBytes());
                    long _dr = diskAgg.getReadCountReporter().report(usage.getDiskReads());
                    long _dtx = diskAgg.getWriteBytesReporter().report(usage.getDiskWriteBytes());
                    long _dw = diskAgg.getWriteCountReporter().report(usage.getDiskWrites());
                    diskAgg.getIopsReporter().report(usage.getDiskReads(), usage.getDiskWrites(), usage.getDiskServiceTime(), usage.getDiskQueue());
                    if (aggregate) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Aggregating " + fs.getDirName());
                        }
                        drx = (int)((long)drx + _drx);
                        dr = (int)((long)dr + _dr);
                        dtx = (int)((long)dtx + _dtx);
                        dw = (int)((long)dw + _dw);
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Not aggregating " + fs.getDirName());
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Ignored disk " + fs.getDevName() + " " + fs.getTypeName() + "(" + fs.getType() + ") " + fs.getDirName());
            }
            this.drxAgg.report((long)drx);
            this.dtxAgg.report((long)dtx);
            this.drAgg.report((long)dr);
            this.dwAgg.report((long)dw);
            String[] interfaceNames = this.sigar.getNetInterfaceList();
            long rxRate = 0L;
            long txRate = 0L;
            long rxPacketRate = 0L;
            long txPacketRate = 0L;
            long rx = 0L;
            long tx = 0L;
            long rxPackets = 0L;
            long txPackets = 0L;
            for (String interfaceName : interfaceNames) {
                NetInterfaceStat interfaceStat;
                NetInterfaceConfig interfaceConfig = this.sigar.getNetInterfaceConfig(interfaceName);
                long interfaceFlags = interfaceConfig.getFlags();
                boolean enabledInConfig = false;
                if (this.config.containsConfigForNetwork(interfaceName) && !(enabledInConfig = this.config.isNetworkEnabled(interfaceName))) continue;
                if (this.networkInterfaceBlacklist.contains(interfaceName)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Ignored network interface [" + interfaceName + "] blacklisted because of error.");
                    continue;
                }
                if ((NetFlags.isAnyAddress((String)interfaceConfig.getAddress()) || NetFlags.isLoopback((String)interfaceConfig.getAddress())) && !enabledInConfig) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignored network interface [" + interfaceName + "]. Is loopback.");
                    }
                    this.config.addToNetworkTemplate(interfaceName, false, true);
                    continue;
                }
                this.config.addToNetworkTemplate(interfaceName, true, true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Collecting information for network interface " + interfaceName);
                }
                try {
                    interfaceStat = this.sigar.getNetInterfaceStat(interfaceName);
                }
                catch (Exception e) {
                    this.logger.error("Error fetching network statistics for interface [" + interfaceName + "]. Blacklisting it.", (Throwable)e);
                    this.networkInterfaceBlacklist.add(interfaceName);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(interfaceName + " : " + interfaceStat.toString());
                }
                NetworkAgg agg = this.getNetworkAgg(interfaceName);
                boolean aggregate = true;
                if (enabledInConfig && !this.config.doAggregateNetwork(interfaceName)) {
                    aggregate = false;
                }
                long _rxRate = agg.getIncomingBytesReporter().report(interfaceStat.getRxBytes() / 1024L);
                long _txRate = agg.getOutgoingBytesReporter().report(interfaceStat.getTxBytes() / 1024L);
                long _rxPacketRate = agg.getIncomingPacketsReporter().report(interfaceStat.getRxPackets());
                long _txPacketRate = agg.getOutgoingPacketsReporter().report(interfaceStat.getTxPackets());
                if (aggregate) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Aggregating " + interfaceName);
                    }
                    rxRate += _rxRate;
                    txRate += _txRate;
                    rxPacketRate += _rxPacketRate;
                    txPacketRate += _txPacketRate;
                    rx += interfaceStat.getRxBytes() / 1024L;
                    tx += interfaceStat.getTxBytes() / 1024L;
                    rxPackets += interfaceStat.getRxPackets();
                    txPackets += interfaceStat.getTxPackets();
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Not aggregating " + interfaceName);
            }
            this.rxRateAgg.report(rxRate);
            this.txRateAgg.report(txRate);
            this.rxPacketRateAgg.report(rxPacketRate);
            this.txPacketRateAgg.report(txPacketRate);
            this.rxAgg.report(rx);
            this.txAgg.report(tx);
            this.rxPacketAgg.report(rxPackets);
            this.txPacketAgg.report(txPackets);
            if (this.appAgentMonitor != null) {
                this.appAgentMonitor.run();
            }
        }
        catch (Exception e) {
            this.logger.error("Error getting packet rate statistics: {}", (Throwable)e);
        }
    }

    private DiskAgg getDiskAgg(String devName) {
        DiskAgg diskAgg = this.diskMap.get(devName);
        if (diskAgg == null) {
            diskAgg = new DiskAgg(devName, this);
            this.diskMap.put(devName, diskAgg);
        }
        return diskAgg;
    }

    private NetworkAgg getNetworkAgg(String devName) {
        NetworkAgg networkAgg = this.networkMap.get(devName);
        if (networkAgg == null) {
            networkAgg = new NetworkAgg(devName, this.metricFactory);
            this.networkMap.put(devName, networkAgg);
        }
        return networkAgg;
    }

    public void run() {
        try {
            this.processCommand(new String[0]);
        }
        catch (ShellCommandExecException | ShellCommandUsageException e) {
            this.logger.error("An error occurred while processing the command", (Object)e.getMessage());
        }
    }

    public void setConfig(SigarConfig config) {
        this.config = config;
    }

    public static AgentRawMetricIdentifier getMI(String metricName, MetricAggregatorType aggregatorType) {
        return new AgentRawMetricIdentifier(metricName, aggregatorType, MetricTimeRollupType.AVERAGE, MetricClusterRollupType.INDIVIDUAL, MetricHoleHandlingType.REGULAR_COUNTER);
    }
}

