/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.sigar;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.IMetricAggregatorFactory;
import com.singularity.ee.agent.systemagent.api.ISelfManagedTask;
import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.TaskOutput;
import com.singularity.ee.agent.systemagent.api.exception.TaskExecutionException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorDelegate;
import com.singularity.ee.agent.systemagent.task.sigar.SigarConfig;
import com.singularity.ee.agent.systemagent.task.sigar.SigarMinuteTask;
import com.singularity.ee.agent.systemagent.task.sigar.SigarSecondTask;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.loader.FileSystemClassLoader;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hyperic.sigar.OperatingSystem;

public class SigarDelegate
implements ISelfManagedTask {
    private Logger logger = LogManager.getLogger((String)SigarDelegate.class.getName());
    private SigarSecondTask avgTask;
    private SigarMinuteTask cumulativeTask;
    private IAgentScheduledFuture minuteFuture;
    private IAgentScheduledFuture secondFuture;
    private IAgentScheduledExecutorService scheduler;

    @Override
    public void setClassLoader(FileSystemClassLoader classLoader) {
    }

    @Override
    public TaskOutput execute(Map<String, String> taskArguments, TaskExecutionContext taskContext) throws TaskExecutionException {
        String osName;
        try {
            OperatingSystem os = OperatingSystem.getInstance();
            osName = os.getName();
        }
        catch (Exception e) {
            this.logger.error("Error determining the OS. [" + e.getMessage() + "]");
            return new TaskOutput("Sigar tasks could not be scheduled, operating system is not supported.");
        }
        if (OperatingSystem.isSupported((String)osName)) {
            SigarConfig config = new SigarConfig(taskContext.getTaskDir());
            this.logger.info("Operating system is supported [" + osName + "]");
            this.cumulativeTask.setConfig(config);
            this.secondFuture = this.scheduler.scheduleWithFixedDelay((IAgentRunnable)this.avgTask, 2L, 2L, AgentTimeUnit.SECONDS);
            this.minuteFuture = this.scheduler.scheduleAtFixedRate((IAgentRunnable)this.cumulativeTask, 15L, 60L, AgentTimeUnit.SECONDS);
            this.avgTask.run();
            this.cumulativeTask.run();
            config.writeTemplate();
            return new TaskOutput("Sigar tasks Scheduled!");
        }
        this.logger.warn("Operating system is NOT supported [" + osName + "] Please set enabled flag in HardwareMonitors/monitor.xml file.");
        return new TaskOutput("Sigar tasks could not be scheduled, operating system is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.secondFuture != null) {
            this.secondFuture.cancel(false);
        }
        if (this.minuteFuture != null) {
            this.minuteFuture.cancel(false);
        }
        if (this.cumulativeTask != null) {
            this.cumulativeTask.release();
        }
        SigarDelegate sigarDelegate = this;
        synchronized (sigarDelegate) {
            this.notifyAll();
        }
    }

    @Override
    public void init(IMetricAggregatorFactory metricAggregatorFactory, IAgentScheduledExecutorService scheduler, ManagedMonitorDelegate managedMonitorDelegate) {
        this.avgTask = new SigarSecondTask(metricAggregatorFactory);
        this.cumulativeTask = new SigarMinuteTask(metricAggregatorFactory, managedMonitorDelegate);
        this.scheduler = scheduler;
    }
}

