/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.sigar;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SigarConfig {
    private final Logger logger = LogManager.getLogger(SigarConfig.class);
    private final File templateFile;
    private final Map<String, Boolean[]> config = new ConcurrentHashMap<String, Boolean[]>();
    private final Map<String, Boolean[]> diskConfigTemplate = new ConcurrentHashMap<String, Boolean[]>();
    private final Map<String, Boolean[]> networkConfigTemplate = new ConcurrentHashMap<String, Boolean[]>();

    public SigarConfig(String taskDir) {
        File configFile = new File(taskDir + File.separatorChar + "task.xml");
        this.templateFile = new File(taskDir + File.separatorChar + "task-template.xml");
        if (configFile.canRead()) {
            try {
                this.load(configFile);
            }
            catch (Exception e) {
                this.logger.error("Exception occurred while loading configFile: {}", (Object)e.getMessage());
            }
        } else {
            this.logger.warn("No task file found. Will use default configuration. " + configFile.getAbsolutePath());
        }
    }

    public boolean containsConfigForDisk(String name) {
        return this.containsConfig("disk", name);
    }

    public boolean isDiskEnabled(String name) {
        return this.isEnabled("disk", name);
    }

    public boolean doAggregateDisk(String name) {
        return this.doAggregate("disk", name);
    }

    public boolean containsConfigForNetwork(String name) {
        return this.containsConfig("network", name);
    }

    public boolean isNetworkEnabled(String name) {
        return this.isEnabled("network", name);
    }

    public boolean doAggregateNetwork(String name) {
        return this.doAggregate("network", name);
    }

    private boolean containsConfig(String prefix, String name) {
        return this.config.containsKey(prefix + ":" + name);
    }

    private boolean isEnabled(String prefix, String name) {
        Boolean[] enabledAndAggregate = this.config.get(prefix + ":" + name);
        if (enabledAndAggregate == null) {
            return true;
        }
        return enabledAndAggregate[0];
    }

    private boolean doAggregate(String prefix, String name) {
        Boolean[] enabledAndAggregate = this.config.get(prefix + ":" + name);
        if (enabledAndAggregate == null) {
            return true;
        }
        return enabledAndAggregate[1];
    }

    private void load(File file) throws IOException, SAXException, ParserConfigurationException {
        this.logger.info("Loading file " + file.getAbsolutePath());
        Document doc = XMLParseUtility.getXmlDocumentFromFile((File)file);
        List disks = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)doc.getDocumentElement(), (String)"disk");
        for (Element disk : disks) {
            String diskName = disk.getTextContent().trim();
            boolean enabled = StringOperations.safeParseBoolean((String)disk.getAttribute("enabled"), (boolean)true);
            boolean aggregate = StringOperations.safeParseBoolean((String)disk.getAttribute("aggregate"), (boolean)true);
            this.logger.info("disk [" + diskName + "] enabled [" + enabled + "] aggregate [" + aggregate + "]");
            this.config.put("disk:" + diskName, new Boolean[]{enabled, aggregate});
        }
        List networks = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)doc.getDocumentElement(), (String)"network");
        for (Element network : networks) {
            String networkName = network.getTextContent().trim();
            boolean enabled = StringOperations.safeParseBoolean((String)network.getAttribute("enabled"), (boolean)true);
            boolean aggregate = StringOperations.safeParseBoolean((String)network.getAttribute("aggregate"), (boolean)true);
            this.logger.info("network [" + networkName + "] enabled [" + enabled + "] aggregate [" + aggregate + "]");
            this.config.put("network:" + networkName, new Boolean[]{enabled, aggregate});
        }
    }

    public void addToDiskTemplate(String name, boolean enabled, boolean aggregate) {
        this.diskConfigTemplate.put(name, new Boolean[]{enabled, aggregate});
    }

    public void addToNetworkTemplate(String name, boolean enabled, boolean aggregate) {
        this.networkConfigTemplate.put(name, new Boolean[]{enabled, aggregate});
    }

    public void writeTemplate() {
        try {
            Boolean[] flags;
            Element element;
            XMLWriter xmlWriter = new XMLWriter();
            Document xmlDoc = xmlWriter.getDocument();
            Element rootElement = xmlDoc.createElement("config");
            xmlDoc.appendChild((Node)rootElement);
            for (String diskName : this.diskConfigTemplate.keySet()) {
                element = xmlDoc.createElement("disk");
                flags = this.diskConfigTemplate.get(diskName);
                element.setAttribute("enabled", "" + flags[0]);
                element.setAttribute("aggregate", "" + flags[1]);
                element.appendChild((Node)xmlDoc.createTextNode(diskName));
                rootElement.appendChild((Node)element);
            }
            for (String networkName : this.networkConfigTemplate.keySet()) {
                element = xmlDoc.createElement("network");
                flags = this.networkConfigTemplate.get(networkName);
                element.setAttribute("enabled", "" + flags[0]);
                element.setAttribute("aggregate", "" + flags[1]);
                element.appendChild((Node)xmlDoc.createTextNode(networkName));
                rootElement.appendChild((Node)element);
            }
            XMLWriter.saveToFile((Element)rootElement, (String)this.templateFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.logger.warn("Error writing template file " + this.templateFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

