/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.sigar;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;

public class FactorAndDeltaReporter {
    private IMetricAggregator agg;
    private long lastValue = -1L;
    private long lastTimestamp = -1L;
    private int factor;

    public FactorAndDeltaReporter(IMetricAggregator agg, int factor) {
        this.agg = agg;
        this.factor = factor;
    }

    public long report(long value) {
        long kbValuePerSec = 0L;
        if (this.lastValue != -1L) {
            long timeInSeconds = (System.currentTimeMillis() - this.lastTimestamp) / 1000L;
            kbValuePerSec = (long)((double)(value - this.lastValue) * 1.0 / (double)this.factor / (double)timeInSeconds);
            this.agg.report(kbValuePerSec);
        }
        this.lastValue = value;
        this.lastTimestamp = System.currentTimeMillis();
        return kbValuePerSec;
    }
}

