/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.classloading;

import com.google.inject.Inject;
import com.singularity.ee.agent.systemagent.task.classloading.ExtensionLibs;
import com.singularity.ee.agent.systemagent.task.classloading.SystemLibs;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompatibilityClassLoader
extends ClassLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompatibilityClassLoader.class);
    private final ClassLoader extensionLibsClassLoader;
    private final ClassLoader parentClassLoader;

    @Inject
    CompatibilityClassLoader(@ExtensionLibs ClassLoader extensionLibsClassLoader, @SystemLibs ClassLoader parentClassLoader) {
        this.extensionLibsClassLoader = extensionLibsClassLoader;
        this.parentClassLoader = parentClassLoader;
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> klass;
        if (CompatibilityClassLoader.isAppDClass(name) || CompatibilityClassLoader.isLoggingClass(name) || CompatibilityClassLoader.isJavaClass(name)) {
            log.trace("Loading {} from System Class Loader", (Object)name);
            klass = this.parentClassLoader.loadClass(name);
            log.trace("Success loading {} from System Class Loader", (Object)name);
        } else {
            log.trace("Loading {} from Extension Libraries Class Loader", (Object)name);
            klass = this.extensionLibsClassLoader.loadClass(name);
            log.trace("Success loading {} from Extension Libraries Class Loader", (Object)name);
        }
        if (resolve) {
            this.resolveClass(klass);
        }
        return klass;
    }

    @Override
    public URL getResource(String name) {
        return this.extensionLibsClassLoader.getResource(name);
    }

    private static boolean isAppDClass(String name) {
        return name.startsWith("com.appdynamics") || name.startsWith("com.singularity");
    }

    private static boolean isLoggingClass(String name) {
        return name.startsWith("org.slf4j") || name.startsWith("org.apache.logging.log4j");
    }

    private static boolean isJavaClass(String name) {
        return name.startsWith("java");
    }
}

