/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.apache;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

class ApacheWorkersConfigHandler {
    private static final String AJP_WORKER_TYPE = "ajp13";
    private static final String LB_TYPE = "lb";
    private static final String WORKER = "worker";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String TYPE = "type";
    private static final String LBFACTOR = "lbfactor";
    private static final String PROPERTY_SEPARATOR = ".";
    private static final String WORKERS_LIST = "worker.list";
    private static final String BALANCE_WORKERS = "balance_workers";
    private final File workersConfigFile;
    private final Properties workersProperties;
    private final String loadBalancerWorkerName;

    ApacheWorkersConfigHandler(String workersConfigFilePath, String loadBalancerWorkerName) throws IOException {
        if (workersConfigFilePath == null) {
            throw new NullPointerException("workers config file path is null");
        }
        if (loadBalancerWorkerName == null) {
            throw new NullPointerException("load balancer worker name is null");
        }
        this.workersConfigFile = new File(workersConfigFilePath);
        this.workersProperties = new Properties();
        this.loadBalancerWorkerName = loadBalancerWorkerName;
        this.initFile();
    }

    private void initFile() throws IOException {
        if (!this.workersConfigFile.exists()) {
            this.workersConfigFile.createNewFile();
        }
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.workersConfigFile));){
            this.workersProperties.load(bis);
        }
        String workersList = this.workersProperties.getProperty(WORKERS_LIST);
        if (workersList == null || workersList.trim().length() == 0) {
            this.workersProperties.setProperty(WORKERS_LIST, this.loadBalancerWorkerName);
        } else if (workersList.indexOf(this.loadBalancerWorkerName) == -1) {
            this.workersProperties.setProperty(WORKERS_LIST, workersList + "," + this.loadBalancerWorkerName);
        }
        String loadBalancerWorkerTypeProperty = "worker." + this.loadBalancerWorkerName + ".type";
        if (this.workersProperties.getProperty(loadBalancerWorkerTypeProperty) == null) {
            this.workersProperties.setProperty(loadBalancerWorkerTypeProperty, LB_TYPE);
        }
    }

    private void saveFile() throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.workersConfigFile);){
            this.workersProperties.store(fos, "AppDynamics managed workers.properties file\n\n");
        }
    }

    void addWorkerToLB(String workerName, String hostName, String port, String lbFactor) throws Exception {
        if (workerName == null) {
            throw new NullPointerException("worker name is null");
        }
        if (workerName.trim().length() == 0) {
            throw new IllegalArgumentException("worker name is invalid");
        }
        if (hostName == null) {
            throw new NullPointerException("host name is null");
        }
        if (hostName.trim().length() == 0) {
            throw new IllegalArgumentException("host name is invalid");
        }
        int portNum = Integer.parseInt(port);
        if (portNum < 1 || portNum > 65535) {
            throw new IllegalArgumentException("port is outside the valid range: " + port);
        }
        int lbFactorNum = Integer.parseInt(lbFactor);
        if (lbFactorNum < 1) {
            throw new IllegalArgumentException("lb factor must be 1 or greater");
        }
        String loadBalanceWorkerBalanceWorkersProperty = "worker." + this.loadBalancerWorkerName + ".balance_workers";
        String balanceWorkers = this.workersProperties.getProperty(loadBalanceWorkerBalanceWorkersProperty);
        if (balanceWorkers != null && balanceWorkers.contains(workerName)) {
            throw new IllegalArgumentException(ApacheWorkersConfigHandler.getMessageStringForWorker(workerName) + " already exists");
        }
        if (balanceWorkers == null || balanceWorkers.trim().length() == 0) {
            this.workersProperties.setProperty(loadBalanceWorkerBalanceWorkersProperty, workerName);
        } else {
            this.workersProperties.setProperty(loadBalanceWorkerBalanceWorkersProperty, balanceWorkers + "," + workerName);
        }
        this.workersProperties.setProperty(ApacheWorkersConfigHandler.getHostPropertyForWorker(workerName), hostName);
        this.workersProperties.setProperty(ApacheWorkersConfigHandler.getPortPropertyForWorker(workerName), port);
        this.workersProperties.setProperty(ApacheWorkersConfigHandler.getTypePropertyForWorker(workerName), AJP_WORKER_TYPE);
        this.workersProperties.setProperty(ApacheWorkersConfigHandler.getLBFactorPropertyForWorker(workerName), lbFactor);
        String workersValue = this.workersProperties.getProperty(WORKERS_LIST);
        if (workersValue != null && workersValue.contains(workerName)) {
            throw new IllegalArgumentException(ApacheWorkersConfigHandler.getMessageStringForWorker(workerName) + " already exists");
        }
        if (workersValue == null || workersValue.trim().length() == 0) {
            this.workersProperties.setProperty(WORKERS_LIST, workerName);
        } else {
            this.workersProperties.setProperty(WORKERS_LIST, workersValue + "," + workerName);
        }
        this.saveFile();
    }

    void removeWorkerFromLB(String workerName) throws Exception {
        if (workerName == null) {
            throw new NullPointerException("worker name is null");
        }
        if (workerName.trim().length() == 0) {
            throw new IllegalArgumentException("worker name is invalid");
        }
        String loadBalanceWorkerBalanceWorkersProperty = "worker." + this.loadBalancerWorkerName + ".balance_workers";
        String balanceWorkers = this.workersProperties.getProperty(loadBalanceWorkerBalanceWorkersProperty);
        if (balanceWorkers == null) {
            throw new IllegalStateException("No workers are currently configured");
        }
        if (!balanceWorkers.contains(workerName)) {
            throw new IllegalArgumentException(ApacheWorkersConfigHandler.getMessageStringForWorker(workerName) + " does not exist");
        }
        this.workersProperties.remove(ApacheWorkersConfigHandler.getHostPropertyForWorker(workerName));
        this.workersProperties.remove(ApacheWorkersConfigHandler.getPortPropertyForWorker(workerName));
        this.workersProperties.remove(ApacheWorkersConfigHandler.getTypePropertyForWorker(workerName));
        this.workersProperties.remove(ApacheWorkersConfigHandler.getLBFactorPropertyForWorker(workerName));
        String remainingWorkers = this.removeWorkerFromList(workerName, balanceWorkers);
        this.workersProperties.setProperty(loadBalanceWorkerBalanceWorkersProperty, remainingWorkers);
        if (remainingWorkers.length() == 0) {
            String workersList = this.workersProperties.getProperty(WORKERS_LIST);
            this.workersProperties.setProperty(WORKERS_LIST, this.removeWorkerFromList(this.loadBalancerWorkerName, workersList));
        }
        this.saveFile();
    }

    private String removeWorkerFromList(String workerName, String workerList) {
        StringTokenizer st = new StringTokenizer(workerList, ",");
        ArrayList<String> currentList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(workerName)) continue;
            currentList.add(token);
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (String currentWorker : currentList) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(currentWorker);
            ++i;
        }
        return sb.toString();
    }

    private static String getHostPropertyForWorker(String workerName) {
        return "worker." + workerName + ".host";
    }

    private static String getPortPropertyForWorker(String workerName) {
        return "worker." + workerName + ".port";
    }

    private static String getTypePropertyForWorker(String workerName) {
        return "worker." + workerName + ".type";
    }

    private static String getLBFactorPropertyForWorker(String workerName) {
        return "worker." + workerName + ".lbfactor";
    }

    private static String getMessageStringForWorker(String workerName) {
        return "worker [" + workerName + "]";
    }
}

