/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.agent.systemagent.api.IOutputPropertyGatherer;
import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.ITaskVerifier;
import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.TaskOutput;
import com.singularity.ee.agent.systemagent.task.ControllerUtil;
import com.singularity.ee.agent.systemagent.task.ITimeout;
import com.singularity.ee.agent.systemagent.task.OutputGatherer;
import com.singularity.ee.agent.systemagent.task.TimeoutTask;
import com.singularity.ee.controller.api.constants.TaskExecutionStatus;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskExecuterRunnable
implements IAgentRunnable,
ITimeout {
    private final ITask task;
    private final String taskID;
    private final Map<String, String> taskArguments;
    private final TaskExecutionContext context;
    private final ControllerUtil controllerUtil;
    private volatile boolean isVerifierEnabled;
    private volatile boolean isAlive;
    private volatile boolean timedOut;
    private final long timeOut;
    private final IAgentScheduledExecutorService scheduler;
    private volatile ITaskVerifier customVerifier;
    private volatile boolean stopOutputWhenTaskExits = true;
    private volatile OutputGatherer outputGatherer;
    private volatile OutputGatherer errGatherer;
    private Logger logger = LogManager.getLogger((String)TaskExecuterRunnable.class.getName());
    private final IOutputPropertyGatherer outputPropertyGatherer;
    private List<ScheduledFuture<?>> schedules = new ArrayList(2);

    TaskExecuterRunnable(ITask task, String taskID, Map<String, String> taskArguments, TaskExecutionContext context, int taskTimeOut, ControllerUtil controllerUtil, IAgentScheduledExecutorService scheduler, boolean isVerifierEnabled, IOutputPropertyGatherer outputPropertyGatherer) {
        this.scheduler = scheduler;
        this.controllerUtil = controllerUtil;
        this.task = task;
        this.taskID = taskID;
        this.taskArguments = taskArguments;
        this.context = context;
        this.outputPropertyGatherer = outputPropertyGatherer;
        this.timeOut = this.getTimeOut(taskTimeOut);
        this.isVerifierEnabled = isVerifierEnabled;
    }

    void setCustomVerifier(ITaskVerifier verifier) {
        this.customVerifier = verifier;
    }

    void setStopOutputCaptureWhenTaskExits(boolean stopOutputWhenTaskExits) {
        this.stopOutputWhenTaskExits = stopOutputWhenTaskExits;
    }

    public void run() {
        this.isAlive = true;
        try {
            this.setupTimeout();
            TaskOutput output = this.task.execute(this.taskArguments, this.context);
            Thread.sleep(2000L);
            this.verifyTaskIfNeeded();
            if (!this.timedOut) {
                if (!this.isVerifierEnabled) {
                    this.logger.debug("Sending successful task output to the controller task id-" + this.taskID + "; status-" + output.getStatusMessage());
                    this.controllerUtil.sendExecutionStatus(this.taskID, output.getStatusMessage(), TaskExecutionStatus.SUCCESSFUL, true, this.outputPropertyGatherer.getProperties());
                }
            } else {
                this.logger.debug("Task timedout - task id-" + this.taskID + " Status-" + output.getStatusMessage());
            }
        }
        catch (Exception e) {
            this.logger.warn("Task Execution failed", (Throwable)e);
            this.controllerUtil.sendExecutionStatus(this.taskID, "Error executing task" + e.getMessage(), TaskExecutionStatus.FAILED, true, this.outputPropertyGatherer.getProperties());
        }
        finally {
            this.isAlive = false;
            this.stopOutput();
        }
    }

    void setOutputGatherer(OutputGatherer outputGatherer) {
        this.outputGatherer = outputGatherer;
    }

    void setErrGatherer(OutputGatherer errGatherer) {
        this.errGatherer = errGatherer;
    }

    private void stopOutput() {
        if (this.stopOutputWhenTaskExits) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.error("Exception occurred while waiting to shutdown output gatherers: {}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
            if (this.outputGatherer != null) {
                this.logger.info("Task Finished Setting Output gatherer inactive ################### ))))))))))))");
                this.outputGatherer.setInactive();
            }
            if (this.errGatherer != null) {
                this.errGatherer.setInactive();
            }
            for (ScheduledFuture<?> schedule : this.schedules) {
                schedule.cancel(true);
            }
        }
    }

    private void verifyTaskIfNeeded() {
        if (this.customVerifier != null) {
            boolean success = this.customVerifier.verify(this.taskArguments);
            if (success) {
                this.logger.debug("Task Verified successfully ");
                this.controllerUtil.sendExecutionStatus(this.taskID, "Task [" + this.taskID + "] verified successfully", TaskExecutionStatus.SUCCESSFUL, true, this.outputPropertyGatherer.getProperties());
            } else {
                this.logger.warn("Task Execution failed");
                this.controllerUtil.sendExecutionStatus(this.taskID, "Task [" + this.taskID + "] verification failed.", TaskExecutionStatus.FAILED, true, this.outputPropertyGatherer.getProperties());
            }
        }
    }

    private void setupTimeout() {
        TimeoutTask timeoutTask = new TimeoutTask(this);
        this.scheduler.schedule((IAgentRunnable)timeoutTask, this.timeOut, AgentTimeUnit.MILLISECONDS);
    }

    private long getTimeOut(int valueRead) {
        long timeout = valueRead == -1 ? 300000L : (long)valueRead * 1000L;
        return timeout;
    }

    @Override
    public void timeOut(long currentTime) {
        if (this.isAlive) {
            this.logger.info("Task Execution for Task [" + this.taskID + "] timed out");
            this.controllerUtil.sendExecutionStatus(this.taskID, "Task Execution Timed Out", TaskExecutionStatus.TIMEDOUT, true, this.outputPropertyGatherer.getProperties());
            this.timedOut = true;
        }
    }

    void addOutputCaptureSchedule(ScheduledFuture<?> captureFuture) {
        this.schedules.add(captureFuture);
    }
}

