/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyBufferedReader
extends BufferedReader {
    private static Logger logger = LogManager.getLogger((String)ProxyBufferedReader.class.getName());
    private static final byte[] EMPTY_BYTE_ARRAY = "".getBytes();
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    private BufferedReader realReader;

    public ProxyBufferedReader(Reader in) {
        super(new InputStreamReader(new ByteArrayInputStream(EMPTY_BYTE_ARRAY)));
    }

    public void initReader(InputStream is) {
        this.isInitialized.set(false);
        if (this.realReader != null) {
            try {
                this.realReader.close();
            }
            catch (IOException e) {
                logger.error("Error closing old stream:" + String.valueOf(e));
            }
            this.realReader = null;
        }
        this.realReader = new BufferedReader(new InputStreamReader(is));
        this.isInitialized.set(true);
    }

    @Override
    public int read() throws IOException {
        this.check();
        return this.realReader.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.check();
        return this.realReader.read(cbuf, off, len);
    }

    @Override
    public String readLine() throws IOException {
        this.check();
        return this.realReader.readLine();
    }

    @Override
    public long skip(long n) throws IOException {
        this.check();
        return this.realReader.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.isInitialized.get() && this.realReader.ready();
    }

    @Override
    public boolean markSupported() {
        return this.realReader.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.check();
        this.realReader.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.check();
        this.realReader.reset();
    }

    @Override
    public void close() throws IOException {
        this.isInitialized.set(false);
        if (this.realReader != null) {
            this.realReader.close();
            this.realReader = null;
        }
        this.realReader = null;
        this.isInitialized.set(false);
    }

    private void check() throws IOException {
        if (!this.isInitialized.get()) {
            throw new IOException("Underlying Input Stream not ready");
        }
    }
}

