/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.agent.systemagent.api.IStreamConsumer;
import com.singularity.ee.agent.systemagent.task.ControllerUtil;
import com.singularity.ee.agent.systemagent.task.ITimeout;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutputGatherer
implements IStreamConsumer,
ITimeout {
    public static final long DEFAULT_INTERMEDIATE_OUTPUT_INTERVAL = 60000L;
    public static final String STD_OUT = "stdout";
    public static final String STD_ERR = "stderr";
    private static Logger logger = LogManager.getLogger((String)OutputGatherer.class.getName());
    private final StringBuffer output = new StringBuffer();
    private final IntermediateOutputGenerator intermediateOutputGenerator;
    private volatile boolean isActive = true;
    private final String taskID;
    private final String prefix;
    private final ControllerUtil controllerUtil;

    public OutputGatherer(String taskID, String gathererPrefix, ControllerUtil controllerUtil, IAgentScheduledExecutorService scheduler) {
        this.taskID = taskID;
        this.prefix = gathererPrefix;
        this.controllerUtil = controllerUtil;
        this.intermediateOutputGenerator = new IntermediateOutputGenerator();
        scheduler.schedule((IAgentRunnable)this.intermediateOutputGenerator, 60000L, AgentTimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeLine(String line) {
        if (line != null && !line.equals("")) {
            StringBuffer stringBuffer = this.output;
            synchronized (stringBuffer) {
                this.output.append(this.prefix).append(">>").append(line);
                this.output.append("\n");
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public void setInactive() {
        this.isActive = false;
        this.sendOutputToController();
    }

    @Override
    public void timeOut(long currentTime) {
        if (!this.isActive) {
            return;
        }
        logger.info("Output gatherer on [" + this.prefix + "] for TaskID [" + this.taskID + "] Timed out at " + String.valueOf(new Date(currentTime)));
        this.isActive = false;
        this.sendOutputToController();
    }

    private void sendOutputToController() {
        logger.info("Sending output to controller.....");
        this.intermediateOutputGenerator.cancel();
        if (this.prefix.equals(STD_OUT)) {
            this.controllerUtil.sendStdOutStreamDataForTask(this.taskID, this.output.toString());
        } else if (!this.output.toString().equals("")) {
            this.controllerUtil.sendStdErrStreamDataForTask(this.taskID, this.output.toString());
        }
    }

    private class IntermediateOutputGenerator
    implements IAgentRunnable {
        private volatile boolean cancelled;

        private IntermediateOutputGenerator() {
        }

        public void run() {
            if (!this.cancelled) {
                if (OutputGatherer.this.prefix.equals(OutputGatherer.STD_OUT) && !"".equals(OutputGatherer.this.output.toString())) {
                    OutputGatherer.this.controllerUtil.sendStdOutStreamDataForTask(OutputGatherer.this.taskID, OutputGatherer.this.output.toString());
                } else {
                    OutputGatherer.this.controllerUtil.sendStdErrStreamDataForTask(OutputGatherer.this.taskID, OutputGatherer.this.output.toString());
                }
                OutputGatherer.this.output.setLength(0);
            }
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

