/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.agent.systemagent.api.IStreamConsumer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogFileReaderRunnable
implements Runnable {
    private Logger logger = LogManager.getLogger((String)LogFileReaderRunnable.class.getName());
    public static final int CONSECUTIVE_READ_ATTEMPTS = 5;
    private String logFilePath;
    private RandomAccessFile logFile;
    private List<IStreamConsumer> consumerList = new ArrayList<IStreamConsumer>();
    private long filePointer;

    public LogFileReaderRunnable(String logFilePath) {
        this.logFilePath = logFilePath;
        this.setupFilePointer();
    }

    public void addStreamConsumer(IStreamConsumer consumer) {
        this.consumerList.add(consumer);
    }

    private void setupFilePointer() {
        if (new File(this.logFilePath).exists()) {
            try {
                this.logFile = new RandomAccessFile(new File(this.logFilePath), "r");
                this.filePointer = this.logFile.length();
                this.logger.debug("log file exists before process started at[" + this.logFilePath + "]");
            }
            catch (IOException e) {
                this.logger.debug("Error setting up log file verification", (Throwable)e);
            }
            finally {
                this.closeFile();
            }
        }
    }

    private void recreateRandomAcessFile() throws IOException {
        if (new File(this.logFilePath).exists()) {
            System.out.println("(((((((((((((((((((((((((((((((((((((((((((((((((((((Log file reader runnable ***Found file -" + this.logFilePath);
            try {
                this.logFile = new RandomAccessFile(new File(this.logFilePath), "r");
                System.out.println("(((((((((((((((((((((((((((((((((((((((((((((((((((((Log file reader runnable ***seeking pointer at -" + this.filePointer);
                if (this.logFile.length() < this.filePointer) {
                    System.out.println("(((((((((((((((((((((((((((((((((((((((((((((((((((((Log file reader runnable ***resetting pointer at -");
                    this.filePointer = 0L;
                }
                this.logFile.seek(this.filePointer);
                this.logger.debug("reopened random access file to read from log file[" + this.logFilePath + "]");
            }
            catch (IOException e) {
                this.logger.debug("Error setting up log file verification for file[" + this.logFilePath + "]", (Throwable)e);
                throw e;
            }
        } else {
            System.out.println("(((((((((((((((((((((((((((((((((((((((((((((((((((((Log file reader runnable ***cannot find file -" + this.logFilePath);
            this.logger.debug("Could not find log file to verify at [" + this.logFilePath + "] at " + String.valueOf(new Date(System.currentTimeMillis())));
            throw new IOException("Cannot find file at" + this.logFilePath);
        }
    }

    private void closeFile() {
        try {
            this.logFile.close();
        }
        catch (IOException e) {
            this.logger.trace("Error closing random access file", (Throwable)e);
        }
        finally {
            this.logFile = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        System.out.println("(((((((((((((((((((((((((((((((((((((((((((((((((((((Log file reader runnable ***");
        while (true) {
            errorIndex = 0;
            try {
                if (this.logFile == null) {
                    System.out.println("(((((((((((((((((((((((((((((((((((((((((((((((((((((Log file reader runnable ***recreating RAF");
                    this.recreateRandomAcessFile();
                }
                if (!this.hasActiveConsumers()) break;
                lineRead = this.logFile.readLine();
                this.logger.trace("Line read from the log file[" + this.logFilePath + "] -" + lineRead);
                if (lineRead == null) {
                    this.logger.trace("Read EOF Random Axs file length ->" + this.logFile.length() + ", pointer " + this.logFile.getFilePointer() + " For log file [" + this.logFilePath + "]");
                    this.filePointer = this.logFile.length();
                    this.closeFile();
                    this.sleep(250L);
                    continue;
                }
                if (errorIndex > 0) {
                    errorIndex = 0;
                }
                this.feedActiveConsumers(lineRead);
                continue;
            }
            catch (IOException e) {
                this.logger.debug("Error reading log file ", (Throwable)e);
                this.sleep(250L);
                if (++errorIndex > 5) ** break;
                continue;
                this.logger.debug("Exceeded 5 attempts to access log file to verify at [" + this.logFilePath + "] at " + String.valueOf(new Date(System.currentTimeMillis())));
                this.logger.error("Could not access log file for [" + this.logFilePath + "], aborting verification.");
                return;
            }
            break;
        }
    }

    private void feedActiveConsumers(String line) {
        for (int i = 0; i < this.consumerList.size(); ++i) {
            IStreamConsumer consumer = this.consumerList.get(i);
            if (!consumer.isActive()) {
                this.consumerList.remove(consumer);
                continue;
            }
            consumer.consumeLine(line);
        }
    }

    private boolean hasActiveConsumers() {
        for (IStreamConsumer consumer : this.consumerList) {
            if (!consumer.isActive()) continue;
            return true;
        }
        return false;
    }

    public void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            this.logger.debug("Error sleeping - log monitor", (Throwable)e);
        }
    }
}

