/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.google.common.annotations.VisibleForTesting;
import com.singularity.ee.agent.systemagent.task.ProxyBufferedReader;
import com.singularity.ee.controller.api.exceptions.IllegalOperationException;
import com.singularity.ee.util.io.Chmod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineEndingNormalizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LineEndingNormalizer.class);
    private static final char PERMISSIONS_NONE = '-';
    private final ProxyBufferedReader outReader = new ProxyBufferedReader(null);
    private final ProxyBufferedReader errReader = new ProxyBufferedReader(null);

    public void normalizeLineEndings(File file) throws IOException, IllegalOperationException {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            log.debug("Line ending normalization skipped on Windows for file: {}", (Object)file.getAbsolutePath());
            return;
        }
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException("Invalid file provided: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("File cannot be read: " + file.getAbsolutePath());
        }
        if (!file.canWrite()) {
            throw new IOException("File cannot be written to: " + file.getAbsolutePath());
        }
        Path filePath = file.toPath();
        Path tempFile = Files.createTempFile(filePath.getParent(), "normalized-" + System.nanoTime(), ".tmp", new FileAttribute[0]);
        String originalPermissions = this.getPermissions(file);
        try (BufferedReader reader = Files.newBufferedReader(filePath, StandardCharsets.UTF_8);
             BufferedWriter writer = Files.newBufferedWriter(tempFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE);){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
            Files.move(tempFile, filePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            log.debug("Normalized line endings for file: {}", (Object)file.getAbsolutePath());
            LineEndingNormalizer.applyPermissions(file, originalPermissions);
        }
        catch (IOException e) {
            Files.deleteIfExists(tempFile);
            log.error("Error normalizing line endings for file: {}", (Object)file.getAbsolutePath(), (Object)e);
            throw e;
        }
    }

    private static void applyPermissions(File file, String permissions) {
        try {
            Chmod.applyPermissions((File)file, (boolean)false, (String)permissions);
            log.debug("Restored permissions [{}] for file: {}", (Object)permissions, (Object)file.getAbsolutePath());
        }
        catch (IOException | InterruptedException e) {
            log.error("Error occurred while applying permissions to file: {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    @VisibleForTesting
    String getPermissions(File file) throws IllegalOperationException {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("ls");
        commandList.add("-l");
        commandList.add(file.getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commandList);
        String permissionOutput = null;
        Process process = null;
        try {
            process = processBuilder.start();
            InputStream outStream = process.getInputStream();
            this.outReader.initReader(outStream);
            InputStream errStream = process.getErrorStream();
            this.errReader.initReader(errStream);
            int processExitCode = process.waitFor();
            if (processExitCode != 0) {
                log.error("Process [" + String.valueOf(processBuilder.command()) + "] Exited with error code" + processExitCode);
                throw new IllegalOperationException("Process [" + String.valueOf(processBuilder.command()) + "] Exited with error code" + processExitCode);
            }
            log.debug("Process exited with code: " + processExitCode);
            permissionOutput = this.outReader.readLine().substring(1, 10);
            log.debug("Permissions output in ls style " + permissionOutput);
        }
        catch (IOException | InterruptedException e) {
            log.error("Error running Process [" + String.valueOf(processBuilder.command()) + "] - " + e.getMessage());
            throw new IllegalOperationException("Error running Process [" + String.valueOf(processBuilder.command()) + "] - " + e.getMessage());
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return LineEndingNormalizer.getPermissionsOctal(permissionOutput);
    }

    @VisibleForTesting
    static String getPermissionsOctal(String permissions) {
        if (permissions == null || permissions.length() != 9) {
            throw new IllegalArgumentException("Permissions should be a valid 9 character length string. " + permissions);
        }
        int owner = 0;
        int group = 0;
        int other = 0;
        for (int i = 0; i < 3; ++i) {
            owner += (permissions.charAt(i) == '-' ? 0 : 1) << 2 - i;
            group += (permissions.charAt(i + 3) == '-' ? 0 : 1) << 2 - i;
            other += (permissions.charAt(i + 6) == '-' ? 0 : 1) << 2 - i;
        }
        String permissionsOctal = "" + owner + group + other;
        log.debug("Permissions output in octal: {}", (Object)permissionsOctal);
        return permissionsOctal;
    }
}

