/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.TaskOutput;
import com.singularity.ee.agent.systemagent.api.exception.TaskExecutionException;
import com.singularity.ee.agent.systemagent.api.exception.TaskInstantiationException;
import com.singularity.ee.agent.systemagent.task.LineEndingNormalizer;
import com.singularity.ee.agent.systemagent.task.ProxyBufferedReader;
import com.singularity.ee.controller.api.exceptions.IllegalOperationException;
import com.singularity.ee.task.ExecTaskMetaData;
import com.singularity.ee.task.ExecTaskType;
import com.singularity.ee.util.io.PathResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecTask
implements ITask {
    private Logger logger = LogManager.getLogger((String)ExecTask.class.getName());
    private ExecTaskMetaData taskMetaData;
    private Map<String, String> taskArguments;
    private Process process;
    private ProcessBuilder processBuilder;
    private ProxyBufferedReader outReader;
    private ProxyBufferedReader errReader;
    private File workingDir;

    public ExecTask(ExecTaskMetaData taskData, Map<String, String> taskArguments) throws TaskInstantiationException {
        this(taskData, taskArguments, Collections.emptyMap());
    }

    ExecTask(ExecTaskMetaData taskData, Map<String, String> taskArguments, String workingDir) throws TaskInstantiationException {
        this(taskData, taskArguments, workingDir, Collections.emptyMap());
    }

    public ExecTask(ExecTaskMetaData taskData, Map<String, String> taskArguments, Map<String, String> environmentVars) throws TaskInstantiationException {
        this.taskMetaData = taskData;
        this.taskArguments = taskArguments;
        this.initProcess(environmentVars);
    }

    private ExecTask(ExecTaskMetaData taskData, Map<String, String> taskArguments, String workingDir, Map<String, String> environmentVars) throws TaskInstantiationException {
        this.taskMetaData = taskData;
        this.taskArguments = taskArguments;
        this.workingDir = new File(workingDir);
        this.initProcess(environmentVars);
    }

    private void initProcess(Map<String, String> env) throws TaskInstantiationException {
        String commandString;
        this.logger.info("Initializing process for exec task");
        this.outReader = new ProxyBufferedReader(null);
        this.errReader = new ProxyBufferedReader(null);
        if (this.taskMetaData.getExecTaskType().equals((Object)ExecTaskType.FILE)) {
            String filePath;
            if (this.workingDir == null) {
                this.workingDir = this.getWorkingDir();
            }
            if (this.taskMetaData.getFilePath() != null && this.taskMetaData.getFilePath().startsWith("$")) {
                filePath = this.taskArguments.get(this.taskMetaData.getFilePath().substring(1));
                this.logger.info("Resolved file path [" + this.taskMetaData.getFilePath() + "] -> [" + filePath + "]");
            } else {
                filePath = this.taskMetaData.getFilePath();
            }
            try {
                this.logger.info("Running executable script on disk [" + filePath + "]");
                commandString = PathResolver.getResolvedAndValidatedPathOnDisk((String)this.workingDir.getAbsolutePath(), (String)filePath);
            }
            catch (IOException e) {
                this.logger.error("Cannot resolve path to a script on disk [" + filePath + "], cannot instantiate task [" + this.taskMetaData.getName() + "]");
                throw new TaskInstantiationException("Cannot resolve path to a script on disk [" + filePath + "]");
            }
            this.logger.info("Executing script [" + commandString + "]");
            try {
                File executable = new File(commandString);
                LineEndingNormalizer LineEndingNormalizer2 = new LineEndingNormalizer();
                LineEndingNormalizer2.normalizeLineEndings(executable);
            }
            catch (IOException e) {
                this.logger.error("Cannot fix CRLF characters in executable script  [" + commandString + "]", (Throwable)e);
            }
            catch (IllegalOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.logger.info("Running system command [" + this.taskMetaData.getCommandName() + "]");
            commandString = this.taskMetaData.getCommandName();
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(commandString);
        if (this.taskMetaData.getMethodName() != null) {
            commandList.add(this.taskMetaData.getMethodName());
        }
        this.logger.debug("Adding exec task arguments");
        this.addArguments(commandList);
        this.logger.info("Initializing process builder with command list" + String.valueOf(commandList));
        this.processBuilder = new ProcessBuilder(commandList);
        this.processBuilder.directory(this.getWorkingDir());
        this.logger.info("Initializing process builder with enviornment variables " + env.toString());
        this.processBuilder.environment().putAll(env);
    }

    @Override
    public TaskOutput execute(Map<String, String> taskArguments, TaskExecutionContext taskContext) throws TaskExecutionException {
        try {
            this.logger.info("Running Executable Command [" + String.valueOf(this.processBuilder.command()) + "]");
            if (this.process != null) {
                this.process.destroy();
            }
            this.process = this.processBuilder.start();
            InputStream outStream = this.process.getInputStream();
            this.outReader.close();
            this.outReader.initReader(outStream);
            InputStream errStream = this.process.getErrorStream();
            this.errReader.close();
            this.errReader.initReader(errStream);
            this.checkProcessExitCode();
            return new TaskOutput("Task [" + this.taskMetaData.getName() + "] execution successful");
        }
        catch (IOException e) {
            this.logger.error("Error executing executable task", (Throwable)e);
            throw new TaskExecutionException("Error running Process [" + String.valueOf(this.processBuilder.command()) + "] -" + e.getMessage());
        }
    }

    private void checkProcessExitCode() throws TaskExecutionException {
        if (this.taskMetaData.isWaitForProcessExit()) {
            this.logger.debug("Will wait for process exit , before sending execution status.");
            try {
                int processExitCode = this.process.waitFor();
                if (processExitCode != 0) {
                    this.logger.error("Process [" + String.valueOf(this.processBuilder.command()) + "] Exited with error code" + processExitCode);
                    throw new TaskExecutionException("Process [" + String.valueOf(this.processBuilder.command()) + "] Exited with error code" + processExitCode);
                }
                this.logger.debug("Process exited with code: " + processExitCode);
            }
            catch (InterruptedException e) {
                this.logger.debug("Exception while waiting for process to exit", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private File getWorkingDir() throws TaskInstantiationException {
        String dir = this.taskMetaData.getWorkingDir();
        this.logger.trace("Process working dir specified" + dir);
        if (dir == null || dir.equals("")) {
            dir = this.taskMetaData.getTaskDir();
        } else {
            try {
                this.logger.debug("Resolving working directory  [" + this.taskMetaData.getWorkingDir() + "]");
                dir = PathResolver.getResolvedAndValidatedPathOnDisk((String)this.taskMetaData.getTaskDir(), (String)this.taskMetaData.getWorkingDir());
            }
            catch (IOException e) {
                this.logger.error("Cannot resolve working directory on disk[" + this.taskMetaData.getWorkingDir() + "], cannot instantiate task [" + this.taskMetaData.getName() + "]", (Throwable)e);
                throw new TaskInstantiationException("Cannot resolve working directory to a path on disk[" + this.taskMetaData.getWorkingDir() + "]");
            }
        }
        File workingDirFile = new File(dir);
        this.logger.trace("Process working dir resolved" + dir);
        return workingDirFile;
    }

    private void addArguments(List<String> commandList) {
        if (this.taskArguments != null && !this.taskArguments.isEmpty()) {
            this.logger.info("Adding task arguments: " + String.valueOf(this.taskArguments));
        } else {
            this.logger.info("No task arguments to add");
        }
        String argsPattern = this.taskMetaData.getArgsPattern();
        if (argsPattern != null) {
            this.logger.info("Args Pattern for task " + argsPattern);
        }
        if (argsPattern != null && !argsPattern.trim().equals("")) {
            LinkedHashMap<Object, String> orderedArgs = new LinkedHashMap<Object, String>();
            String[] argTokens = argsPattern.trim().split("\\s+");
            for (String argToken : argTokens) {
                orderedArgs.put(argToken, null);
            }
            for (Map.Entry entry : this.taskArguments.entrySet()) {
                String argName = "$" + (String)entry.getKey();
                String argValue = (String)entry.getValue();
                if (argValue == null || argValue.trim().equals("") || !orderedArgs.containsKey(argName)) continue;
                this.logger.info("Mapping arg token [" + argName + "] -> [" + argValue + "]");
                orderedArgs.put(argName, argValue);
            }
            for (String string : orderedArgs.values()) {
                if (string == null) {
                    commandList.add("");
                    continue;
                }
                commandList.add(string);
            }
        } else {
            this.logger.debug("No pattern specified ");
            for (Map.Entry<String, String> argument : this.taskArguments.entrySet()) {
                commandList.add(argument.getValue());
            }
        }
    }

    public BufferedReader getOutputReader() {
        return this.outReader;
    }

    public BufferedReader getErrorReader() {
        return this.errReader;
    }

    public String getName() {
        return this.taskMetaData.getName();
    }

    public String getDescription() {
        return this.taskMetaData.getDescription();
    }

    @Override
    public void stop() {
        this.logger.info("Forcing stop for Executable Command [" + String.valueOf(this.processBuilder.command()) + "]");
        try {
            if (this.process != null) {
                this.process.destroy();
            } else {
                this.logger.info("No process to stop");
            }
        }
        catch (Exception e) {
            this.logger.info("Error while Forcing stop for Executable Command [" + String.valueOf(this.processBuilder.command()) + "]", (Throwable)e);
        }
    }
}

