/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.controller.api.constants.TaskExecutionStatus;
import com.singularity.ee.rest.controller.request.TaskExecutionStatusRequest;
import com.singularity.ee.rest.controller.request.TaskOutputCaptureRequest;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.log4j.Log4JLogger;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControllerUtil {
    public static final String INSTANCE_ID = "<instance-id>";
    public static final String TASK_EXECUTION_ID = "<task-execution-id>";
    private String machineInstanceID;
    private String controllerHost;
    private int controllerPort;
    private static Logger logger = LogManager.getLogger((String)ControllerUtil.class.getName());

    public ControllerUtil(String controllerHost, int controllerPort, String machineID) {
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.machineInstanceID = machineID;
    }

    public void sendExecutionStatus(String taskID, String output, TaskExecutionStatus status, boolean taskStarted, Map<String, String> outputProperties) {
        logger.info("Sending task status to controller [TaskID: " + taskID + "] -" + status.toString());
        TaskExecutionStatusRequest taskExecutionStatusRequest = new TaskExecutionStatusRequest(this.controllerHost, this.controllerPort, this.machineInstanceID, taskID, new Log4JLogger(logger));
        if (output != null) {
            taskExecutionStatusRequest.setOutput(output);
        }
        if (taskStarted) {
            taskExecutionStatusRequest.setTaskStarted();
        } else {
            taskExecutionStatusRequest.setTaskCouldNotStart();
        }
        if (status == TaskExecutionStatus.SUCCESSFUL) {
            taskExecutionStatusRequest.setOutputProperties(outputProperties);
        }
        taskExecutionStatusRequest.setStatus(status);
        taskExecutionStatusRequest.sendRequest();
    }

    public void sendStdOutStreamDataForTask(String taskID, String output) {
        logger.info("Sending stdout to controller [TaskID: " + taskID + "] -\n" + output);
        TaskOutputCaptureRequest outputRequest = new TaskOutputCaptureRequest(this.controllerHost, this.controllerPort, this.machineInstanceID, taskID, false, new Log4JLogger(logger));
        outputRequest.addOutStream(output);
        outputRequest.setTimeStamp(ClockUtils.getCurrentTime());
        outputRequest.sendRequest();
    }

    public void sendStdErrStreamDataForTask(String taskID, String output) {
        logger.info("Sending stderr to controller [TaskID: " + taskID + "] -\n" + output);
        TaskOutputCaptureRequest outputRequest = new TaskOutputCaptureRequest(this.controllerHost, this.controllerPort, this.machineInstanceID, taskID, true, new Log4JLogger(logger));
        outputRequest.addErrStream(output);
        outputRequest.setTimeStamp(ClockUtils.getCurrentTime());
        outputRequest.sendRequest();
    }
}

