/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.runbook.localscript.requests;

import com.singularity.ee.agent.systemagent.components.monitormanager.AgentMonitorManager;
import com.singularity.ee.agent.systemagent.runbook.localscript.RunLocalScriptResponse;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.constants.EventCorrelationType;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.events.MachineEventData;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.string.StringOperations;
import java.util.HashMap;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunLocalScriptEventHandler {
    private static final Logger logger = LogManager.getLogger((String)("com.singularity.ops.runbook." + RunLocalScriptEventHandler.class.getName()));
    private final String machineId;
    private final AgentMonitorManager agentMonitorManager;

    public RunLocalScriptEventHandler(String machineId, AgentMonitorManager agentMonitorManager) {
        this.agentMonitorManager = agentMonitorManager;
        this.machineId = machineId;
    }

    public void logAndSendFailureResponse(String message, RunLocalScriptResponse response) {
        this.logAndSendResponse(message, null, response, true);
    }

    public void logAndSendFailureResponse(String message, Throwable t, RunLocalScriptResponse scriptResponse) {
        this.logAndSendResponse(message, t, scriptResponse, true);
    }

    public void logAndSendSuccessResponse(String message, RunLocalScriptResponse scriptResponse) {
        this.logAndSendResponse(message, null, scriptResponse, false);
    }

    private void logAndSendResponse(String message, Throwable t, RunLocalScriptResponse response, boolean error) {
        if (error) {
            logger.error(message, t);
        } else {
            logger.info(message);
        }
        Object eventSummary = message;
        MachineEventData machineEventData = new MachineEventData();
        if (error) {
            machineEventData.setType(EventType.RUN_LOCAL_SCRIPT_ACTION_FAILED);
        } else {
            machineEventData.setType(EventType.RUN_LOCAL_SCRIPT_ACTION_END);
        }
        machineEventData.setMachineID(StringOperations.safeParseLong((String)this.machineId));
        machineEventData.setGuid(UUID.randomUUID().toString());
        machineEventData.setTimestamp(ClockUtils.getCurrentTime());
        HashMap<String, String> eventDetails = new HashMap<String, String>();
        if (response != null) {
            String operationIdString = String.valueOf(response.getOperationId());
            String eventGuidString = response.getEventGuid();
            String rsdGuidString = response.getRsdGuid();
            long eventGuid = StringOperations.safeParseLong((String)response.getEventGuid());
            String appComponentNodeIdString = String.valueOf(response.getApplicationComponentNodeId());
            String policyId = response.getPolicyId();
            if (response.hasExecutionErrorOccurred()) {
                Throwable throwable;
                String errorMessage = response.getErrorMessage();
                if (errorMessage != null) {
                    eventSummary = errorMessage;
                }
                if ((throwable = response.getThrowable()) != null) {
                    eventSummary = (String)eventSummary + " - " + throwable.getLocalizedMessage();
                }
            }
            EntityDefinition triggeredEntity = new EntityDefinition();
            triggeredEntity.setEntityType(EntityType.EVENT);
            triggeredEntity.setEntityId(eventGuid);
            machineEventData.setTriggeredEntity(triggeredEntity);
            if (eventGuidString != null) {
                machineEventData.addCorrelationID(eventGuidString, EventCorrelationType.PARENT_EVENT_ID);
            }
            if (rsdGuidString != null) {
                machineEventData.addCorrelationID(rsdGuidString, EventCorrelationType.PARENT_RSD_ID);
            }
            machineEventData.addCorrelationID(response.getActionGuid(), EventCorrelationType.ACTION_EXECUTION_GUID);
            machineEventData.addCorrelationID(operationIdString, EventCorrelationType.OPERATION_ID);
            machineEventData.addCorrelationID(this.machineId, EventCorrelationType.MACHINE_ID);
            machineEventData.addCorrelationID(appComponentNodeIdString, EventCorrelationType.NODE_ID);
            machineEventData.addCorrelationID(policyId, EventCorrelationType.POLICY_ID);
            eventDetails.put("operation-id", operationIdString);
            eventDetails.put("action-guid", response.getActionGuid());
            eventDetails.put("event-guid", eventGuidString);
            eventDetails.put("rsd-guid", rsdGuidString);
            eventDetails.put("node-id", appComponentNodeIdString);
            eventDetails.put("policy-id", policyId);
            eventDetails.put("exit-code", String.valueOf(response.getExitCode()));
            StringBuilder firstNLines = response.getFirstNLines();
            String firstNLinesValue = firstNLines == null ? "" : firstNLines.toString();
            eventDetails.put("script-output-header", firstNLinesValue);
            eventDetails.put("log-paths-not-found", StringOperations.convertToCommaSeparateString((String[])response.getLogFilesNotFound()));
        }
        machineEventData.setSummary((String)eventSummary);
        machineEventData.setEventDetails(eventDetails);
        if (this.agentMonitorManager != null) {
            this.agentMonitorManager.addMachineAgentEvent(machineEventData);
        }
    }
}

