/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.runbook.localscript.executor;

import com.google.common.base.Optional;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessOutputCallback
implements Callable<StringBuilder> {
    private static Logger logger = LogManager.getLogger(ProcessOutputCallback.class);
    static final int DEFAULT_NUM_HEADER_LINES_TO_CAPTURE = 0;
    static final int DEFAULT_NUM_HEADER_BYTES_TO_CAPTURE = 0;
    static final int MAX_HEADER_BYTES_TO_CAPTURE_IN_BYTES = 0xA00000;
    private static final int CHAR_SIZE_IN_BYTES = 2;
    private InputStream is;
    private int firstNLinesToCapture;
    private int firstNBytesToCapture;
    private StringBuilder firstNLines;
    private String outputFilePath;
    private File outputFile;
    private boolean outputToFile;
    private boolean outputToConsole;

    private ProcessOutputCallback() {
    }

    ProcessOutputCallback(InputStream is, boolean outputToConsole) {
        this(is, 0, 0, outputToConsole, false, null);
    }

    ProcessOutputCallback(InputStream is, boolean outputToConsole, boolean outputToFile, String outputFilePath) {
        this(is, 0, 0, outputToConsole, outputToFile, outputFilePath);
    }

    ProcessOutputCallback(InputStream is, int firstNLinesToCapture, int firstNBytesToCapture, boolean outputToConsole, boolean outputToFile, String outputFilePath) {
        this.is = is;
        this.outputFilePath = outputFilePath;
        this.outputToConsole = outputToConsole;
        this.outputToFile = outputToFile;
        this.firstNLinesToCapture = firstNLinesToCapture;
        this.firstNBytesToCapture = firstNBytesToCapture;
        this.firstNLines = new StringBuilder();
        if (outputToFile) {
            this.initializeOutputFile();
        }
    }

    StringBuilder getFirstNLines() {
        return this.firstNLines;
    }

    private void initializeOutputFile() {
        try {
            this.outputFile = new File(this.outputFilePath);
            if (!this.outputFile.createNewFile()) {
                logger.warn(String.format("Output file=%s already exists", this.outputFilePath));
            }
        }
        catch (Exception t) {
            logger.error("Failed to create output file: " + this.outputFilePath, (Throwable)t);
        }
    }

    @Override
    public StringBuilder call() throws IOException {
        if (this.outputToFile) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile));){
                StringBuilder stringBuilder = this.capture((Optional<BufferedWriter>)Optional.of((Object)writer));
                return stringBuilder;
            }
        }
        return this.capture((Optional<BufferedWriter>)Optional.absent());
    }

    private StringBuilder capture(Optional<BufferedWriter> writerOpt) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));){
            String line;
            int lineCount = 0;
            int byteCount = 0;
            String lineSeparator = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                if (lineCount < this.firstNLinesToCapture) {
                    int lineLengthInBytes = line.length() * 2;
                    int byteCountWithNextLine = byteCount + lineLengthInBytes;
                    if (byteCountWithNextLine < this.firstNBytesToCapture) {
                        this.firstNLines.append(line).append(lineSeparator);
                        byteCount += lineLengthInBytes;
                        ++lineCount;
                    } else {
                        int charsRemaining = (byteCountWithNextLine - this.firstNBytesToCapture) / 2;
                        this.firstNLines.append(line.substring(0, charsRemaining));
                    }
                } else if (!this.outputToConsole && !this.outputToFile) {
                    break;
                }
                String lineOutput = line + lineSeparator;
                if (this.outputToConsole) {
                    System.out.print(lineOutput);
                }
                if (!writerOpt.isPresent()) continue;
                ((BufferedWriter)writerOpt.get()).write(lineOutput);
            }
        }
        return this.firstNLines;
    }
}

