/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.runbook.localscript;

import com.singularity.ee.agent.systemagent.components.monitormanager.AgentMonitorManager;
import com.singularity.ee.agent.systemagent.runbook.localscript.requests.RunLocalScriptRequestHandler;
import com.singularity.ee.config.IConfigurationListener;
import com.singularity.ee.config.IConfigurationRequest;
import com.singularity.ee.controller.api.constants.AppAgentOperationStatus;
import com.singularity.ee.controller.api.dto.SystemAgentOperation;
import com.singularity.ee.controller.api.dto.runbook.RunLocalScriptOperation;
import com.singularity.ee.rest.controller.request.SystemAgentPollingConfigurationRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunbookHandler
implements IConfigurationListener {
    private static final Logger logger = LogManager.getLogger((String)("com.singularity.ops.runbook." + RunbookHandler.class.getSimpleName()));
    private volatile boolean isOperationExecutionDisabled;
    private final Map<Long, AppAgentOperationStatus> operationStatusMap = new HashMap<Long, AppAgentOperationStatus>();
    private final RunLocalScriptRequestHandler runLocalScriptHandler;

    public RunbookHandler(String host, int port, String machineId, String installDir, AgentMonitorManager agentMonitorManager, boolean isOperationsDisabled) {
        this.runLocalScriptHandler = new RunLocalScriptRequestHandler(host, port, machineId, installDir, agentMonitorManager);
        this.switchOperationExecutionDisabled(isOperationsDisabled);
    }

    public void switchOperationExecutionDisabled(boolean isDisabled) {
        logger.info("Runbook Operation Execution is : [" + (isDisabled ? "disabled" : "enabled") + "].");
        this.isOperationExecutionDisabled = isDisabled;
    }

    public boolean getIsOperationExecutionDisabled() {
        return this.isOperationExecutionDisabled;
    }

    public void configurationChanged(IConfigurationRequest configRequest) {
        List operationList = ((SystemAgentPollingConfigurationRequest)configRequest).getSystemAgentOperations();
        for (SystemAgentOperation operation : operationList) {
            if (operation == null) continue;
            logger.debug("Received Runbook operation id=" + operation.getId() + ", name=" + operation.getOperationName());
            AppAgentOperationStatus status = this.operationStatusMap.get(operation.getId());
            if (status != null) continue;
            this.addOperation(operation);
        }
    }

    public void setLastUpdatedConfiguration(IConfigurationRequest configRequest) {
        HashMap<Long, AppAgentOperationStatus> statusUpdates = new HashMap<Long, AppAgentOperationStatus>();
        statusUpdates.putAll(this.operationStatusMap);
        Iterator<Map.Entry<Long, AppAgentOperationStatus>> iterator = this.operationStatusMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, AppAgentOperationStatus> entry = iterator.next();
            AppAgentOperationStatus status = entry.getValue();
            if (status != AppAgentOperationStatus.SUCCESSFUL && status != AppAgentOperationStatus.FAILED) continue;
            iterator.remove();
        }
        logger.debug("Sending operationStatusMap to Controller: " + String.valueOf(statusUpdates));
        ((SystemAgentPollingConfigurationRequest)configRequest).setSystemAgentOperationStatus(statusUpdates);
    }

    private void addOperation(SystemAgentOperation operation) {
        if (this.isOperationExecutionDisabled) {
            logger.warn("Ignoring Runbook operation " + String.valueOf(operation) + " while operation execution is disabled");
        } else {
            logger.debug("Processing Runbook operation " + String.valueOf(operation));
            this.operationStatusMap.put(operation.getId(), AppAgentOperationStatus.IN_PROGRESS);
            this.runLocalScriptHandler.handleOperation((RunLocalScriptOperation)operation, this.operationStatusMap);
        }
    }
}

