/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.runbook.localscript;

import com.singularity.ee.agent.runbook.RunLocalScriptConfig;
import com.singularity.ee.agent.systemagent.runbook.localscript.RunLocalScriptActionConstants;
import com.singularity.ee.agent.systemagent.runbook.localscript.RunLocalScriptResponse;
import com.singularity.ee.agent.systemagent.runbook.localscript.executor.ScriptExecutor;
import com.singularity.ee.agent.systemagent.runbook.localscript.executor.ScriptExecutorBuilder;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.runbook.RunLocalScriptOperation;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logcapture.LogCompressor;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunLocalScriptActionHandler
implements RunLocalScriptActionConstants {
    private static final Logger logger = LogManager.getLogger((String)"com.singularity.ops.runbook.RunLocalScriptActionHandler");
    private static String fileSeparator;
    private static String workingDirectoryPath;

    private RunLocalScriptActionHandler() {
    }

    public static RunLocalScriptResponse handleOperation(RunLocalScriptOperation operation, String installDir) {
        Map<String, String> configKeyVsValue = RunLocalScriptActionHandler.convertNVPArrayToMap(operation.getProperties());
        Map<String, String> environment = RunLocalScriptActionHandler.getEnvironmentProperties(operation);
        Map<String, String> customEnvProps = RunLocalScriptActionHandler.convertNVPArrayToMap(operation.getCustomEnvironmentProperties());
        environment.putAll(customEnvProps);
        ScriptExecutor scriptExecutor = RunLocalScriptActionHandler.prepareScriptExecutor(configKeyVsValue, environment, installDir);
        LogCompressor logCompressor = RunLocalScriptActionHandler.prepareLogCompressor(RunLocalScriptActionHandler.getZipFileName(scriptExecutor));
        scriptExecutor.execute();
        scriptExecutor.blockUntilScriptCompletes();
        List<String> logPathsToCollect = RunLocalScriptActionHandler.getLogPathsToCollect(configKeyVsValue);
        List<String> scriptOutput = scriptExecutor.getOutputFilePaths();
        if (scriptOutput != null) {
            logPathsToCollect.addAll(scriptOutput);
        }
        List filesNotFound = logCompressor.archiveFiles(logPathsToCollect);
        logCompressor.includeFileStatsAndFinalizeArchive();
        RunLocalScriptActionHandler.cleanupScriptOutput(scriptOutput);
        RunLocalScriptResponse response = new RunLocalScriptResponse();
        String actionGUID = operation.getActionGUID();
        if (actionGUID == null) {
            logger.warn("Action GUID was not set.");
        }
        String eventGuid = operation.getEventGUID();
        String rsdGuid = operation.getRsdGUID();
        if (eventGuid == null && rsdGuid == null) {
            logger.warn("Event/RSD GUID not set for " + String.valueOf(operation));
        }
        response.setActionGuid(actionGUID);
        response.setEventGuid(eventGuid);
        response.setRsdGuid(rsdGuid);
        response.setExitCode(scriptExecutor.getExitCode());
        response.setZipFilePath(logCompressor.getZipFilePath());
        response.setExecutionErrorOccurred(scriptExecutor.hasErrorOccurredDuringExecution());
        response.setErrorMessage(scriptExecutor.getErrorMessage());
        response.setThrowable(scriptExecutor.getThrowable());
        response.setFirstNLines(scriptExecutor.getFirstNLines());
        response.setOperationId(operation.getId());
        response.setApplicationComponentNodeId(operation.getApplicationComponentNodeId());
        response.setPolicyId(configKeyVsValue.get("policy-id"));
        if (filesNotFound != null) {
            response.setLogFilesNotFound(filesNotFound.toArray(new String[filesNotFound.size()]));
        }
        return response;
    }

    private static Map<String, String> getEnvironmentProperties(RunLocalScriptOperation operation) {
        HashMap<String, String> envNameVsValue = new HashMap<String, String>();
        for (NameValuePair nvp : operation.getProperties()) {
            String potentialEnvVarName = nvp.getName();
            if (!potentialEnvVarName.startsWith("ENV_")) continue;
            String environmentVarName = potentialEnvVarName.replace("ENV_", "");
            envNameVsValue.put(environmentVarName, nvp.getValue());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RLS operation environment: " + String.valueOf(envNameVsValue));
        }
        envNameVsValue.putAll(NameValuePair.convertNameValuePairsToMap((NameValuePair[])operation.getEnvironment()));
        String systemPropertiesCsv = NameValuePair.convertNVPToCSV((NameValuePair[])operation.getSystemProperties());
        envNameVsValue.put("ENV_SYSTEM_PROPERTIES", systemPropertiesCsv);
        NameValuePair[] startupOptions = operation.getStartupOptions();
        String startupOptionCsv = "";
        if (startupOptions != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < startupOptions.length; ++i) {
                NameValuePair option = startupOptions[i];
                String name = option.getName();
                sb.append(name);
                if (i == startupOptions.length - 1) continue;
                sb.append(",");
            }
            startupOptionCsv = sb.toString();
        }
        envNameVsValue.put("ENV_STARTUP_OPTIONS", startupOptionCsv);
        return envNameVsValue;
    }

    private static void cleanupScriptOutput(List<String> scriptOutput) {
        if (scriptOutput == null) {
            return;
        }
        for (String scriptOutputFile : scriptOutput) {
            File file = new File(scriptOutputFile);
            if (file.delete()) continue;
            logger.error("Failed to delete script output file: " + scriptOutputFile);
        }
    }

    private static String getZipFileName(ScriptExecutor scriptExecutor) {
        String scriptName = new File(scriptExecutor.getScriptPath()).getName();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd__HH_mm_ss");
        String dateSuffix = formatter.format(new Date());
        return String.format("%s-%s.zip", scriptName, dateSuffix);
    }

    private static List<String> getLogPathsToCollect(Map<String, String> configKeyVsValue) {
        String logPathsToCollectCSV = RunLocalScriptActionHandler.getConfigProperty(RunLocalScriptConfig.LOG_PATHS_TO_CAPTURE, configKeyVsValue);
        if (logPathsToCollectCSV == null) {
            return new ArrayList<String>();
        }
        List logPaths = StringOperations.parseCommaSeparatedString((String)logPathsToCollectCSV);
        ArrayList<String> resolvedLogPaths = new ArrayList<String>();
        Iterator iterator = logPaths.iterator();
        while (iterator.hasNext()) {
            String logPath;
            String toAdd = logPath = (String)iterator.next();
            if (logPath.contains("${machine.agent.directory}")) {
                toAdd = logPath.replace("${machine.agent.directory}", RunLocalScriptActionHandler.getWorkingDirectoryPath());
            }
            resolvedLogPaths.add(toAdd);
        }
        return resolvedLogPaths;
    }

    private static LogCompressor prepareLogCompressor(String zipFileName) {
        String zipFilePath = RunLocalScriptActionHandler.getJavaTempDir() + RunLocalScriptActionHandler.getFileSep() + zipFileName;
        return new LogCompressor(zipFilePath, new StringBuilder(), (ILogger)new Log4JLogger(logger));
    }

    private static synchronized String getFileSep() {
        if (fileSeparator == null) {
            fileSeparator = System.getProperty("file.separator");
        }
        return fileSeparator;
    }

    private static synchronized String getWorkingDirectoryPath() {
        if (workingDirectoryPath == null) {
            workingDirectoryPath = System.getProperty("user.dir");
        }
        return workingDirectoryPath;
    }

    public static synchronized void setWorkingDirectoryPathForUnitTests(String workingDirectoryPathOverride) {
        workingDirectoryPath = workingDirectoryPathOverride;
    }

    private static String getJavaTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ScriptExecutor prepareScriptExecutor(Map<String, String> configKeyVsValue, Map<String, String> environment, String installDir) {
        String timeoutInMinString;
        String configuredScriptPath;
        ScriptExecutorBuilder builder = new ScriptExecutorBuilder();
        if (installDir != null) {
            builder.workingDirectory(installDir);
            builder.shouldUseWorkingDirectoryAsNameQualifier(true);
            Class<RunLocalScriptActionHandler> clazz = RunLocalScriptActionHandler.class;
            // MONITORENTER : com.singularity.ee.agent.systemagent.runbook.localscript.RunLocalScriptActionHandler.class
            workingDirectoryPath = installDir;
            // MONITOREXIT : clazz
        }
        String scriptPath = configuredScriptPath = RunLocalScriptActionHandler.getConfigProperty(RunLocalScriptConfig.SCRIPT_PATH, configKeyVsValue);
        if (configuredScriptPath != null && configuredScriptPath.contains("${machine.agent.directory}")) {
            scriptPath = configuredScriptPath.replace("${machine.agent.directory}", RunLocalScriptActionHandler.getWorkingDirectoryPath());
        }
        builder.scriptPath(scriptPath);
        String scriptArgsCSV = RunLocalScriptActionHandler.getConfigProperty(RunLocalScriptConfig.SCRIPT_ARGS, configKeyVsValue);
        if (scriptArgsCSV != null) {
            String[] scriptArgs = StringOperations.parseCommaSeparatedStringToArray((String)scriptArgsCSV);
            builder.scriptArgs(scriptArgs);
        }
        if ((timeoutInMinString = RunLocalScriptActionHandler.getConfigProperty(RunLocalScriptConfig.TIMEOUT_IN_MINUTES, configKeyVsValue)) != null) {
            int timeoutInMin = Integer.parseInt(timeoutInMinString);
            builder.timeout(timeoutInMin);
            builder.timeoutUnit(TimeUnit.MINUTES);
        }
        builder.mergeStdErr(true);
        builder.logToFile(true);
        builder.environment(environment);
        return builder.getScriptExecutor();
    }

    private static String getConfigProperty(RunLocalScriptConfig config, Map<String, String> properties) {
        String value = properties.get(config.getKey());
        if (value == null && config.isRequired()) {
            logger.error(String.format("Required property '%s' not found", config.getKey()));
            return null;
        }
        return value;
    }

    private static Map<String, String> convertNVPArrayToMap(NameValuePair[] properties) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (properties == null) {
            return result;
        }
        for (NameValuePair nvp : properties) {
            result.put(nvp.getName(), nvp.getValue());
        }
        return result;
    }
}

