/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.handler;

import com.singularity.ee.agent.configuration.identity.AgentIdentity;
import com.singularity.ee.agent.configuration.identity.IIdentityManager;
import com.singularity.ee.agent.configuration.impl.ConfigException;
import com.singularity.ee.agent.systemagent.components.AAgentComponent;
import com.singularity.ee.agent.systemagent.components.controlchannel.AgentControlChannel;
import com.singularity.ee.agent.systemagent.components.monitormanager.AgentMonitorManager;
import com.singularity.ee.agent.systemagent.handler.HandlerActivationException;
import com.singularity.ee.agent.systemagent.handler.HandlerException;
import com.singularity.ee.agent.systemagent.handler.IRequestHandler;
import com.singularity.ee.agent.systemagent.handler.RequestHandlerContext;
import com.singularity.ee.rest.RESTResponse;
import com.singularity.ee.rest.agent.request.AgentInitRequest;
import com.singularity.ee.util.httpclient.HttpOperation;
import com.singularity.ee.util.httpclient.TrustManagerShouldDoDefaultValidation;
import com.singularity.ee.util.javaspecific.mutable.ADBoolean;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RequestHandlerServlet
extends HttpServlet {
    private static final Logger logger = LogManager.getLogger((String)RequestHandlerServlet.class.getName());
    private static final ILogger iLogger = new Log4JLogger(logger);
    private final List<AAgentComponent> agentComponents = new ArrayList<AAgentComponent>(4);
    private boolean isActive;
    private final RequestHandlerContext handlerContext;

    public RequestHandlerServlet(RequestHandlerContext handlerContext) {
        this.handlerContext = handlerContext;
    }

    void handleInit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        boolean reInit = this.isActive;
        if (reInit) {
            this.shutdownHandlers();
        }
        try {
            AgentInitRequest initRequest = new AgentInitRequest(httpServletRequest, (ILogger)new Log4JLogger(logger));
            AgentIdentity instanceInfo = this.readSystemAgentIdentity(initRequest);
            this.handlerContext.setAttribute("Agent-Identity", instanceInfo);
            IIdentityManager identityManager = (IIdentityManager)this.handlerContext.getAttribute("Config-Manager");
            identityManager.saveAgentIdentity(instanceInfo);
            this.activate(instanceInfo);
            if (reInit) {
                logger.info("Re-started System Agent");
            } else {
                logger.info("Activated System Agent servlets");
            }
            this.sendIPInformation(httpServletResponse);
        }
        catch (HandlerActivationException e) {
            RESTResponse.sendFailureResponse((HttpServletResponse)httpServletResponse, (String)("Could not Initialize System Agent" + e.getMessage()), (ILogger)iLogger);
        }
        catch (ConfigException e) {
            RESTResponse.sendFailureResponse((HttpServletResponse)httpServletResponse, (String)("Could not save system agent identity information" + e.getMessage()), (ILogger)iLogger);
        }
        catch (Exception e) {
            logger.error("Error initializing system agent", (Throwable)e);
            RESTResponse.sendFailureResponse((HttpServletResponse)httpServletResponse, (String)("Could not Initialize System Agent" + e.getMessage()), (ILogger)iLogger);
        }
    }

    private AgentIdentity readSystemAgentIdentity(AgentInitRequest initReq) {
        return new AgentIdentity(initReq.getControllerHost(), initReq.getInstanceID(), Integer.parseInt(initReq.getControllerPort()), initReq.getUserName(), initReq.getPassword(), new ADBoolean(false), TrustManagerShouldDoDefaultValidation.UNSPECIFIED);
    }

    private void sendIPInformation(HttpServletResponse response) {
        AgentInitRequest ipResponse = new AgentInitRequest((ILogger)new Log4JLogger(logger));
        try {
            ipResponse.setBoundIPs();
            ipResponse.writeToResponse(response);
        }
        catch (IOException e) {
            logger.warn("Could not send IP information to controller", (Throwable)e);
        }
    }

    void activate(AgentIdentity agentIdentity) throws HandlerActivationException {
        this.setupHandlers(agentIdentity.getMachineInstanceID(), agentIdentity.getControllerHost(), agentIdentity.getControllerPort());
        this.isActive = true;
    }

    private void setupHandlers(String machineInstanceID, String controllerHost, int controllerPort) throws HandlerActivationException {
        try {
            this.agentComponents.add(new AgentControlChannel(machineInstanceID, controllerHost, controllerPort, this.handlerContext));
            this.agentComponents.add(new AgentMonitorManager(machineInstanceID, controllerHost, controllerPort, this.handlerContext, null, Collections.emptyList(), null));
        }
        catch (MalformedURLException e) {
            logger.error("Error setting up agent Components", (Throwable)e);
            throw new HandlerActivationException(e);
        }
        catch (Exception e) {
            logger.error("Error setting up agent components", (Throwable)e);
            throw new HandlerActivationException(e);
        }
    }

    private void shutdownHandlers() {
        logger.info("Shutting Down All Agent Components");
        for (AAgentComponent agentComponent : this.agentComponents) {
            agentComponent.shutdown();
        }
    }

    public void shutdown() {
        this.shutdownHandlers();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isActive && !request.getRequestURI().equals("/systemagent/identity")) {
            RESTResponse.sendFailureResponse((HttpServletResponse)response, (String)"System Agent has not been activated to handle requests", (ILogger)iLogger);
            return;
        }
        if (request.getRequestURI().equals("/systemagent/identity")) {
            this.handleInit(request, response);
        } else {
            this.delegateToHandler(request, HttpOperation.POST, response);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isActive) {
            RESTResponse.sendFailureResponse((HttpServletResponse)response, (String)"System Agent has not been activated to handle requests", (ILogger)iLogger);
        } else {
            this.delegateToHandler(request, HttpOperation.PUT, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isActive && request.getRequestURI().equals("/systemagent/heartbeatmanager")) {
            RESTResponse.sendSuccessResponse((HttpServletResponse)response, (String)"System Agent active", (ILogger)iLogger);
            return;
        }
        if (!this.isActive) {
            RESTResponse.sendFailureResponse((HttpServletResponse)response, (String)"Agent Servlets have not been activated to handle requests", (ILogger)iLogger);
        } else {
            this.delegateToHandler(request, HttpOperation.GET, response);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isActive) {
            RESTResponse.sendFailureResponse((HttpServletResponse)response, (String)"Agent Servlets have not been activated to handle requests", (ILogger)iLogger);
        } else {
            this.delegateToHandler(request, HttpOperation.DELETE, response);
        }
    }

    private void delegateToHandler(HttpServletRequest request, HttpOperation operation, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        IRequestHandler handler = this.getAgentRequestHandler(uri);
        try {
            handler.handleRequest(uri, request, operation, response);
        }
        catch (HandlerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private IRequestHandler getAgentRequestHandler(String uri) throws ServletException {
        for (AAgentComponent agentComponent : this.agentComponents) {
            if (!uri.startsWith(agentComponent.getContextForRequests())) continue;
            logger.debug("Returning Request Handler [" + String.valueOf(agentComponent) + "] for URI [" + uri + "]");
            return agentComponent;
        }
        throw new ServletException("Invalid URI: " + uri);
    }
}

