/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricListener;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricIdentifier;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.SystemMetricAggregatorFactory;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import lombok.Generated;
import lombok.NonNull;

public class SystemMetricAggregatorProxy
implements IMetricAggregator {
    @NonNull
    private final AgentRawMetricIdentifier metricIdentifier;
    @NonNull
    private final SystemMetricAggregatorFactory aggregatorFactory;

    public static IMetricAggregator getAggregatorFromProxy(IMetricAggregator aggregator) {
        return aggregator instanceof SystemMetricAggregatorProxy ? ((SystemMetricAggregatorProxy)aggregator).fetchAggregator() : aggregator;
    }

    public RawMetricValue aggregate() {
        return this.fetchAggregator().aggregate();
    }

    public boolean isChanged() {
        return this.fetchAggregator().isChanged();
    }

    public void report(long value, boolean backgroundOK) {
        this.fetchAggregator().report(value, backgroundOK);
    }

    public void reportBypassBackgroundProcessing(long value) {
        this.fetchAggregator().reportBypassBackgroundProcessing(value);
    }

    public long getLastAggregatedValue() {
        return this.fetchAggregator().getLastAggregatedValue();
    }

    public void resetLastAggregateValue() {
        this.fetchAggregator().resetLastAggregateValue();
    }

    public void flushMetricsForCurrentThread() {
        this.fetchAggregator().flushMetricsForCurrentThread();
    }

    public void setMetricListener(IMetricListener metricListener) {
        this.fetchAggregator().setMetricListener(metricListener);
    }

    public void report(long value) {
        this.fetchAggregator().report(value);
    }

    public void report(long value, long count, long min, long max) {
        this.fetchAggregator().report(value, count, min, max);
    }

    public MetricAggregatorType getType() {
        return this.fetchAggregator().getType();
    }

    private IMetricAggregator fetchAggregator() {
        IMetricAggregator aggregator;
        try {
            aggregator = this.aggregatorFactory.safeGetAggregatorNoProxy(this.metricIdentifier);
        }
        catch (MetricOverflowException | MetricReporterTypeMismatchException e) {
            throw new RuntimeException("Unable to read cache: " + e.getMessage(), e);
        }
        return aggregator;
    }

    @Generated
    SystemMetricAggregatorProxy(@NonNull AgentRawMetricIdentifier metricIdentifier, @NonNull SystemMetricAggregatorFactory aggregatorFactory) {
        if (metricIdentifier == null) {
            throw new NullPointerException("metricIdentifier is marked non-null but is null");
        }
        if (aggregatorFactory == null) {
            throw new NullPointerException("aggregatorFactory is marked non-null but is null");
        }
        this.metricIdentifier = metricIdentifier;
        this.aggregatorFactory = aggregatorFactory;
    }
}

