/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.appdynamics.agent.sim.metrics.SimplePercentileMetricAggregator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.DummyAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricData;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricIdentifier;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.SystemMetricAggregatorProxy;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.RefreshFailedException;
import lombok.NonNull;

public class SystemMetricAggregatorFactory
extends AMetricAggregatorFactory {
    private final Cache<AgentRawMetricIdentifier, IMetricAggregator> idToAggregatorCache;
    private final ConcurrentMap<IMetricAggregator, AgentRawMetricIdentifier> aggregatorToIdMap;
    private final Set<IMetricAggregator> unregisteredAggregatorSet;
    @VisibleForTesting
    static final long DEFAULT_EXPIRATION_TIME_SECONDS = TimeUnit.MINUTES.toSeconds(2L);

    private static <K, V> Cache<K, V> expiringCache(Ticker ticker) {
        return CacheBuilder.newBuilder().expireAfterAccess(SystemMetricAggregatorFactory.expirationTimeSeconds(), TimeUnit.SECONDS).ticker(ticker).build();
    }

    private static long expirationTimeSeconds() {
        return SystemUtilsTranslateable.getLongProperty((String)"appdynamics.machine.agent.aggregatorExpiration.interval", (long)DEFAULT_EXPIRATION_TIME_SECONDS);
    }

    public SystemMetricAggregatorFactory(ILogger logger, IEventGenerationService egs, int maxMetricsAllowed) {
        this(logger, egs, maxMetricsAllowed, Ticker.systemTicker());
    }

    SystemMetricAggregatorFactory(ILogger logger, IEventGenerationService egs, int maxMetricsAllowed, @NonNull Ticker ticker) {
        super(logger, egs, maxMetricsAllowed);
        if (ticker == null) {
            throw new NullPointerException("ticker is marked non-null but is null");
        }
        this.idToAggregatorCache = SystemMetricAggregatorFactory.expiringCache(ticker);
        this.aggregatorToIdMap = new MapMaker().weakKeys().makeMap();
        this.unregisteredAggregatorSet = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public AgentRawMetricIdentifier[] getRegisteredMetrics() {
        Set ids = this.idToAggregatorCache.asMap().keySet();
        return ids.toArray(new AgentRawMetricIdentifier[ids.size()]);
    }

    public void unregisterAggregator(AgentRawMetricIdentifier metricIdentifier) {
        if (metricIdentifier != null) {
            this.idToAggregatorCache.invalidate((Object)metricIdentifier);
        }
    }

    public void unregisterAggregator(IMetricAggregator aggregator) {
        if (aggregator != null) {
            aggregator = SystemMetricAggregatorProxy.getAggregatorFromProxy(aggregator);
            AgentRawMetricIdentifier metricIdentifier = (AgentRawMetricIdentifier)this.aggregatorToIdMap.get(aggregator);
            this.unregisterAggregator(metricIdentifier);
        }
    }

    public void clearAllAggregators() {
        this.idToAggregatorCache.invalidateAll();
        this.unregisteredAggregatorSet.clear();
    }

    public void purge(AgentRawMetricIdentifier unregisteredMetricIdentifier) {
        this.idToAggregatorCache.invalidate((Object)unregisteredMetricIdentifier);
    }

    public final IMetricAggregator safeGetAggregator(AgentRawMetricIdentifier metricIdentifier, AgentRawMetricIdentifier[] otherNames) throws MetricReporterTypeMismatchException, MetricOverflowException {
        IMetricAggregator aggregator = this.safeGetAggregatorNoProxy(metricIdentifier, otherNames);
        if (!(aggregator instanceof DummyAggregator)) {
            aggregator = new SystemMetricAggregatorProxy(metricIdentifier, this);
        }
        return aggregator;
    }

    IMetricAggregator safeGetAggregatorNoProxy(AgentRawMetricIdentifier metricIdentifier) throws MetricReporterTypeMismatchException, MetricOverflowException {
        return this.safeGetAggregatorNoProxy(metricIdentifier, NO_OTHER_NAMES);
    }

    private IMetricAggregator safeGetAggregatorNoProxy(final AgentRawMetricIdentifier metricIdentifier, final AgentRawMetricIdentifier[] otherNames) throws MetricReporterTypeMismatchException, MetricOverflowException {
        IMetricAggregator aggregator;
        boolean fail = false;
        try {
            aggregator = (IMetricAggregator)this.idToAggregatorCache.get((Object)metricIdentifier, (Callable)new Callable<IMetricAggregator>(){

                @Override
                public IMetricAggregator call() throws RefreshFailedException {
                    if (SystemMetricAggregatorFactory.this.isAtCapacity()) {
                        throw new RefreshFailedException();
                    }
                    IMetricAggregator newAggregator = SystemMetricAggregatorFactory.this._createNewAggregator(metricIdentifier.getMetricAggregatorType());
                    SystemMetricAggregatorFactory.this.registerNewAggregator(newAggregator, metricIdentifier, otherNames);
                    return newAggregator;
                }
            });
        }
        catch (ExecutionException e) {
            aggregator = this.getEmptyAggregator();
            fail = true;
        }
        if (!fail && !aggregator.getType().equals((Object)metricIdentifier.getMetricAggregatorType())) {
            throw new MetricReporterTypeMismatchException("Aggregator of " + String.valueOf(aggregator.getType()) + " already exists for metric " + String.valueOf(metricIdentifier));
        }
        return aggregator;
    }

    protected IMetricAggregator getMetricAggregator(AgentRawMetricIdentifier metricId) {
        IMetricAggregator aggregator = (IMetricAggregator)this.idToAggregatorCache.getIfPresent((Object)metricId);
        if (aggregator != null) {
            if (aggregator instanceof SystemMetricAggregatorProxy) {
                throw new AssertionError((Object)"Cache should not contain proxy");
            }
            aggregator = new SystemMetricAggregatorProxy(metricId, this);
        }
        return aggregator;
    }

    private IMetricAggregator _createNewAggregator(MetricAggregatorType type) {
        if (type == MetricAggregatorType.PERCENTILE) {
            return new SimplePercentileMetricAggregator(SimplePercentileMetricAggregator.PercentileType.PERCENTILE_95);
        }
        return SystemMetricAggregatorFactory.createNewAggregator((MetricAggregatorType)type);
    }

    protected void registerNewAggregator(IMetricAggregator aggregator, AgentRawMetricIdentifier metricIdentifier, @NonNull AgentRawMetricIdentifier[] otherNames) {
        if (otherNames == null) {
            throw new NullPointerException("otherNames is marked non-null but is null");
        }
        if (otherNames.length > 0) {
            throw new IllegalArgumentException("SystemMetricAggregatorFactory does not allow multiple IDs for one aggregator");
        }
        if (aggregator instanceof SystemMetricAggregatorProxy) {
            throw new AssertionError((Object)"Cache should not contain proxy");
        }
        this.idToAggregatorCache.put((Object)metricIdentifier, (Object)aggregator);
        this.aggregatorToIdMap.put(aggregator, metricIdentifier);
    }

    protected void addUnregisteredAggregator(IMetricAggregator unregAggregator) {
        unregAggregator = SystemMetricAggregatorProxy.getAggregatorFromProxy(unregAggregator);
        this.unregisteredAggregatorSet.add(unregAggregator);
    }

    protected IMetricAggregator moveMetricToRegistered(AgentRawMetricIdentifier metricIdentifier, final IMetricAggregator metricAggregator) {
        if (metricAggregator instanceof SystemMetricAggregatorProxy) {
            throw new IllegalArgumentException("Unregistered aggregator should not be proxy");
        }
        try {
            IMetricAggregator currentAggregator = (IMetricAggregator)this.idToAggregatorCache.get((Object)metricIdentifier, (Callable)new Callable<IMetricAggregator>(){

                @Override
                public IMetricAggregator call() {
                    return metricAggregator;
                }
            });
            if (currentAggregator == metricAggregator) {
                this.aggregatorToIdMap.put(metricAggregator, metricIdentifier);
                this.unregisteredAggregatorSet.remove(metricAggregator);
            }
            SystemMetricAggregatorProxy aggregatorProxy = new SystemMetricAggregatorProxy(metricIdentifier, this);
            return aggregatorProxy;
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    protected void collateAllAggregators(List<AgentRawMetricData> registeredMetrics, List<AgentRawMetricData> unregisteredMetrics, ILogger logger) {
        for (Map.Entry entry : this.idToAggregatorCache.asMap().entrySet()) {
            AgentRawMetricIdentifier metricId = (AgentRawMetricIdentifier)entry.getKey();
            IMetricAggregator aggregator = (IMetricAggregator)entry.getValue();
            SystemMetricAggregatorFactory.collateMetricWithIds((IMetricAggregator)aggregator, Collections.singleton(metricId), registeredMetrics, unregisteredMetrics, (ILogger)logger);
        }
    }

    protected Set<IMetricAggregator> getAllUnregisteredAggregators() {
        return new HashSet<IMetricAggregator>(this.unregisteredAggregatorSet);
    }

    protected int currentWeight() {
        this.idToAggregatorCache.cleanUp();
        return (int)(this.idToAggregatorCache.size() + (long)this.unregisteredAggregatorSet.size());
    }
}

