/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.appdynamics.agent.sim.registration.IRegistrationTaskManager;
import com.google.inject.Provider;
import com.singularity.ee.agent.appagent.kernel.AgentRestRequestFactory;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.AMetricSubscriber;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricRegistrationException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricsForTimeslice;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricData;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.dto.RawMetricIdentifier;
import com.singularity.ee.rest.RESTRequest;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.spi.IMetricDataRequest;
import com.singularity.ee.rest.controller.request.spi.IMetricRegistrationRequest;
import com.singularity.ee.util.httpclient.SimpleHttpClientWrapper;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAgentMetricSender
extends AMetricSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemAgentMetricSender.class);
    private String machineID;
    private String nodeId;
    private final AgentType agentType;
    private final SimpleHttpClientWrapper httpClientWrapper;
    private Provider<IRegistrationTaskManager> registrationTaskManagerProvider;
    private IRegistrationTaskManager registrationTaskManager;
    private long currentRegistrationTimeoutCount = 0L;
    private static final long INITIAL_RESTART_DELAY_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final long MAX_RESTART_DELAY_MILLIS = TimeUnit.HOURS.toMillis(1L);
    private static final double BACK_OFF_MULTIPLIER = 2.0;
    private long lastRestartAttemptTime = 0L;
    private long nextRestartDelayMillis = INITIAL_RESTART_DELAY_MILLIS;

    public SystemAgentMetricSender(String nodeId, ILogger logger, int controllerPort, String controllerHost, String machineID, AgentType agentType, SimpleHttpClientWrapper httpClientWrapper, IEventGenerationService egs) {
        super(logger, controllerPort, controllerHost, egs);
        this.machineID = machineID;
        this.nodeId = nodeId;
        this.agentType = agentType;
        this.httpClientWrapper = httpClientWrapper;
    }

    public SystemAgentMetricSender(String nodeId, ILogger logger, int controllerPort, String controllerHost, String machineID, AgentType agentType, SimpleHttpClientWrapper httpClientWrapper, IEventGenerationService egs, Provider<IRegistrationTaskManager> registrationTaskManagerProvider) {
        this(nodeId, logger, controllerPort, controllerHost, machineID, agentType, httpClientWrapper, egs);
        this.registrationTaskManagerProvider = registrationTaskManagerProvider;
    }

    protected IMetricRegistrationRequest getMetricRegistrationRequest() {
        IMetricRegistrationRequest metricRegistrationRequest = AgentRestRequestFactory.getAgentRESTRequestFactory().getMetricRegistrationRequest(this.controllerHost, this.controllerPort, this.machineID, this.logger);
        if (metricRegistrationRequest instanceof RESTRequest && this.httpClientWrapper != null) {
            ((RESTRequest)metricRegistrationRequest).setHttpClient(this.httpClientWrapper);
        }
        if (this.nodeId != null) {
            metricRegistrationRequest.setComponentNodeId(this.nodeId);
        }
        return metricRegistrationRequest;
    }

    protected IMetricRegistrationRequest getMetricRegistrationResponse(IMetricRegistrationRequest metricRegistrationRequest, String responseBody) throws ResponseReadException {
        IMetricRegistrationRequest metricRegistrationResponse = AgentRestRequestFactory.getAgentRESTRequestFactory().getMetricRegistrationResponse(responseBody, this.logger);
        return metricRegistrationResponse;
    }

    protected IMetricDataRequest getMetricDataRequest() {
        IMetricDataRequest metricDataRequest = AgentRestRequestFactory.getAgentRESTRequestFactory().getMetricDataRequest(this.controllerHost, this.controllerPort, this.machineID, this.logger);
        if (metricDataRequest instanceof RESTRequest && this.httpClientWrapper != null) {
            ((RESTRequest)metricDataRequest).setHttpClient(this.httpClientWrapper);
        }
        if (this.nodeId != null) {
            metricDataRequest.setComponentNodeId(this.nodeId);
        }
        return metricDataRequest;
    }

    protected IMetricDataRequest getMetricDataResponse(IHttpExecutionResponse httpExecutionResponse) throws ResponseReadException {
        return null;
    }

    protected AgentType getAgentType() {
        return this.agentType;
    }

    protected int getMetricBlacklistLimit() {
        return 1450;
    }

    protected void handleRegistrationRequestError(List<AgentRawMetricData> unregisteredMetrics, IHttpExecutionResponse httpExecutionResponse) throws MetricRegistrationException {
    }

    protected void handleRegistrationFailed(List<AgentRawMetricData> unregisteredMetrics) {
    }

    protected void onMetricRegistrationEndEvent(List<RawMetricIdentifier> metricIDList, Map<String, String> registeredMetrics, List<AgentRawMetricData> unregisteredMetrics, Set<String> invalidMetricNameSet) {
    }

    protected void handleEmptyMetricDataRequest(IMetricDataRequest request) {
        request.sendRequest();
    }

    protected void handleMetricSendFailureEvent(MetricsForTimeslice metrics) {
    }

    protected void handleMetricDataResponse(MetricsForTimeslice metrics, IMetricDataRequest request, IMetricDataRequest response) {
        if (this.registrationTaskManager == null && this.registrationTaskManagerProvider != null) {
            this.registrationTaskManager = (IRegistrationTaskManager)this.registrationTaskManagerProvider.get();
        }
        if (this.registrationTaskManager == null) {
            return;
        }
        if (!this.registrationTaskManager.isRegistrationResilienceEnabled()) {
            return;
        }
        this.ensureRegistrationTaskIsScheduled();
        this.handlePotentialBlockingIO();
    }

    private void ensureRegistrationTaskIsScheduled() {
        if (this.registrationTaskManager.isScheduled()) {
            log.trace("Both registration and metric calls are running as scheduled.");
        } else {
            log.info("Registration Task was unexpectedly stopped or terminated due to unforeseen circumstances.");
            this.registrationTaskManager.restartRegistrationLifecycle();
            log.info("Registration task successfully restarted");
            this.currentRegistrationTimeoutCount = 0L;
        }
    }

    private void handlePotentialBlockingIO() {
        long lastTimestamp = this.registrationTaskManager.getLastSuccessfulRegistrationTimestamp();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTimestamp > IRegistrationTaskManager.THRESHOLD_TIME_MILLIS) {
            log.info("Detected potential blocking I/O operation in the registration call. Last successful registration timestamp: {}, Current time: {}", (Object)lastTimestamp, (Object)currentTime);
            if (this.currentRegistrationTimeoutCount >= 5L) {
                long timeSinceLastRestartAttempt = currentTime - this.lastRestartAttemptTime;
                if (timeSinceLastRestartAttempt >= this.nextRestartDelayMillis) {
                    log.info("Initiating shutdown of the Registration Task to release the system thread blocked by the registration call.");
                    this.registrationTaskManager.restartRegistrationLifecycle();
                    this.nextRestartDelayMillis = Math.min((long)((double)this.nextRestartDelayMillis * 2.0), MAX_RESTART_DELAY_MILLIS);
                    this.currentRegistrationTimeoutCount = 0L;
                    this.lastRestartAttemptTime = currentTime;
                } else {
                    log.info("Waiting for " + (this.nextRestartDelayMillis - timeSinceLastRestartAttempt) + "ms before attempting to restart the Registration Task again.");
                }
            } else {
                ++this.currentRegistrationTimeoutCount;
                log.trace("Incremented Registration Task timeout count to " + this.currentRegistrationTimeoutCount);
            }
        }
    }

    protected boolean isShouldMergeDuplicateMetrics() {
        return false;
    }

    public boolean isInitialized() {
        return true;
    }

    @Generated
    public void setLastRestartAttemptTime(long lastRestartAttemptTime) {
        this.lastRestartAttemptTime = lastRestartAttemptTime;
    }

    @Generated
    public long getNextRestartDelayMillis() {
        return this.nextRestartDelayMillis;
    }
}

