/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.singularity.ee.agent.commonservices.metricgeneration.MetricGenerationService;
import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.exception.TaskExecutionException;
import com.singularity.ee.agent.systemagent.api.exception.TaskInstantiationException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorDelegate;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorTaskMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorStreamConsumer;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorTaskRunner;
import com.singularity.ee.agent.systemagent.task.TimeoutTask;
import com.singularity.ee.task.TaskType;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeriodicTaskRunner
implements IAgentRunnable {
    private Logger logger = LogManager.getLogger((String)PeriodicTaskRunner.class.getName());
    private final ManagedMonitorTaskMetaData managedMonitorTaskMetaData;
    private final IAgentScheduledExecutorService scheduler;
    private final ITask task;
    private final MonitorTaskRunner taskRunner;
    private volatile boolean initialized;
    private MonitorStreamConsumer monitorConsumer = null;

    public PeriodicTaskRunner(ManagedMonitorTaskMetaData managedMonitorTaskMetaData, MetricGenerationService metricService, IAgentScheduledExecutorService scheduler, ManagedMonitorDelegate managedMonitorDelegate) throws TaskInstantiationException {
        this.managedMonitorTaskMetaData = managedMonitorTaskMetaData;
        this.scheduler = scheduler;
        this.taskRunner = new MonitorTaskRunner(managedMonitorTaskMetaData, metricService, scheduler, managedMonitorDelegate);
        this.task = this.taskRunner.createTask();
    }

    public void run() {
        try {
            this.setupTask();
            this.runTask();
        }
        catch (Throwable e) {
            this.logger.error("Error creating environment task ", e);
        }
        finally {
            if (this.monitorConsumer != null && this.managedMonitorTaskMetaData.getTaskMetaData().getTaskType() == TaskType.EXECUTABLE) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                this.monitorConsumer.stop();
            }
        }
    }

    private void setupTask() {
        if (this.managedMonitorTaskMetaData.getTaskMetaData().getTaskType() == TaskType.EXECUTABLE) {
            this.monitorConsumer = this.taskRunner.setupMetricFeed(this.task);
            this.logger.info("Periodic Task - setup metric feed for [" + this.managedMonitorTaskMetaData.getTaskMetaData().getName() + "]");
            TimeoutTask timerTask = new TimeoutTask(this.monitorConsumer);
            this.scheduler.schedule((IAgentRunnable)timerTask, this.getTimeOut(this.managedMonitorTaskMetaData.getTaskMetaData().getExecutionTimeOutInSeconds()), AgentTimeUnit.MILLISECONDS);
        } else if (!this.initialized) {
            this.monitorConsumer = this.taskRunner.setupMetricFeed(this.task);
            this.logger.info("Periodic Task - setup metric feed for [" + this.managedMonitorTaskMetaData.getTaskMetaData().getName() + "]");
            this.initialized = true;
        }
    }

    private void runTask() throws TaskExecutionException {
        this.taskRunner.runTask(this.task);
    }

    public boolean cancel() {
        try {
            this.task.stop();
        }
        catch (Throwable e) {
            this.logger.warn("Error stopping task", e);
        }
        return true;
    }

    private long getTimeOut(int valueRead) {
        long timeout = valueRead == -1 ? 120000L : (long)(valueRead * 1000);
        this.logger.info("Returning time out value of [" + timeout + "] ms for monitor task [" + this.managedMonitorTaskMetaData.getTaskMetaData().getName() + "]");
        return timeout;
    }
}

