/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.google.common.collect.ImmutableList;
import com.singularity.ee.agent.commonservices.eventgeneration.EventGenerationService;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.eventgeneration.events.EventsForTimeslice;
import com.singularity.ee.agent.commonservices.eventgeneration.events.IEventSubscriber;
import com.singularity.ee.agent.commonservices.metricgeneration.MetricGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.IMetricSubscriber;
import com.singularity.ee.agent.commonservices.timeskewhandling.AControllerTimeSkewHandler;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.IControllerTimeSkewHandler;
import com.singularity.ee.agent.resolver.PublishQueueLengthSupplier;
import com.singularity.ee.agent.systemagent.IMachineAgent;
import com.singularity.ee.agent.systemagent.api.ISelfManagedTask;
import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.exception.TaskInstantiationException;
import com.singularity.ee.agent.systemagent.components.monitormanager.IMonitorDelegate;
import com.singularity.ee.agent.systemagent.components.monitormanager.ManagedMonitorMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorType;
import com.singularity.ee.agent.systemagent.components.monitormanager.exception.MonitorInitializationException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ContinuousTaskMonitor;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ContinuousTaskRunner;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.EventOutputHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ExecutionStyle;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.IMonitorOutputHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ISystemAgentMetricSenderFactory;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorTaskMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MetricOutputHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.PeriodicTaskRunner;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ScheduledTaskRunner;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.SystemAgentMetricSender;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.SystemMetricAggregatorFactory;
import com.singularity.ee.agent.systemagent.task.ExecTask;
import com.singularity.ee.agent.systemagent.task.JavaTaskCreator;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.EventDataRequest;
import com.singularity.ee.task.ExecTaskMetaData;
import com.singularity.ee.task.JavaTaskMetaData;
import com.singularity.ee.task.TaskMetaData;
import com.singularity.ee.task.TaskType;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.log4j.Log4JLoggerAdapter;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagedMonitorDelegate
implements IMonitorDelegate {
    private static final int DEFAULT_MAX_INACTIVE_INTERVAL = 30;
    private static final int DEFAULT_AGGREGATION_FREQUENCY_IN_MILLIS = 60000;
    private static final int DEFAULT_EVENT_PUBLISHING_FREQUENCY_IN_MILLIS = 60000;
    private static final String AGGREGATION_FREQUENCY_PARAM = "envmonitor.aggregation.frequency";
    private static final Logger logger = LogManager.getLogger((String)ManagedMonitorDelegate.class.getName());
    private final Set<String> managedMonitors = new CopyOnWriteArraySet<String>();
    private final Map<String, PeriodicTaskRunnerInFlightState> periodicTasks = new ConcurrentHashMap<String, PeriodicTaskRunnerInFlightState>();
    private final Map<String, ScheduledTaskRunner> scheduledTasks = new ConcurrentHashMap<String, ScheduledTaskRunner>();
    private final MetricGenerationService metricService;
    private final IEventGenerationService eventService;
    private final ContinuousTaskMonitor continousTaskMonitor;
    private final IAgentScheduledExecutorService scheduler;
    private final String controllerHost;
    private final int controllerPort;
    private final String machineID;
    private final String resolvedHostInfo;
    private final EventSender eventSender;
    private final IMachineAgent machineAgent;
    private final Collection<IMonitorOutputHandler> monitorOutputHandlers;
    private final ISystemAgentMetricSenderFactory senderFactory;

    public ManagedMonitorDelegate(IAgentScheduledExecutorService scheduler, String controllerHost, int controllerPort, String machineID, String nodeID, String resolvedHostInfo, AControllerTimeSkewHandler skewHandler, IMachineAgent machineAgent, @NotNull Collection<IMonitorOutputHandler> additionalOutputHandlers, ISystemAgentMetricSenderFactory senderFactory) {
        this.scheduler = scheduler;
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.machineID = machineID;
        this.machineAgent = machineAgent;
        this.resolvedHostInfo = resolvedHostInfo;
        this.senderFactory = senderFactory;
        String frequencyStr = System.getProperty(AGGREGATION_FREQUENCY_PARAM);
        int frequency = this.readFrequency(frequencyStr, 60000);
        boolean isServiceDisabledByDefault = machineAgent.areServicesDisabledOnStartup();
        logger.info("Started Agent Metric Generation Service");
        Log4JLogger iLogger = new Log4JLogger(logger);
        Log4JLoggerAdapter iADLogger = new Log4JLoggerAdapter(iLogger);
        String eventPublishingFrequencyStr = System.getProperty("appdynamics.event.publish.interval");
        int eventPublishingFrequency = this.readFrequency(eventPublishingFrequencyStr, 60000);
        this.eventService = new EventGenerationService((IADLogger)iADLogger, eventPublishingFrequency, scheduler, (IControllerTimeSkewHandler)skewHandler);
        this.eventSender = new EventSender(isServiceDisabledByDefault);
        this.eventService.setEventSubscriber((IEventSubscriber)this.eventSender);
        SystemAgentMetricSender subscriber = senderFactory != null ? senderFactory.create(nodeID, iLogger, controllerPort, controllerHost, machineID, machineAgent.getAgentType(), machineAgent.getHttpClientWrapper(), this.eventService) : new SystemAgentMetricSender(nodeID, iLogger, controllerPort, controllerHost, machineID, machineAgent.getAgentType(), machineAgent.getHttpClientWrapper(), this.eventService);
        int maxMetrics = SystemUtilsTranslateable.getIntProperty((String)"appdynamics.agent.maxMetrics", (int)1450);
        PublishQueueLengthSupplier publishQueueLengthSupplier = new PublishQueueLengthSupplier((ILogger)iLogger);
        int publishQueueLength = publishQueueLengthSupplier.get();
        this.metricService = new MetricGenerationService(30, publishQueueLength, frequency, (ILogger)iLogger, (IControllerTimeSkewHandler)skewHandler, subscriber.getAgentType(), (AMetricAggregatorFactory)new SystemMetricAggregatorFactory(iLogger, this.eventService, maxMetrics), isServiceDisabledByDefault);
        this.metricService.setMetricSubscriber((IMetricSubscriber)subscriber);
        this.monitorOutputHandlers = this.setupMonitorOutputHandlers(additionalOutputHandlers);
        logger.info("Started Agent Env Properties Service");
        this.continousTaskMonitor = new ContinuousTaskMonitor();
        long delay = 30000L;
        scheduler.scheduleAtFixedRate((IAgentRunnable)this.continousTaskMonitor, delay, delay, AgentTimeUnit.MILLISECONDS);
        logger.info("Scheduled Continuous Task Monitor with frequency [" + delay + "]ms");
    }

    @Override
    public MonitorType getType() {
        return MonitorType.MANAGED;
    }

    @Override
    public void initializeMonitor(MonitorMetaData monitorMetaData, @NonNull Map<String, String> monitorConfig, Map<String, String> environmentVars) throws MonitorInitializationException {
        if (monitorConfig == null) {
            throw new NullPointerException("monitorConfig is marked non-null but is null");
        }
        if (!monitorMetaData.isEnabled()) {
            logger.info("Not initializing managed monitor [" + monitorMetaData.getName() + "] - Disabled in configuration file.");
            return;
        }
        logger.info("Initializing managed monitor [" + monitorMetaData.getName() + "]");
        ManagedMonitorMetaData metaData = (ManagedMonitorMetaData)monitorMetaData;
        TaskMetaData initTaskMetaData = metaData.getInitTaskMetaData();
        if (initTaskMetaData != null) {
            try {
                logger.info("Initializing managed monitor [" + monitorMetaData.getName() + "], init task name [" + initTaskMetaData.getName() + "]");
                ITask task = this.createTask(initTaskMetaData, monitorConfig);
                task.execute(monitorConfig, new TaskExecutionContext());
            }
            catch (Throwable e) {
                logger.warn("Error initializing managed monitor [" + monitorMetaData.getName() + "], init task name [" + initTaskMetaData.getName() + "]", e);
                throw new MonitorInitializationException(e);
            }
        }
        ManagedMonitorTaskMetaData runTaskMetaData = metaData.getRunMonitorMetaData();
        runTaskMetaData.addEnvironmentVars(environmentVars);
        try {
            logger.info("Executing managed monitor [" + monitorMetaData.getName() + "], task name [" + runTaskMetaData.getTaskMetaData().getName() + "]");
            this.setupEnvTask(monitorMetaData.getName(), runTaskMetaData);
        }
        catch (Throwable e) {
            logger.warn("Error executing managed monitor [" + monitorMetaData.getName() + "], task name [" + runTaskMetaData.getTaskMetaData().getName() + "]", e);
            throw new MonitorInitializationException(e);
        }
        this.managedMonitors.add(monitorMetaData.getName());
    }

    @Override
    public void initializeMonitor(MonitorMetaData monitorMetaData, Map<String, String> monitorConfig) throws MonitorInitializationException {
        this.initializeMonitor(monitorMetaData, monitorConfig, Collections.emptyMap());
    }

    @Override
    public boolean stopMonitor(String monitorName, Map<String, String> monitorConfig) {
        logger.info("Removing monitor [" + monitorName + "].");
        this.managedMonitors.remove(monitorName);
        return this.stopTaskIfExists(monitorName);
    }

    private ImmutableList<IMonitorOutputHandler> setupMonitorOutputHandlers(@NotNull Collection<IMonitorOutputHandler> additionalOutputHandlers) {
        ArrayList<IMonitorOutputHandler> outputHandlers = new ArrayList<IMonitorOutputHandler>();
        outputHandlers.add(new MetricOutputHandler(this.metricService.getMetricReporterFactory()));
        outputHandlers.add(new EventOutputHandler(this.getEventService(), this.getMachineID()));
        outputHandlers.addAll(additionalOutputHandlers);
        return ImmutableList.copyOf(outputHandlers);
    }

    private void setupEnvTask(String monitorName, ManagedMonitorTaskMetaData envTaskMetaData) throws TaskInstantiationException {
        if (envTaskMetaData.getExecutionStyle().equals((Object)ExecutionStyle.PERIODIC)) {
            logger.info(this.getTaskNameMsg(envTaskMetaData) + " is periodic");
            PeriodicTaskRunner periodicTaskRunner = new PeriodicTaskRunner(envTaskMetaData, this.metricService, this.scheduler, this);
            int execFrequency = envTaskMetaData.getExecutionFrequency();
            if (execFrequency == -1) {
                execFrequency = 60;
            }
            long delay = (long)execFrequency * 1000L;
            IAgentScheduledFuture scheduledFuture = this.scheduler.scheduleAtFixedRate((IAgentRunnable)periodicTaskRunner, 5000L, delay, AgentTimeUnit.MILLISECONDS);
            PeriodicTaskRunnerInFlightState inFlightState = new PeriodicTaskRunnerInFlightState(periodicTaskRunner, scheduledFuture);
            this.periodicTasks.put(monitorName, inFlightState);
            logger.debug("Scheduled Environment Task [" + envTaskMetaData.getTaskMetaData().getName() + "Frequency -" + delay + "ms]");
        } else if (envTaskMetaData.getExecutionStyle().equals((Object)ExecutionStyle.SCHEDULED)) {
            logger.info(this.getTaskNameMsg(envTaskMetaData) + " for monitor [" + monitorName + "] is SCHEDULED");
            ScheduledTaskRunner runner = new ScheduledTaskRunner(envTaskMetaData, this.metricService, this.scheduler, this);
            runner.run();
            this.scheduledTasks.put(monitorName, runner);
        } else {
            logger.info(this.getTaskNameMsg(envTaskMetaData) + " for monitor [" + monitorName + "] is continuous");
            ContinuousTaskRunner continousTaskRunner = new ContinuousTaskRunner(envTaskMetaData, this.metricService, this.scheduler, this);
            this.continousTaskMonitor.runTaskAndMonitor(monitorName, continousTaskRunner);
        }
    }

    @Override
    public Set<String> getInstalledMonitors() {
        return this.managedMonitors;
    }

    public IEventGenerationService getEventService() {
        return this.eventService;
    }

    public void switchDisabled(boolean isDisabled) {
        this.switchMetricServiceDisabled(isDisabled);
        this.switchEventServiceDisabled(isDisabled);
    }

    Collection<IMonitorOutputHandler> getOutputHandlers() {
        return this.monitorOutputHandlers;
    }

    private void cancelTask(String monitorName) {
        boolean taskExists;
        boolean bl = taskExists = this.periodicTasks.get(monitorName) != null;
        if (taskExists) {
            PeriodicTaskRunnerInFlightState inflightState = this.periodicTasks.remove(monitorName);
            logger.info("Removing Scheduled Periodic Task " + monitorName);
            inflightState.cancel();
        } else {
            taskExists = this.continousTaskMonitor.taskExists(monitorName);
            if (taskExists) {
                this.continousTaskMonitor.stopAndRemoveTask(monitorName);
            } else {
                logger.warn("Could not find task [" + monitorName + "] to remove");
            }
        }
    }

    private void stopAndRemoveScheduledTask(String monitorName) {
        ScheduledTaskRunner runner = this.scheduledTasks.remove(monitorName);
        if (runner != null) {
            runner.stop();
            logger.info("Scheduled Task [" + monitorName + "] Stopped");
        }
    }

    private boolean stopTaskIfExists(String monitorName) {
        if (this.periodicTasks.containsKey(monitorName)) {
            this.cancelTask(monitorName);
        }
        this.stopAndRemoveScheduledTask(monitorName);
        if (this.continousTaskMonitor.taskExists(monitorName)) {
            this.continousTaskMonitor.stopAndRemoveTask(monitorName);
        }
        return true;
    }

    private void switchMetricServiceDisabled(boolean isDisabled) {
        this.metricService.switchMetricServiceDisabled(isDisabled);
    }

    private void switchEventServiceDisabled(boolean isDisabled) {
        this.eventSender.switchPublishingDisabled(isDisabled);
    }

    public void shutdown() {
        for (String task : this.periodicTasks.keySet()) {
            this.cancelTask(task);
        }
        for (String task : this.scheduledTasks.keySet()) {
            this.stopAndRemoveScheduledTask(task);
        }
        this.continousTaskMonitor.shutdown();
        this.metricService.shutdown();
    }

    private int readFrequency(String frequencyStr, int defaultValue) {
        if (frequencyStr != null) {
            try {
                return Integer.parseInt(frequencyStr);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private ITask createTask(TaskMetaData taskMetaData, Map<String, String> monitorConfig, Map<String, String> environmentVars) throws TaskInstantiationException {
        if (taskMetaData.getTaskType().equals((Object)TaskType.EXECUTABLE)) {
            ExecTaskMetaData execData = (ExecTaskMetaData)taskMetaData;
            return new ExecTask(execData, monitorConfig, environmentVars);
        }
        if (taskMetaData.getTaskType().equals((Object)TaskType.JAVA)) {
            JavaTaskMetaData javaTaskData = (JavaTaskMetaData)taskMetaData;
            JavaTaskCreator javaTaskCreator = new JavaTaskCreator(javaTaskData);
            ITask task = javaTaskCreator.createJavaTask();
            if (task instanceof ISelfManagedTask) {
                ((ISelfManagedTask)task).init(this.metricService.getMetricAggregatorFactory(), this.scheduler, this);
            }
            return task;
        }
        throw new TaskInstantiationException("Invalid Task Type in task meta data " + String.valueOf(taskMetaData));
    }

    private ITask createTask(TaskMetaData taskMetaData, Map<String, String> monitorConfig) throws TaskInstantiationException {
        return this.createTask(taskMetaData, monitorConfig, Collections.emptyMap());
    }

    public MetricGenerationService getMetricService() {
        return this.metricService;
    }

    public String getMachineID() {
        return this.machineID;
    }

    public String getControllerHost() {
        return this.controllerHost;
    }

    public int getControllerPort() {
        return this.controllerPort;
    }

    public String getAccountKey() {
        if (this.machineAgent != null) {
            return this.machineAgent.getAccountKey();
        }
        return null;
    }

    public IAgentScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public IMachineAgent getMachineAgent() {
        return this.machineAgent;
    }

    public String getResolvedHostInfo() {
        return this.resolvedHostInfo;
    }

    private String getTaskNameMsg(ManagedMonitorTaskMetaData envTaskMetaData) {
        return "Task [" + envTaskMetaData.getTaskMetaData().getName() + "]";
    }

    private class EventSender
    implements IEventSubscriber {
        private volatile boolean isEventPublishingDisabled;

        EventSender(boolean isEventPublishingDisabled) {
            this.switchPublishingDisabled(isEventPublishingDisabled);
        }

        void switchPublishingDisabled(boolean isDisabled) {
            logger.info("Event Service is : [" + (isDisabled ? "disabled" : "enabled") + "].");
            this.isEventPublishingDisabled = isDisabled;
        }

        public boolean publish(EventsForTimeslice events) {
            if (!events.hasEventsToPublish()) {
                return true;
            }
            if (this.isEventPublishingDisabled) {
                return true;
            }
            EventDataRequest request = new EventDataRequest(ManagedMonitorDelegate.this.controllerHost, ManagedMonitorDelegate.this.controllerPort, ManagedMonitorDelegate.this.machineID, (ILogger)new Log4JLogger(logger));
            request.setTimestamp(events.getTimesliceEndTimestamp());
            request.addEvents(events.getApplicationEvents());
            request.addEvents(events.getMachineEvents());
            HttpExecutionResponse response = request.sendRequest();
            if (response.isExceptionHappened()) {
                logger.warn("Error sending event data to controller:" + response.getExceptionMessage());
                return false;
            }
            try {
                EventDataRequest eventResponse = new EventDataRequest((IHttpExecutionResponse)response, (ILogger)new Log4JLogger(logger));
                if (logger.isDebugEnabled()) {
                    logger.debug("Reported events for Timeslice Ending at[" + String.valueOf(events.getTimesliceEndTimestamp()) + "]");
                }
            }
            catch (ResponseReadException e) {
                logger.warn("Error in event data response", (Throwable)e);
                logger.warn("Failed to upload " + events.toString());
            }
            return true;
        }

        public boolean isReady() {
            return ManagedMonitorDelegate.this.machineAgent != null;
        }
    }

    private static class PeriodicTaskRunnerInFlightState {
        private final PeriodicTaskRunner taskRunner;
        private final IAgentScheduledFuture scheduledFuture;

        PeriodicTaskRunnerInFlightState(PeriodicTaskRunner taskRunner, IAgentScheduledFuture scheduledFuture) {
            this.taskRunner = taskRunner;
            this.scheduledFuture = scheduledFuture;
        }

        public void cancel() {
            this.scheduledFuture.cancel(false);
            this.taskRunner.cancel();
        }
    }
}

