/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorOutputHandler;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.events.MachineEventData;
import com.singularity.ee.util.log4j.Log4JLoggerFactory;
import com.singularity.ee.util.logging.LogLevel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class EventOutputHandler
extends MonitorOutputHandler {
    private static Logger logger = LogManager.getLogger((String)EventOutputHandler.class.getName());
    private static final String EVENT = "event=";
    private static final Splitter EQUALS_SPLITTER = Splitter.on((String)"=").limit(2).trimResults();
    private static final String EVENT_TYPE = "event-type";
    private static final String EVENT_SEVERITY = "severity";
    private static final String EVENT_SUBTYPE = "sub-type";
    private static final String EVENT_MESSAGE = "message";
    private static final String DEBUG_SEVERITY = "DEBUG";
    private static final String EVENT_TYPE_MACHINE_AGENT_LOG = EventType.MACHINE_AGENT_LOG.toString();
    private static final Set<String> MACHINE_AGENT_LOG_TOKENS = ImmutableSet.of((Object)"event-type", (Object)"severity", (Object)"message");
    private final IEventGenerationService eventService;
    private final String machineID;

    EventOutputHandler(IEventGenerationService eventService, String machineID) {
        this.eventService = eventService;
        this.machineID = machineID;
    }

    @Override
    public void parseAndReportLine(String monitorLine) {
        if (!monitorLine.toLowerCase().startsWith(EVENT_TYPE) && !monitorLine.toLowerCase().startsWith(EVENT)) {
            return;
        }
        this.reportEventsForLine(monitorLine);
    }

    private void reportEventsForLine(String eventLine) {
        long machineIdLong = Long.parseLong(this.machineID);
        MachineEventData eventData = EventOutputHandler.createMachineEventData(eventLine, machineIdLong);
        if (eventData != null) {
            this.eventService.addMachineEvent(eventData);
            logger.log(EventOutputHandler.getLevelFromSeverity(eventData.getNotificationSeverity()), "Sending event to controller for: " + eventLine);
        } else {
            logger.log(Level.DEBUG, "Debug level event, it will not be sent to the controller. Data: " + eventLine);
        }
    }

    static Level getLevelFromSeverity(NotificationSeverity severity) {
        Level returnVal = null;
        if (severity == NotificationSeverity.INFO) {
            returnVal = Level.INFO;
        } else if (severity == NotificationSeverity.WARN) {
            returnVal = Level.WARN;
        } else if (severity == NotificationSeverity.ERROR) {
            returnVal = Level.ERROR;
        }
        return returnVal;
    }

    static MachineEventData createMachineEventData(String eventLine, long machineId) {
        EventType eventType;
        Map<String, String> eventTokenMap = eventLine.toLowerCase().startsWith(EVENT_TYPE) ? EventOutputHandler.createTokenMap(eventLine) : EventOutputHandler.createTokenMapFromJson(eventLine);
        if (eventTokenMap == null) {
            throw new IllegalArgumentException("Invalid event input");
        }
        String eventTypeString = eventTokenMap.remove(EVENT_TYPE);
        String severityString = eventTokenMap.remove(EVENT_SEVERITY);
        if (eventTypeString == null || eventTypeString.isEmpty() || severityString == null || severityString.isEmpty()) {
            throw new IllegalArgumentException("Missing EventType and Severity from the events. Original: " + eventLine);
        }
        if (severityString.equalsIgnoreCase(DEBUG_SEVERITY)) {
            return null;
        }
        NotificationSeverity severity = NotificationSeverity.valueOf((String)severityString.toUpperCase());
        if (eventTypeString.equalsIgnoreCase(EventType.MACHINE_AGENT_LOG.toString())) {
            eventType = EventType.MACHINE_AGENT_LOG;
        } else if (eventTypeString.equalsIgnoreCase(EventType.CUSTOM.toString())) {
            eventType = EventType.CUSTOM;
        } else {
            throw new IllegalArgumentException("Invalid event-type value. Event Line: " + eventLine);
        }
        String subType = eventTokenMap.remove(EVENT_SUBTYPE);
        MachineEventData eventData = new MachineEventData(System.currentTimeMillis(), severity, eventType, null, eventTokenMap.get(EVENT_MESSAGE), machineId);
        eventData.setSubType(subType);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(eventTokenMap);
        eventData.setEventProperties(properties);
        return eventData;
    }

    private static Map<String, String> createTokenMapFromJson(String lineRead) {
        ObjectMapper mapper = new ObjectMapper();
        String json = (String)EQUALS_SPLITTER.splitToList((CharSequence)lineRead).get(1);
        Map eventTokenMap = null;
        try {
            eventTokenMap = (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            logger.error("Cannot deserialize the event JSON. Line read " + lineRead, (Throwable)e);
        }
        return eventTokenMap;
    }

    static boolean handleMachineAgentLogMessage(String line) {
        return EventOutputHandler.handleMachineAgentLogMessage(logger, line);
    }

    @VisibleForTesting
    static boolean handleMachineAgentLogMessage(Logger theLogger, String line) {
        boolean isLogged = false;
        try {
            String eventTypeString;
            Map<String, String> tokenMap = MonitorOutputHandler.createTokenMap(line);
            if (tokenMap.keySet().equals(MACHINE_AGENT_LOG_TOKENS) && (eventTypeString = tokenMap.get(EVENT_TYPE)).equalsIgnoreCase(EVENT_TYPE_MACHINE_AGENT_LOG)) {
                String severityString = tokenMap.get(EVENT_SEVERITY);
                LogLevel severity = LogLevel.valueOf((String)severityString.toUpperCase());
                String messageString = tokenMap.get(EVENT_MESSAGE);
                theLogger.log(Log4JLoggerFactory.getLog4JLevel(severity), messageString);
                isLogged = true;
            }
        }
        catch (IllegalArgumentException e) {
            isLogged = false;
        }
        return isLogged;
    }
}

