/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ContinuousTaskRunner;
import com.singularity.ee.agent.systemagent.task.TaskThreadPools;
import com.singularity.ee.util.collections.CopyOnWriteMap;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContinuousTaskMonitor
implements IAgentRunnable {
    private static Logger logger = LogManager.getLogger((String)ContinuousTaskMonitor.class.getName());
    private final Map<String, ContinuousTaskRunner> continuousTasks = new CopyOnWriteMap();

    public void runTaskAndMonitor(String taskName, ContinuousTaskRunner taskRunner) {
        this.continuousTasks.put(taskName, taskRunner);
        TaskThreadPools.getTaskThreadPool().execute(taskRunner);
        logger.info("Continuous Task [" + taskName + "] Started");
    }

    public void stopAndRemoveTask(String taskName) {
        ContinuousTaskRunner taskRunner = this.continuousTasks.remove(taskName);
        if (taskRunner != null) {
            taskRunner.stop();
            logger.info("Continuous Task [" + taskName + "] Stopped");
        }
    }

    private void monitorTasks() {
        for (String taskName : this.continuousTasks.keySet()) {
            ContinuousTaskRunner taskRunner = this.continuousTasks.get(taskName);
            logger.debug("Checking on task [" + taskName + "] running: " + taskRunner.isTaskRunning());
            boolean restartProcess = false;
            if (taskRunner.getManagedMonitorTaskMetaData().getMessageSilenceThresholdInSeconds() != -1L) {
                if (System.currentTimeMillis() - taskRunner.getLastMessageReceivedTime() > taskRunner.getManagedMonitorTaskMetaData().getMessageSilenceThresholdInSeconds() * 1000L) {
                    logger.info("Task [" + taskName + "] has not received a message for [" + (System.currentTimeMillis() - taskRunner.getLastMessageReceivedTime()) / 1000L + "] seconds. (Threshold is: [" + taskRunner.getManagedMonitorTaskMetaData().getMessageSilenceThresholdInSeconds() + "] seconds). Will restart.");
                    restartProcess = true;
                } else {
                    logger.debug("Last message was received: [" + (System.currentTimeMillis() - taskRunner.getLastMessageReceivedTime()) / 1000L + "] seconds ago. Threshold is [" + taskRunner.getManagedMonitorTaskMetaData().getMessageSilenceThresholdInSeconds() + "] seconds.");
                }
            } else {
                logger.debug("last message check disabled.");
            }
            if (taskRunner.getManagedMonitorTaskMetaData().getRestartProcessInSeconds() != -1) {
                logger.info("Task [" + taskName + "] running for: [" + taskRunner.getUptime() / 1000L + "] seconds. Will restart after: [" + taskRunner.getManagedMonitorTaskMetaData().getRestartProcessInSeconds() + "] seconds");
                if (taskRunner.getUptime() > (long)(taskRunner.getManagedMonitorTaskMetaData().getRestartProcessInSeconds() * 1000)) {
                    restartProcess = true;
                }
            } else {
                logger.debug("process kill after timeout watchdog disabled.");
            }
            if (restartProcess) {
                logger.info("Restarting the process. Expect exception with exit code.");
                taskRunner.stop();
            }
            if (taskRunner.isTaskRunning()) continue;
            logger.warn("Continuous Task [" + taskName + "] stopped, restarting..");
            TaskThreadPools.getTaskThreadPool().execute(taskRunner);
            logger.info("Continuous Task [" + taskName + "] Restarted");
        }
    }

    public void run() {
        try {
            this.monitorTasks();
        }
        catch (Throwable e) {
            logger.error("Error monitoring tasks", e);
        }
    }

    public boolean taskExists(String taskName) {
        return this.continuousTasks.keySet().contains(taskName);
    }

    public void shutdown() {
        for (String task : this.continuousTasks.keySet()) {
            logger.info("Shutting down continuous task [" + task + "]");
            this.stopAndRemoveTask(task);
        }
    }
}

