/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MonitorPropertiesFile {
    private Properties monitorProperties = new Properties();
    public static final String MONITOR_PROPERTIES_FILE = "monitor.properties";
    private String monitorPropsFile;

    public MonitorPropertiesFile(String monitorDir) throws IOException {
        this.monitorPropsFile = monitorDir + File.separator + MONITOR_PROPERTIES_FILE;
        if (!new File(this.monitorPropsFile).exists()) {
            new File(this.monitorPropsFile).createNewFile();
        }
        this.monitorProperties.load(new FileInputStream(this.monitorPropsFile));
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : this.monitorProperties.keySet()) {
            map.put((String)key, this.monitorProperties.getProperty((String)key));
        }
        return map;
    }

    public void saveProperties(Map<String, String> map) throws IOException {
        for (String key : map.keySet()) {
            this.monitorProperties.setProperty(key, map.get(key));
        }
        this.monitorProperties.store(new FileOutputStream(this.monitorPropsFile), "Monitor Properties");
    }
}

