/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.agent.systemagent.components.monitormanager.ManagedMonitorMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorConfigProperty;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorConfigPropertyType;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorTagNames;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorType;
import com.singularity.ee.agent.systemagent.components.monitormanager.UnmanagedMonitorMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.exception.InvalidMonitorConfigException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorTaskMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorTaskReader;
import com.singularity.ee.task.InvalidTaskMetaDataException;
import com.singularity.ee.task.TaskMetaData;
import com.singularity.ee.task.TaskReader;
import com.singularity.ee.util.OSNameUtil;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorConfigReader
implements MonitorTagNames {
    private static Logger logger = LogManager.getLogger((String)MonitorConfigReader.class.getName());
    private String monitorWorkingDir;
    private Document xmlDoc;
    private MonitorMetaData monitorMetaData;
    private MonitorType monitorType;

    public MonitorConfigReader(String monitorConfigFile, String monitorWorkingDir) throws InvalidMonitorConfigException {
        this.monitorWorkingDir = monitorWorkingDir;
        try {
            logger.info("Reading monitor config file:" + monitorConfigFile);
            this.xmlDoc = XMLParseUtility.getXmlDocumentFromFile((File)new File(monitorConfigFile));
            this.setMonitorType();
            this.monitorMetaData = this.monitorType == MonitorType.MANAGED ? this.readManagedMonitorMetaData() : this.readUnmanagedMonitorMetaData();
        }
        catch (IOException e) {
            logger.warn("Error reading monitor configuration from file", (Throwable)e);
            throw new InvalidMonitorConfigException("Error reading monitor configuration from file", e);
        }
        catch (SAXException e) {
            logger.warn("Error reading monitor configuration from file", (Throwable)e);
            throw new InvalidMonitorConfigException("Error reading monitor configuration from file", e);
        }
        catch (ParserConfigurationException e) {
            logger.warn("Error reading monitor configuration from file", (Throwable)e);
            throw new InvalidMonitorConfigException("Error reading monitor configuration from file", e);
        }
    }

    public MonitorMetaData getMonitorMetaData() {
        return this.monitorMetaData;
    }

    public MonitorType getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType() throws InvalidMonitorConfigException {
        String type = XMLParseUtility.getTextForTagForElement((Node)this.xmlDoc.getDocumentElement(), (String)"type");
        if (type == null) {
            this.monitorType = MonitorType.MANAGED;
            return;
        }
        this.monitorType = type.equalsIgnoreCase(MonitorType.MANAGED.toString()) ? MonitorType.MANAGED : MonitorType.UNMANAGED;
    }

    private MonitorMetaData readUnmanagedMonitorMetaData() throws InvalidMonitorConfigException {
        try {
            String name = XMLParseUtility.getTextForTagForElement((Node)this.xmlDoc.getDocumentElement(), (String)"name");
            String displayName = XMLParseUtility.getTextForTagForElement((Node)this.xmlDoc.getDocumentElement(), (String)"display-name");
            String desc = XMLParseUtility.getTextForTagForElement((Node)this.xmlDoc.getDocumentElement(), (String)"description");
            if (desc == null) {
                desc = "Monitor";
            }
            UnmanagedMonitorMetaData monitorMetaData = new UnmanagedMonitorMetaData(name, displayName, desc);
            monitorMetaData.setConfiguration(this.getMonitorConfigProperties(this.xmlDoc.getDocumentElement()));
            Element initTaskElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)this.xmlDoc.getDocumentElement(), (String)"monitor-init-task");
            if (initTaskElement == null) {
                throw new InvalidMonitorConfigException("Could not find initialization task for unmanaged monitor");
            }
            TaskMetaData taskMetaData = new TaskReader().readFromTaskElement(initTaskElement, this.monitorWorkingDir);
            monitorMetaData.setInitTaskMetaData(taskMetaData);
            Element stopTaskElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)this.xmlDoc.getDocumentElement(), (String)"monitor-stop-task");
            TaskMetaData stopTaskMetaData = new TaskReader().readFromTaskElement(stopTaskElement, this.monitorWorkingDir);
            monitorMetaData.setInitTaskMetaData(stopTaskMetaData);
            return monitorMetaData;
        }
        catch (InvalidTaskMetaDataException e) {
            throw new InvalidMonitorConfigException(e);
        }
    }

    private MonitorMetaData readManagedMonitorMetaData() throws InvalidMonitorConfigException {
        try {
            Element runTaskElement;
            logger.info("os name [" + OSNameUtil.getName() + "] version [" + OSNameUtil.getVersion() + "]");
            String name = XMLParseUtility.getTextForTagForElement((Node)this.xmlDoc.getDocumentElement(), (String)"name");
            String displayName = XMLParseUtility.getTextForTagForElement((Node)this.xmlDoc.getDocumentElement(), (String)"display-name");
            String desc = XMLParseUtility.getTextForTagForElement((Node)this.xmlDoc.getDocumentElement(), (String)"description");
            boolean enabled = StringOperations.safeParseBoolean((String)XMLParseUtility.getTextForTagForElement((Node)this.xmlDoc.getDocumentElement(), (String)"enabled"), (boolean)true);
            List enableOverrides = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)this.xmlDoc.getDocumentElement(), (String)"enable-override");
            if (enableOverrides != null && enableOverrides.size() > 0) {
                logger.debug("evaluating enableOverrides");
                boolean override = this.evaluateEnableOverride(enableOverrides, !enabled);
                if (override) {
                    enabled = !enabled;
                    logger.info("Overriding enabled tag. new value = " + enabled);
                }
            } else {
                logger.debug("No enableOverrides found!");
            }
            if (desc == null) {
                desc = "Monitor";
            }
            ManagedMonitorMetaData monitorMetaData = new ManagedMonitorMetaData(name, displayName, desc);
            monitorMetaData.setEnabled(enabled);
            monitorMetaData.setConfiguration(this.getMonitorConfigProperties(this.xmlDoc.getDocumentElement()));
            Element initTaskElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)this.xmlDoc.getDocumentElement(), (String)"monitor-init-task");
            if (initTaskElement != null) {
                try {
                    TaskMetaData initTaskMetaData = new TaskReader().readFromTaskElement(initTaskElement, this.monitorWorkingDir);
                    monitorMetaData.setInitTaskMetaData(initTaskMetaData);
                }
                catch (InvalidTaskMetaDataException e) {
                    logger.debug("Init Task could not be read");
                }
            }
            if ((runTaskElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)this.xmlDoc.getDocumentElement(), (String)"monitor-run-task")) == null) {
                throw new InvalidMonitorConfigException("Could not find start task for managed monitor");
            }
            ManagedMonitorTaskMetaData taskMetaData = new MonitorTaskReader().readEnvTask(runTaskElement, this.monitorWorkingDir);
            monitorMetaData.setRunMonitorMetaData(taskMetaData);
            return monitorMetaData;
        }
        catch (InvalidTaskMetaDataException e) {
            throw new InvalidMonitorConfigException(e);
        }
    }

    private boolean evaluateEnableOverride(Collection<Element> enableOverrides, boolean lookFor) {
        logger.debug("evaluateEnableOverride looking for " + lookFor);
        for (Element enableOverrideElement : enableOverrides) {
            boolean value;
            String valueString = XMLParseUtility.getElementValue((Element)enableOverrideElement);
            logger.debug("evaluateEnableOverride value = " + valueString);
            if (valueString == null || (value = StringOperations.parseBooleanStr((String)valueString)) != lookFor) continue;
            Map attrMap = XMLParseUtility.getAttributeMapForElement((Element)enableOverrideElement);
            String requiredOS = (String)attrMap.get("os-type");
            String requiredOSVersion = (String)attrMap.get("os-version-pattern");
            logger.debug("evaluateEnableOverride os = " + requiredOS + " ver " + requiredOSVersion);
            if (!OSNameUtil.getName().toLowerCase().contains(requiredOS.toLowerCase()) || requiredOSVersion != null && !OSNameUtil.getVersion().matches(requiredOSVersion)) continue;
            return true;
        }
        return false;
    }

    private List<MonitorConfigProperty> getMonitorConfigProperties(Element monitorElement) {
        Element monitorConfigElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)monitorElement, (String)"monitor-configuration");
        ArrayList<MonitorConfigProperty> monitorConfigProperties = new ArrayList<MonitorConfigProperty>();
        if (monitorConfigElement == null) {
            return monitorConfigProperties;
        }
        List propElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)monitorConfigElement, (String)"property");
        for (Element propertyElement : propElements) {
            Map attrMap = XMLParseUtility.getAttributeMapForElement((Element)propertyElement);
            String name = (String)attrMap.get("name");
            boolean isRequired = Boolean.parseBoolean("is-required");
            String defaultValue = (String)attrMap.get("default-value");
            MonitorConfigPropertyType type = MonitorConfigPropertyType.valueOf(((String)attrMap.get("type")).toUpperCase());
            MonitorConfigProperty configProp = new MonitorConfigProperty(name, isRequired, defaultValue, type);
            monitorConfigProperties.add(configProp);
        }
        return monitorConfigProperties;
    }
}

