/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.controlchannel;

import com.singularity.ee.agent.systemagent.components.AAgentComponent;
import com.singularity.ee.agent.systemagent.handler.HandlerException;
import com.singularity.ee.agent.systemagent.handler.RequestHandlerContext;
import com.singularity.ee.agent.systemagent.task.util.AgentTaskHandler;
import com.singularity.ee.rest.RESTResponse;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentControlChannel
extends AAgentComponent {
    private static final Logger logger = LogManager.getLogger((String)AgentControlChannel.class.getName());
    private static final Log4JLogger iLogger = new Log4JLogger(logger);
    public static final String CONTROL_CHANNEL_DIR = "controlchannel";
    private final String tasksRootDir = this.getInstallDir() + File.separator + "controlchannel";
    private final AgentTaskHandler agentTaskHandler;

    public AgentControlChannel(String machineInstanceID, String controllerHost, int controllerPort, RequestHandlerContext handlerContext) throws MalformedURLException {
        super(machineInstanceID, controllerHost, controllerPort, handlerContext);
        this.agentTaskHandler = new AgentTaskHandler(this.tasksRootDir, controllerHost, controllerPort, machineInstanceID);
    }

    @Override
    public String getContextForRequests() {
        return "/systemagent/controlchannel";
    }

    @Override
    public void handlePostRequest(String uri, HttpServletRequest request, HttpServletResponse response) throws HandlerException, IOException {
        throw new HandlerException("Control Channel does not support POST operations");
    }

    @Override
    public void handleGetRequest(String uri, HttpServletRequest request, HttpServletResponse response) throws HandlerException, IOException {
        if (uri.startsWith("/systemagent/controlchannel/task")) {
            this.agentTaskHandler.handleTaskGetRequest(uri, response);
            return;
        }
        logger.debug("Invalid GET URL to get task version" + uri);
        RESTResponse.sendFailureResponse((HttpServletResponse)response, (String)"Invalid URI", (ILogger)iLogger);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void handlePutRequest(String uri, HttpServletRequest request, HttpServletResponse response) throws HandlerException, IOException {
        throw new HandlerException("Control Channel does not support PUT operations");
    }

    @Override
    public void handleDeleteRequest(String uri, HttpServletRequest request, HttpServletResponse response) throws HandlerException, IOException {
        throw new HandlerException("Control Channel does not support DELETE operations");
    }
}

