/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components;

import com.singularity.ee.agent.configuration.identity.IIdentityManager;
import com.singularity.ee.agent.systemagent.handler.HandlerException;
import com.singularity.ee.agent.systemagent.handler.IRequestHandler;
import com.singularity.ee.agent.systemagent.handler.RequestHandlerContext;
import com.singularity.ee.util.httpclient.HttpOperation;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AAgentComponent
implements IRequestHandler {
    private final String machineInstanceID;
    private final String controllerHost;
    private final int controllerPort;
    private final RequestHandlerContext handlerContext;
    private final String installDir;
    private final String tempDir;
    private final IAgentScheduledExecutorService scheduler;
    private final IIdentityManager identityManager;
    private final String controllerURL;
    private static Logger logger = LogManager.getLogger((String)AAgentComponent.class.getName());

    public AAgentComponent(String machineInstanceID, String controllerHost, int controllerPort, RequestHandlerContext handlerContext) throws MalformedURLException {
        this.machineInstanceID = machineInstanceID;
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.controllerURL = new URL("http", controllerHost, controllerPort, "").toExternalForm();
        this.handlerContext = handlerContext;
        this.installDir = (String)handlerContext.getAttribute("Agent-Install-Dir");
        this.tempDir = (String)handlerContext.getAttribute("Agent-Temp-Dir");
        this.scheduler = (IAgentScheduledExecutorService)handlerContext.getAttribute("Agent-Scheduler");
        this.identityManager = (IIdentityManager)handlerContext.getAttribute("Config-Manager");
    }

    @Override
    public void handleRequest(String uri, HttpServletRequest request, HttpOperation operation, HttpServletResponse response) throws HandlerException, IOException {
        if (operation == HttpOperation.POST) {
            this.handlePostRequest(uri, request, response);
            return;
        }
        if (operation == HttpOperation.PUT) {
            this.handlePutRequest(uri, request, response);
            return;
        }
        if (operation == HttpOperation.GET) {
            this.handleGetRequest(uri, request, response);
            return;
        }
        if (operation == HttpOperation.DELETE) {
            this.handleDeleteRequest(uri, request, response);
            return;
        }
        logger.warn("Invalid HTTP Operation for handler :" + String.valueOf(operation));
        throw new HandlerException("Invalid HTTP Operation " + String.valueOf(operation));
    }

    @Override
    public abstract String getContextForRequests();

    public abstract void handlePostRequest(String var1, HttpServletRequest var2, HttpServletResponse var3) throws HandlerException, IOException;

    public abstract void handlePutRequest(String var1, HttpServletRequest var2, HttpServletResponse var3) throws HandlerException, IOException;

    public abstract void handleGetRequest(String var1, HttpServletRequest var2, HttpServletResponse var3) throws HandlerException, IOException;

    public abstract void handleDeleteRequest(String var1, HttpServletRequest var2, HttpServletResponse var3) throws HandlerException, IOException;

    public abstract void shutdown();

    @Generated
    public String getMachineInstanceID() {
        return this.machineInstanceID;
    }

    @Generated
    public String getControllerHost() {
        return this.controllerHost;
    }

    @Generated
    public int getControllerPort() {
        return this.controllerPort;
    }

    @Generated
    public RequestHandlerContext getHandlerContext() {
        return this.handlerContext;
    }

    @Generated
    public String getInstallDir() {
        return this.installDir;
    }

    @Generated
    public String getTempDir() {
        return this.tempDir;
    }

    @Generated
    public IAgentScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Generated
    public IIdentityManager getIdentityManager() {
        return this.identityManager;
    }

    @Generated
    public String getControllerURL() {
        return this.controllerURL;
    }
}

