/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.api;

import com.singularity.ee.agent.systemagent.api.AJavaTask;
import com.singularity.ee.agent.systemagent.api.IStreamConsumer;
import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.TaskOutput;
import com.singularity.ee.agent.systemagent.api.exception.TaskExecutionException;
import com.singularity.ee.agent.systemagent.task.StreamReaderRunnable;
import com.singularity.ee.agent.systemagent.task.TaskThreadPools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public abstract class AForkedJavaTask
extends AJavaTask {
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final String SYSTEM_CLASSPATH = System.getProperty("java.class.path");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String JAVA_CMD = JAVA_HOME + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "java";
    private static final String JAVA_CP = "-cp";
    private Process process;
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskOutput execute(Map<String, String> taskArguments, TaskExecutionContext taskContext) throws TaskExecutionException {
        this.logger = taskContext.getLogger();
        this.preExecute(taskArguments, taskContext);
        String[] additionalClassPathEntries = taskContext.getAdditionalClasspathEntries();
        File file = new File(SYSTEM_CLASSPATH);
        StringBuilder classPath = file.isAbsolute() ? new StringBuilder(SYSTEM_CLASSPATH) : new StringBuilder("src" + File.separator + ".." + File.separator + SYSTEM_CLASSPATH);
        if (additionalClassPathEntries != null) {
            for (String additionalClassPathEntry : additionalClassPathEntries) {
                classPath.append(PATH_SEPARATOR).append(additionalClassPathEntry);
            }
        }
        ArrayList<String> jvmLaunchComamnd = new ArrayList<String>();
        jvmLaunchComamnd.add(JAVA_CMD);
        jvmLaunchComamnd.add(JAVA_CP);
        jvmLaunchComamnd.add(classPath.toString());
        jvmLaunchComamnd.add(this.getMainClass());
        String[] args = this.getProgramArguments();
        if (args != null) {
            Collections.addAll(jvmLaunchComamnd, args);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(jvmLaunchComamnd);
        processBuilder.directory(new File(taskContext.getTaskDir()));
        this.logger.info("jvmLaunchComamnd: " + String.valueOf(jvmLaunchComamnd));
        this.logger.info("task working directory: " + taskContext.getTaskDir());
        try {
            this.process = processBuilder.start();
        }
        catch (IOException e) {
            throw new TaskExecutionException(e);
        }
        StreamReaderRunnable sysOutReader = new StreamReaderRunnable(new BufferedReader(new InputStreamReader(this.process.getInputStream())));
        SysOutPrinter sysOutPrinter = new SysOutPrinter();
        sysOutReader.addStreamConsumer(sysOutPrinter);
        ScheduledFuture<?> sysOutFuture = TaskThreadPools.getVerifierThreadPool().scheduleWithFixedDelay(sysOutReader, 1000L, 100L, TimeUnit.MILLISECONDS);
        StreamReaderRunnable sysErrReader = new StreamReaderRunnable(new BufferedReader(new InputStreamReader(this.process.getErrorStream())));
        SysErrPrinter sysErrPrinter = new SysErrPrinter();
        sysErrReader.addStreamConsumer(sysErrPrinter);
        ScheduledFuture<?> sysErrFuture = TaskThreadPools.getVerifierThreadPool().scheduleWithFixedDelay(sysErrReader, 1000L, 100L, TimeUnit.MILLISECONDS);
        try {
            int processExitCode = this.process.waitFor();
            if (processExitCode != 0) {
                throw new TaskExecutionException("Task process exited with error code " + processExitCode);
            }
        }
        catch (InterruptedException e) {
            this.logger.debug("Exception while waiting for process to exit", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            sysOutPrinter.setInactive();
            sysErrPrinter.setInactive();
            sysErrFuture.cancel(true);
            sysOutFuture.cancel(true);
        }
        return new TaskOutput("Task executed successfully.");
    }

    @Override
    public void stop() {
        try {
            this.process.destroy();
        }
        catch (Exception e) {
            this.logger.info("Error while Forcing stop for forked java command", (Throwable)e);
        }
    }

    protected abstract void preExecute(Map<String, String> var1, TaskExecutionContext var2) throws TaskExecutionException;

    protected abstract String getMainClass();

    protected abstract String[] getProgramArguments();

    private class SysOutPrinter
    implements IStreamConsumer {
        private boolean active = true;

        private SysOutPrinter() {
        }

        @Override
        public void consumeLine(String line) {
            AForkedJavaTask.this.println(line);
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        void setInactive() {
            this.active = false;
        }
    }

    private class SysErrPrinter
    implements IStreamConsumer {
        private boolean active = true;

        private SysErrPrinter() {
        }

        @Override
        public void consumeLine(String line) {
            if (AForkedJavaTask.this.logger != null) {
                AForkedJavaTask.this.logger.error(line);
            }
            AForkedJavaTask.this.printlnErr(line);
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        void setInactive() {
            this.active = false;
        }
    }
}

